/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.MutexJobRule;
import com.aptana.ide.core.ui.AbstractPerspectiveFactory;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.Messages;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IFolderLayout;
import org.eclipse.ui.IPageLayout;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveFactory;
import org.eclipse.ui.IPlaceholderFolderLayout;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.internal.registry.PerspectiveDescriptor;
import org.eclipse.ui.progress.UIJob;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WebPerspectiveFactory
extends AbstractPerspectiveFactory
implements IPerspectiveFactory {
    private static final float MINIMUM_VIEW_WIDTH = 0.5f;
    private static final float MAXIMUM_VIEW_HEIGHT = 0.8f;
    private static final float MINIMUM_VIEW_HEIGHT = 0.2f;
    private static final String FILE_WIZARD_ID = "file_wizards";
    private static final String TAG_NEW_FILE_WIZARD = "new-file-wizard";
    private static final String TAG_UNTITLED_FILE_WIZARD = "untitled-file-wizard";
    private static final String ATTR_WIZARD_ID = "wizard-id";
    private static boolean showFileView = true;
    public static final int VERSION = 64;
    public static final String PERSPECTIVE_ID = "com.aptana.ide.js.ui.WebPerspective";
    public static final String DB_PERSPECTIVE_ID = "com.aptana.ide.db.PerspectiveFactory";
    public static final String RAILS_PERSPECTIVE_ID = "org.radrails.rails.ui.PerspectiveRails";
    public static final String RUBY_PERSPECTIVE_ID = "org.rubypeople.rdt.ui.PerspectiveRuby";
    private static List<Runnable> resettingHandlers;

    public static void addResettingHandler(Runnable handler) {
        if (resettingHandlers == null) {
            resettingHandlers = new ArrayList<Runnable>();
        }
        resettingHandlers.add(handler);
    }

    public void createInitialLayout(IPageLayout layout) {
        this.defineActions(layout);
        this.defineLayout(layout);
        this.addPerspectiveShortcuts(layout);
    }

    private void addPerspectiveShortcuts(IPageLayout layout) {
        layout.addPerspectiveShortcut(DB_PERSPECTIVE_ID);
    }

    private void defineLayout(IPageLayout layout) {
        IFolderLayout leftTop = layout.createFolder("leftTop", 1, 0.2f, "org.eclipse.ui.editorss");
        if (showFileView) {
            leftTop.addView("com.aptana.ide.js.ui.views.FileExplorerView");
            leftTop.addPlaceholder("com.aptana.ide.js.ui.views.FileExplorerView:*");
        }
        leftTop.addView("com.aptana.ide.core.ui.AptanaNavigator");
        leftTop.addView("com.aptana.ide.js.ui.views.profilesView");
        IFolderLayout left = layout.createFolder("left", 4, 0.5f, "leftTop");
        left.addView("com.aptana.ide.documentation.TutorialView");
        left.addView("org.eclipse.ui.views.ContentOutline");
        IPlaceholderFolderLayout right = layout.createPlaceholderFolder("right", 2, 0.8f, "org.eclipse.ui.editorss");
        right.addPlaceholder("com.aptana.ide.samples.SamplesView");
        IPlaceholderFolderLayout rightBottom = layout.createPlaceholderFolder("rightBottom", 4, 0.8f, "right");
        rightBottom.addPlaceholder("org.eclipse.eclipsemonkey.views.ScriptsView");
        rightBottom.addPlaceholder("com.aptana.ide.scripting.SnippetsView");
        IPlaceholderFolderLayout bottom = layout.createPlaceholderFolder("bottom", 4, 0.8f, "org.eclipse.ui.editorss");
        bottom.addPlaceholder("com.aptana.ide.js.ui.views.problemsView");
        bottom.addPlaceholder("org.eclipse.ui.console.ConsoleView");
        bottom.addPlaceholder("com.aptana.ide.framework.jaxer.interactiveConsole");
        bottom.addPlaceholder("com.aptana.ide.server.ui.serversView");
        bottom.addPlaceholder("com.aptana.ide.ui.ViewPlugins");
        bottom.addPlaceholder("com.aptana.ide.documentation.jquery.visualjquery");
        bottom.addPlaceholder("com.aptana.ide.js.ui.views.GenericScriptableView:*");
        bottom.addPlaceholder("com.aptana.ide.logging.LogView");
        bottom.addPlaceholder("com.aptana.ide.framework.jaxer.monitor");
        bottom.addPlaceholder("com.aptana.ide.syncing.views.SyncManagerView");
        layout.addPerspectiveShortcut(PERSPECTIVE_ID);
    }

    public static String[] getWizardShortcuts() {
        List<String> ids = WebPerspectiveFactory.getFileWizardShortcuts();
        return ids.toArray(new String[ids.size()]);
    }

    public static List<String> getProjectWizardShortcuts() {
        ArrayList<String> ids = new ArrayList<String>();
        WebPerspectiveFactory.addFromExtension(ids, TAG_NEW_FILE_WIZARD);
        Collections.sort(ids);
        ids.add("org.eclipse.ui.wizards.new.file");
        ids.add("org.eclipse.ui.wizards.new.folder");
        return ids;
    }

    public static List<String> getFileWizardShortcuts() {
        ArrayList<String> ids = new ArrayList<String>();
        WebPerspectiveFactory.addFromExtension(ids, TAG_UNTITLED_FILE_WIZARD);
        Collections.sort(ids);
        return ids;
    }

    private static void addFromExtension(List<String> ids, String elementName) {
        IExtensionPoint extensionPoint;
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        if (registry != null && (extensionPoint = registry.getExtensionPoint(CoreUIPlugin.ID, FILE_WIZARD_ID)) != null) {
            IExtension[] extensions = extensionPoint.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] elements = extension.getConfigurationElements();
                int j = 0;
                while (j < elements.length) {
                    String id;
                    IConfigurationElement element = elements[j];
                    if (element.getName().equals(elementName) && (id = element.getAttribute(ATTR_WIZARD_ID)) != null) {
                        ids.add(id);
                    }
                    ++j;
                }
                ++i;
            }
        }
    }

    private void defineActions(IPageLayout layout) {
        String[] wizards = WebPerspectiveFactory.getWizardShortcuts();
        int i = 0;
        while (i < wizards.length) {
            layout.addNewWizardShortcut(wizards[i]);
            ++i;
        }
        layout.addActionSet("com.aptana.ide.server.ui.launchActionSet");
        layout.addActionSet("org.eclipse.ui.NavigateActionSet");
        layout.addShowViewShortcut("com.aptana.ide.scripting.SnippetsView");
        layout.addShowViewShortcut("com.aptana.ide.core.ui.AptanaNavigator");
        if (showFileView) {
            layout.addShowViewShortcut("com.aptana.ide.js.ui.views.FileExplorerView");
        }
        layout.addShowViewShortcut("com.aptana.ide.js.ui.views.profilesView");
        layout.addShowViewShortcut("org.eclipse.ui.views.ContentOutline");
        layout.addShowViewShortcut("com.aptana.ide.js.ui.views.problemsView");
        layout.addShowViewShortcut("org.eclipse.ui.console.ConsoleView");
        layout.addShowViewShortcut("org.eclipse.ui.views.BookmarkView");
        layout.addShowViewShortcut("org.eclipse.ui.views.TaskList");
        layout.addShowViewShortcut("org.eclipse.ui.views.PropertySheet");
        layout.addShowViewShortcut("com.aptana.ide.syncing.views.SyncManagerView");
        layout.addShowViewShortcut("com.aptana.ide.js.docgen.views.visualscriptdoc");
        layout.addShowViewShortcut("com.aptana.ide.logging.LogView");
        layout.addShowViewShortcut("com.aptana.ide.server.ui.serversView");
    }

    public static void removeResettingHandler(Runnable handler) {
        resettingHandlers.remove(handler);
    }

    public static void resetPerspective(final IWorkbenchPage page) {
        if (Display.getCurrent() == null) {
            return;
        }
        final Shell shell = Display.getCurrent().getActiveShell();
        final Preferences p = CoreUIPlugin.getDefault().getPluginPreferences();
        if (p.getBoolean("com.aptana.ide.core.ui.WEB_PERSPECTIVE_RESET_PERSPECTIVE")) {
            return;
        }
        UIJob job = new UIJob("Resetting Aptana perspective"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                if (shell != null) {
                    p.setValue("com.aptana.ide.core.ui.WEB_PERSPECTIVE_RESETTING_PERSPECTIVE", true);
                    boolean ret = MessageDialog.openQuestion((Shell)CoreUIPlugin.getActiveWorkbenchShell(), (String)"Reset Perspective", (String)Messages.WebPerspectiveFactory_UpdatePerspectiveConfirmation);
                    p.setValue("com.aptana.ide.core.ui.WEB_PERSPECTIVE_LAST_VERSION", 64);
                    CoreUIPlugin.getDefault().savePluginPreferences();
                    if (!ret) {
                        return Status.OK_STATUS;
                    }
                    p.setValue("com.aptana.ide.core.ui.WEB_PERSPECTIVE_RESET_PERSPECTIVE", true);
                    CoreUIPlugin.getDefault().savePluginPreferences();
                    if (resettingHandlers != null) {
                        int i = 0;
                        while (i < resettingHandlers.size()) {
                            ((Runnable)resettingHandlers.get(i)).run();
                            ++i;
                        }
                    }
                    page.resetPerspective();
                    WebPerspectiveFactory.showUIHelpPage(WebPerspectiveFactory.PERSPECTIVE_ID);
                }
                return Status.OK_STATUS;
            }
        };
        job.setRule((ISchedulingRule)MutexJobRule.getInstance());
        job.setSystem(true);
        job.schedule();
    }

    public static boolean isValidAptanaPerspective(IPerspectiveDescriptor desc) {
        if (RAILS_PERSPECTIVE_ID.equals(desc.getId()) || RUBY_PERSPECTIVE_ID.equals(desc.getId()) || DB_PERSPECTIVE_ID.equals(desc.getId()) || PERSPECTIVE_ID.equals(desc.getId())) {
            return true;
        }
        if (desc instanceof PerspectiveDescriptor) {
            PerspectiveDescriptor pd = (PerspectiveDescriptor)desc;
            return pd.getOriginalId().equals(PERSPECTIVE_ID) || pd.getOriginalId().equals(RUBY_PERSPECTIVE_ID) || pd.getOriginalId().equals(RAILS_PERSPECTIVE_ID) || pd.getOriginalId().equals(DB_PERSPECTIVE_ID);
        }
        return false;
    }

    public static boolean isSameOrDescendantPerspective(IPerspectiveDescriptor desc) {
        if (desc.getId().equals(PERSPECTIVE_ID)) {
            return true;
        }
        if (desc instanceof PerspectiveDescriptor) {
            PerspectiveDescriptor pd = (PerspectiveDescriptor)desc;
            return pd.getOriginalId().equals(PERSPECTIVE_ID);
        }
        return false;
    }
}

