/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.widgets.ISelectableWidget;
import org.eclipse.jface.resource.ColorRegistry;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;

public class SWTUtils {
    private static Color _greyColor;
    private static Color _errorColor;
    private static String SMALL_FONT;
    private static String LARGE_FONT;

    static {
        SMALL_FONT = "com.aptana.ide.small_font";
        LARGE_FONT = "com.aptana.ide.large_font";
        RGB greyRGB = new RGB(200, 200, 200);
        ColorRegistry cm = JFaceResources.getColorRegistry();
        cm.put("grey", greyRGB);
        _greyColor = cm.get("grey");
        RGB errorRGB = new RGB(255, 255, 180);
        cm.put("error", errorRGB);
        _errorColor = cm.get("error");
    }

    protected SWTUtils() {
    }

    public static void colorBackground(Text widget, String testValue) {
        if (widget.getText().equals(testValue)) {
            widget.setBackground(_greyColor);
        } else {
            widget.setBackground(null);
        }
    }

    public static void setTextWidgetValue(Text widget, String text) {
        if (text == null) {
            return;
        }
        widget.setText(text);
    }

    public static void setTextWidgetValue(Text widget, String text, String def) {
        if (text == null) {
            if (def != null) {
                widget.setText(def);
            }
            return;
        }
        widget.setText(text);
    }

    public static boolean testWidgetValue(Text widget) {
        if (widget.getText() == null || "".equals(widget.getText())) {
            widget.setBackground(_errorColor);
            ModifyListener ml = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Text t = (Text)e.widget;
                    if (t.getText() != null && !"".equals(t.getText())) {
                        t.setBackground(null);
                    } else {
                        t.setBackground(_errorColor);
                    }
                }
            };
            widget.addModifyListener(ml);
            return false;
        }
        return true;
    }

    public static boolean testWidgetValue(Combo widget, int validSelectionIndex) {
        final int selectionIndex = validSelectionIndex > 0 ? validSelectionIndex : 0;
        if (widget.getText() == null || "".equals(widget.getText()) || widget.getSelectionIndex() < selectionIndex) {
            widget.setBackground(_errorColor);
            ModifyListener ml = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Combo t = (Combo)e.widget;
                    if (t.getText() != null && !"".equals(t.getText()) || t.getSelectionIndex() >= selectionIndex) {
                        t.setBackground(null);
                    } else {
                        t.setBackground(_errorColor);
                    }
                }
            };
            widget.addModifyListener(ml);
            return false;
        }
        return true;
    }

    public static boolean testWidgetValue(ISelectableWidget widget, int validSelectionIndex) {
        final int selectionIndex = validSelectionIndex > 0 ? validSelectionIndex : 0;
        if (widget.getText() == null || "".equals(widget.getText()) || widget.getSelectionIndex() < selectionIndex) {
            widget.setBackground(_errorColor);
            ModifyListener ml = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    Combo t = (Combo)e.widget;
                    if (t.getText() != null && !"".equals(t.getText()) || t.getSelectionIndex() >= selectionIndex) {
                        t.setBackground(null);
                    } else {
                        t.setBackground(_errorColor);
                    }
                }
            };
            widget.addModifyListener(ml);
            return false;
        }
        return true;
    }

    public static void centerAndPack(Shell shell, Shell parent) {
        SWTUtils.center(shell, parent);
        SWTUtils.pack(shell);
    }

    public static void center(Shell shell, Shell parent) {
        Rectangle parentSize = parent.getBounds();
        Rectangle mySize = shell.getBounds();
        int locationX = (parentSize.width - mySize.width) / 2 + parentSize.x;
        int locationY = (parentSize.height - mySize.height) / 2 + parentSize.y;
        shell.setLocation(new Point(locationX, locationY));
    }

    public static void pack(Shell shell) {
        shell.pack();
    }

    public static void setTextAsPassword(Text text) {
        char cbit = '*';
        if (CoreUIUtils.runningOnMac) {
            cbit = '\u2a2a';
        }
        text.setEchoChar(cbit);
    }

    public static void setFieldWithDefaultValue(final Text text, final String defaultValue) {
        text.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SWTUtils.colorBackground(text, defaultValue);
            }
        });
        text.setText(defaultValue);
    }

    public static void linkButtonAndField(final Button button, final Text text, final boolean clearFieldOnDisable) {
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (button.getSelection()) {
                    text.setEnabled(true);
                } else {
                    text.setEnabled(false);
                    if (clearFieldOnDisable) {
                        text.setText("");
                    }
                }
            }
        });
    }

    public static void setTableColumnWidths(Table table, double[] columnPercentages, int[] columnMinimums) {
        Rectangle area = table.getClientArea();
        if (area.width == 0) {
            return;
        }
        Point preferredSize = table.computeSize(-1, -1);
        int sideSpacer = 0;
        int spacer = table.getGridLineWidth() + table.getBorderWidth() * 2;
        int width = area.width;
        if (preferredSize.y > area.height) {
            Point vBarSize = table.getVerticalBar().getSize();
            width -= vBarSize.x;
        }
        TableColumn[] columns = table.getColumns();
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            int w = (int)((double)width * columnPercentages[i]);
            w = i < columns.length - 1 ? (w += sideSpacer) : (w += spacer);
            if (w < 20) {
                w = 20;
            }
            column.setWidth(w);
            ++i;
        }
    }

    public static double[] calculateColumnPercents(Table table, double padding) {
        int sideSpacer = 0;
        int spacer = table.getGridLineWidth() + table.getBorderWidth() * 2;
        TableColumn[] columns = table.getColumns();
        double[] newPercentages = new double[columns.length];
        double[] widths = new double[columns.length];
        double totalWidth = 0.0;
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            int width = column.getWidth();
            int spc = spacer;
            if (i < columns.length - 1) {
                spc = sideSpacer;
            }
            widths[i] = width - spc;
            totalWidth += widths[i];
            ++i;
        }
        i = 0;
        while (i < columns.length) {
            newPercentages[i] = widths[i] / totalWidth + padding;
            ++i;
        }
        return newPercentages;
    }

    public static int[] calculateColumnWidths(Table table) {
        int sideSpacer = 0;
        TableColumn[] columns = table.getColumns();
        int spacer = table.getGridLineWidth() + table.getBorderWidth() * 2;
        int[] widths = new int[columns.length];
        int i = 0;
        while (i < columns.length) {
            TableColumn column = columns[i];
            int width = column.getWidth();
            int spc = spacer;
            if (i < columns.length - 1) {
                spc = sideSpacer;
            }
            widths[i] = width - spc;
            ++i;
        }
        return widths;
    }

    public static Font getDefaultSmallFont() {
        Font small = JFaceResources.getFontRegistry().get(SMALL_FONT);
        if (small != null) {
            return small;
        }
        Font f = JFaceResources.getDefaultFont();
        FontData[] smaller = SWTUtils.resizeFont(f, -2);
        JFaceResources.getFontRegistry().put(SMALL_FONT, smaller);
        return JFaceResources.getFontRegistry().get(SMALL_FONT);
    }

    public static Font getDefaultLargeFont() {
        Font small = JFaceResources.getFontRegistry().get(LARGE_FONT);
        if (small != null) {
            return small;
        }
        Font f = JFaceResources.getDefaultFont();
        FontData[] smaller = SWTUtils.resizeFont(f, -2);
        JFaceResources.getFontRegistry().put(LARGE_FONT, smaller);
        return JFaceResources.getFontRegistry().get(LARGE_FONT);
    }

    public static FontData[] resizeFont(Font font, int size) {
        FontData[] datas = font.getFontData();
        if (datas.length > 0) {
            int i = 0;
            while (i < datas.length) {
                FontData data = datas[0];
                data.setHeight(data.getHeight() + size);
                ++i;
            }
        }
        return datas;
    }

    public static FontData[] boldFont(Font font) {
        FontData[] datas = font.getFontData();
        if (datas.length > 0) {
            int i = 0;
            while (i < datas.length) {
                FontData data = datas[i];
                data.setStyle(data.getStyle() | 1);
                ++i;
            }
        }
        return datas;
    }

    public static FontData[] italicFont(Font font) {
        FontData[] datas = font.getFontData();
        if (datas.length > 0) {
            int i = 0;
            while (i < datas.length) {
                FontData data = datas[i];
                data.setStyle(data.getStyle() | 2);
                ++i;
            }
        }
        return datas;
    }

    public static Image getImage(AbstractUIPlugin plugin, String path) {
        return SWTUtils.getImage(plugin.getBundle(), path);
    }

    public static Image getImage(Bundle bundle, String path) {
        String computedName;
        Image image;
        if (path.charAt(0) != '/') {
            path = "/" + path;
        }
        if ((image = JFaceResources.getImage((String)(computedName = String.valueOf(bundle.getSymbolicName()) + path))) != null) {
            return image;
        }
        ImageDescriptor id = AbstractUIPlugin.imageDescriptorFromPlugin((String)bundle.getSymbolicName(), (String)path);
        if (id != null) {
            JFaceResources.getImageRegistry().put(computedName, id);
            return JFaceResources.getImage((String)computedName);
        }
        return null;
    }
}

