/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.DiagnosticDialog;
import com.aptana.ide.core.ui.IDiagnosticLog;
import java.util.ArrayList;
import java.util.Collection;
import java.util.TreeMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;

public class RunDiagnosticActionDelegate
implements IWorkbenchWindowActionDelegate {
    private static final String EXTENSION_NAME = "diagnosis";
    private static final String EXTENSION_POINT = String.valueOf(CoreUIPlugin.ID) + "." + "diagnosis";
    private static final String CLASS_ATTRIBUTE = "class";
    private static final String ORDINAL_ATTRIBUTE = "ordinal";
    private static final String SUBMIT_BUG_ATTRIBUTE = "submit-bug";
    private IWorkbenchWindow fWindow;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
        this.fWindow = window;
    }

    public void run(IAction action) {
        final DiagnosticDialog dialog = new DiagnosticDialog(this.fWindow.getShell());
        dialog.open();
        Job job = new Job("Getting Diagnostic Logs"){

            protected IStatus run(IProgressMonitor monitor) {
                final String content = RunDiagnosticActionDelegate.getLogContent();
                CoreUIUtils.getDisplay().asyncExec(new Runnable(){

                    public void run() {
                        dialog.append(content);
                    }
                });
                return Status.OK_STATUS;
            }
        };
        job.setSystem(true);
        job.schedule();
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    public static String getLogContent() {
        return RunDiagnosticActionDelegate.getLogContent(false);
    }

    public static String getLogContent(boolean forSubmitBug) {
        IConfigurationElement[] elements = Platform.getExtensionRegistry().getConfigurationElementsFor(EXTENSION_POINT);
        TreeMap<Integer, ArrayList<IConfigurationElement>> ordinalElements = new TreeMap<Integer, ArrayList<IConfigurationElement>>();
        ArrayList<IConfigurationElement> otherElements = new ArrayList<IConfigurationElement>();
        IConfigurationElement[] iConfigurationElementArray = elements;
        int n = 0;
        int n2 = iConfigurationElementArray.length;
        while (n < n2) {
            block10: {
                IConfigurationElement element = iConfigurationElementArray[n];
                if (element.getName().equals(EXTENSION_NAME)) {
                    String ordinalAttr = element.getAttribute(ORDINAL_ATTRIBUTE);
                    if (ordinalAttr != null) {
                        try {
                            int ordinal = Integer.parseInt(ordinalAttr);
                            ArrayList<IConfigurationElement> elementList = (ArrayList<IConfigurationElement>)ordinalElements.get(ordinal);
                            if (elementList == null) {
                                elementList = new ArrayList<IConfigurationElement>();
                                ordinalElements.put(ordinal, elementList);
                            }
                            elementList.add(element);
                            break block10;
                        }
                        catch (NumberFormatException numberFormatException) {}
                    }
                    otherElements.add(element);
                }
            }
            ++n;
        }
        ArrayList<IConfigurationElement> list = new ArrayList<IConfigurationElement>();
        for (Integer key : ordinalElements.keySet()) {
            list.addAll((Collection)ordinalElements.get(key));
        }
        list.addAll(otherElements);
        StringBuilder content = new StringBuilder();
        for (IConfigurationElement element : list) {
            String className = element.getAttribute(CLASS_ATTRIBUTE);
            if (className == null) continue;
            try {
                String log;
                String submitBugAttr;
                Object client = element.createExecutableExtension(CLASS_ATTRIBUTE);
                if (!(client instanceof IDiagnosticLog) || forSubmitBug && (submitBugAttr = element.getAttribute(SUBMIT_BUG_ATTRIBUTE)) != null && !Boolean.parseBoolean(submitBugAttr) || (log = ((IDiagnosticLog)client).getLog()) == null || log.length() <= 0) continue;
                content.append(log);
                content.append("\n");
            }
            catch (CoreException coreException) {}
        }
        return content.toString();
    }
}

