/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.Messages;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.content.IContentType;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.LabelProvider;
import org.eclipse.ui.IEditorDescriptor;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IEditorReference;
import org.eclipse.ui.IEditorRegistry;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.dialogs.ElementListSelectionDialog;
import org.eclipse.ui.part.FileEditorInput;

class OpenFileHelper {
    IWorkbenchWindow window;

    OpenFileHelper(IWorkbenchWindow window) {
        this.window = window;
    }

    public IEditorPart open(File file) {
        String editorId = this.getEditorId(new FileInput(file));
        return this.open(editorId, file);
    }

    public IEditorPart open(IFile file) {
        String editorId = this.getEditorId(new ResourceFileInput(file));
        return this.open(editorId, file);
    }

    public IEditorPart open(String editorID, IFile file) {
        IEditorInput input = this.createEditorInput(file);
        return this.open(editorID, input);
    }

    public IEditorPart open(String editorID, File file) {
        IEditorInput input = this.createEditorInput(file);
        return this.open(editorID, input);
    }

    private IEditorPart open(String editorId, IEditorInput input) {
        try {
            IWorkbenchPage page = this.window.getActivePage();
            if (input instanceof IPathEditorInput) {
                IWorkbenchPage[] pages = this.window.getPages();
                int i = 0;
                while (i < pages.length) {
                    IEditorReference[] refs = pages[i].getEditorReferences();
                    int j = 0;
                    while (j < refs.length) {
                        try {
                            String path;
                            IPathEditorInput pathFileInput;
                            IEditorInput editorInput = refs[j].getEditorInput();
                            if (editorInput instanceof IPathEditorInput && (pathFileInput = (IPathEditorInput)editorInput) != null && pathFileInput.getPath() != null && (path = pathFileInput.getPath().toOSString()).equalsIgnoreCase(((IPathEditorInput)input).getPath().toOSString())) {
                                IEditorPart editorPart = refs[j].getEditor(true);
                                page.activate((IWorkbenchPart)editorPart);
                            }
                        }
                        catch (PartInitException e) {
                            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.WorkbenchHelper_EditorPartCannotBeActivated, (String)editorId), (Throwable)e);
                        }
                        ++j;
                    }
                    ++i;
                }
            }
            try {
                return page.openEditor(input, editorId);
            }
            catch (PartInitException e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.WorkbenchHelper_EditorPartCannotBeOpened, (String)editorId), (Throwable)e);
            }
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)(String.valueOf(Messages.WorkbenchHelper_ErrorOpeningEditor) + editorId), (Throwable)e);
        }
        return null;
    }

    private IEditorInput createEditorInput(File file) {
        IFile workspaceFile = this.getWorkspaceFile(file);
        if (workspaceFile != null) {
            return new FileEditorInput(workspaceFile);
        }
        IEditorInput input = CoreUIUtils.createJavaFileEditorInput(file);
        return input;
    }

    private IEditorInput createEditorInput(IFile file) {
        return new FileEditorInput(file);
    }

    private String getEditorId(EditorFileInput file) {
        try {
            IWorkbench workbench = this.window.getWorkbench();
            IEditorRegistry editorRegistry = workbench.getEditorRegistry();
            IEditorDescriptor descriptor = editorRegistry.getDefaultEditor(file.getName(), this.getContentType(file));
            if (descriptor != null) {
                return descriptor.getId();
            }
            return "org.eclipse.ui.DefaultTextEditor";
        }
        catch (Exception x) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.WorkbenchHelper_ErrorGettingEditorId, (Throwable)x);
            return "org.eclipse.ui.DefaultTextEditor";
        }
    }

    private IFile getWorkspaceFile(File file) {
        IFile[] files;
        block4: {
            try {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                IPath location = Path.fromOSString((String)file.getAbsolutePath());
                files = workspace.getRoot().findFilesForLocation(location);
                files = this.filterNonExistentFiles(files);
                if (files != null && files.length != 0) break block4;
                return null;
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)("getWorkspaceFile: " + e.getMessage()));
                return null;
            }
        }
        if (files.length == 1) {
            return files[0];
        }
        return this.selectWorkspaceFile(files);
    }

    private IContentType getContentType(EditorFileInput file) {
        if (file == null) {
            return null;
        }
        InputStream stream = null;
        try {
            stream = file.getInputStream();
            IContentType iContentType = Platform.getContentTypeManager().findContentTypeFor(stream, file.getName());
            return iContentType;
        }
        catch (Exception x) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.WorkbenchHelper_ErrorGettingInputStreamFromFile, (Throwable)x);
            return null;
        }
        finally {
            try {
                if (stream != null) {
                    stream.close();
                }
            }
            catch (IOException x) {
                IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.WorkbenchHelper_ErrorClosingInputStream, (Throwable)x);
            }
        }
    }

    private IFile[] filterNonExistentFiles(IFile[] files) {
        if (files == null) {
            return null;
        }
        int length = files.length;
        ArrayList<IFile> existentFiles = new ArrayList<IFile>(length);
        int i = 0;
        while (i < length) {
            if (files[i].exists()) {
                existentFiles.add(files[i]);
            }
            ++i;
        }
        return existentFiles.toArray(new IFile[existentFiles.size()]);
    }

    private IFile selectWorkspaceFile(IFile[] files) {
        ElementListSelectionDialog dialog = new ElementListSelectionDialog(this.window.getShell(), (ILabelProvider)new FileLabelProvider());
        dialog.setElements((Object[])files);
        dialog.setTitle(Messages.WorkbenchHelper_ElementListSelectionDialogTitle);
        dialog.setMessage(Messages.WorkbenchHelper_ElementListSelectionDialogMessage);
        if (dialog.open() == 0) {
            return (IFile)dialog.getFirstResult();
        }
        return null;
    }

    static class FileLabelProvider
    extends LabelProvider {
        FileLabelProvider() {
        }

        public String getText(Object element) {
            if (element instanceof IFile) {
                IPath path = ((IFile)element).getFullPath();
                return path != null ? path.toString() : "";
            }
            return super.getText(element);
        }
    }

    private static interface EditorFileInput {
        public String getName();

        public InputStream getInputStream() throws Exception;
    }

    private static class FileInput
    implements EditorFileInput {
        private File file;

        FileInput(File f) {
            this.setFile(f);
        }

        public String getName() {
            return this.getFile().getName();
        }

        public InputStream getInputStream() throws Exception {
            return new FileInputStream(this.getFile());
        }

        void setFile(File file) {
            this.file = file;
        }

        File getFile() {
            return this.file;
        }
    }

    private static class ResourceFileInput
    implements EditorFileInput {
        private IFile file;

        ResourceFileInput(IFile f) {
            this.setFile(f);
        }

        public String getName() {
            return this.getFile().getName();
        }

        public InputStream getInputStream() throws Exception {
            return this.getFile().getContents();
        }

        void setFile(IFile file) {
            this.file = file;
        }

        IFile getFile() {
            return this.file;
        }
    }
}

