/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.Messages;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.GregorianCalendar;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.browser.IWebBrowser;
import org.eclipse.ui.internal.browser.WorkbenchBrowserSupport;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.SiteManager;
import org.osgi.framework.Bundle;

public abstract class AbstractPerspectiveFactory {
    private static final String BROWSER_ID = "uimap";

    protected AbstractPerspectiveFactory() {
    }

    public static URL findPage(String fullURL) {
        Path p = new Path(fullURL);
        Bundle bundle = Platform.getBundle((String)"com.aptana.ide.core.ui");
        String rootURL = p.lastSegment();
        p = p.removeLastSegments(1);
        String baseURL = p.toPortableString();
        try {
            URL folderURL = FileLocator.find((Bundle)bundle, (IPath)new Path(baseURL), null);
            FileLocator.toFileURL((URL)folderURL);
            URL fileURL = FileLocator.find((Bundle)bundle, (IPath)new Path(String.valueOf(baseURL) + File.separatorChar + rootURL), null);
            URL contentURL = FileLocator.toFileURL((URL)fileURL);
            return contentURL;
        }
        catch (IOException iOException) {
            return null;
        }
    }

    public static String findReleaseNotesURL(IFeature feature) {
        URL featureURL = feature.getURL();
        featureURL = CoreUIUtils.trimURLSegments(featureURL, 2);
        long lastModified = AbstractPerspectiveFactory.getAptanaLastModified();
        if (featureURL != null) {
            return CoreUIUtils.joinURI(featureURL.toExternalForm(), "release_notes.html?lm=" + lastModified);
        }
        return null;
    }

    public static void showUIHelpPage(String id) {
    }

    public static void showReleaseNotes() {
        String baseUrl = "content/release_notes/";
        String rootURL = "release_notes.html";
        long lastModified = AbstractPerspectiveFactory.getAptanaLastModified();
        try {
            IWebBrowser b = WorkbenchBrowserSupport.getInstance().createBrowser(32, "release_notes", Messages.AbstractPerspectiveFactory_AptanaReleaseNotes, Messages.AbstractPerspectiveFactory_AptanaReleaseNotes);
            Bundle bundle = Platform.getBundle((String)"com.aptana.ide.core.ui");
            bundle.getLastModified();
            URL folderURL = FileLocator.find((Bundle)bundle, (IPath)new Path(baseUrl), null);
            FileLocator.toFileURL((URL)folderURL);
            URL fileUrl = FileLocator.find((Bundle)bundle, (IPath)new Path(String.valueOf(baseUrl) + rootURL), null);
            URL contentURL = FileLocator.toFileURL((URL)fileUrl);
            URL newURL = new URL(String.valueOf(contentURL.toExternalForm()) + "?lm=" + lastModified);
            b.openURL(newURL);
        }
        catch (PartInitException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AbstractPerspectiveFactory_ErrorInitializingUiHelpPage, (Throwable)e);
        }
        catch (Exception e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)Messages.AbstractPerspectiveFactory_ErrorInitializingUiHelpPage, (Throwable)e);
        }
    }

    public static long getAptanaLastModified() {
        File f = CoreUIUtils.getPluginFile((Plugin)CoreUIPlugin.getDefault());
        if (f != null) {
            return f.lastModified();
        }
        return new GregorianCalendar().getTimeInMillis();
    }

    public static IFeature[] getFeature(String id, boolean onlyConfigured) {
        Vector<IFeature> features = new Vector<IFeature>();
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            int i = 0;
            while (i < isites.length) {
                IConfiguredSite isite = isites[i];
                IFeature[] result = AbstractPerspectiveFactory.searchSite(id, isite, onlyConfigured);
                int j = 0;
                while (j < result.length) {
                    IFeature installedFeature = result[j];
                    features.add(installedFeature);
                    ++j;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)CoreUIPlugin.getDefault(), (String)e.toString());
        }
        return features.toArray(new IFeature[features.size()]);
    }

    private static IFeature[] searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        Object[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        Vector<IFeature> result = new Vector<IFeature>();
        int i = 0;
        while (i < references.length) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (featureId.equals(id)) {
                result.add(feature);
            }
            ++i;
        }
        return result.toArray(new IFeature[result.size()]);
    }
}

