/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.internal.ui;

import com.aptana.ide.core.ui.CoreUIPlugin;
import java.util.HashSet;
import java.util.Set;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.resources.IFile;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class WebFilesPropertyTester
extends PropertyTester {
    private Set<String> extensions;

    public WebFilesPropertyTester() {
        this.loadExtensions();
        CoreUIPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(new IPropertyChangeListener(){

            public void propertyChange(PropertyChangeEvent event) {
                if ("com.aptana.ide.core.ui.PREF_FILE_EXPLORER_WEB_FILES".equals(event.getProperty())) {
                    WebFilesPropertyTester.this.loadExtensions();
                }
            }
        });
    }

    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IFile && "isWebRunnable".equals(property)) {
            String ext;
            boolean value = true;
            if (expectedValue != null && expectedValue instanceof Boolean) {
                value = (Boolean)expectedValue;
            }
            if ((ext = ((IFile)receiver).getFileExtension()) != null && ext.length() > 0) {
                return this.extensions.contains(ext) == value;
            }
        }
        return false;
    }

    private void loadExtensions() {
        IPreferenceStore store = CoreUIPlugin.getDefault().getPreferenceStore();
        String[] files = store.getString("com.aptana.ide.core.ui.PREF_FILE_EXPLORER_WEB_FILES").split(";");
        this.extensions = new HashSet<String>();
        int i = 0;
        while (i < files.length) {
            String ext = files[i];
            int index = ext.lastIndexOf(46);
            if (index >= 0) {
                ext = ext.substring(index + 1);
            }
            this.extensions.add(ext);
            ++i;
        }
    }
}

