/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.update.preferences;

import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.core.ui.update.UpdateSchedulerMessages;
import com.aptana.ide.server.jetty.JettyPlugin;
import com.aptana.ide.update.Activator;
import com.aptana.ide.update.AptanaUpdatePatchProxy;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.layout.GridDataFactory;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Spinner;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;
import org.eclipse.ui.preferences.IWorkbenchPreferenceContainer;
import org.eclipse.update.internal.core.UpdateCore;

public class AutomaticUpdatesPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private Button enabledCheck;
    private Button searchOnlyRadio;
    private Button searchAndDownloadRadio;
    private Group downloadGroup;
    private Group networkConfigurationGroup;
    private Link networkConfigurationLabel;
    private Group updateTypeGroup;
    private Button currentRadio;
    private Button nextRadio;
    private Button nightlyRadio;
    private Button eclipseRadio;
    private Link changeEclipse;
    private Button developerRadio;
    private Text branchText;
    private Button fullURLRadio;
    private Text fullURLText;
    private Spinner connections_limit;
    private Spinner pause_time;

    public void init(IWorkbench workbench) {
    }

    protected Control createContents(Composite parent) {
        Composite container = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        container.setLayout((Layout)layout);
        this.enabledCheck = new Button(container, 32);
        this.enabledCheck.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_findUpdates);
        this.createSpacer(container, 1);
        GridData gd = new GridData(768);
        this.downloadGroup = new Group(container, 0);
        this.downloadGroup.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_downloadOptions);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.downloadGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        this.downloadGroup.setLayoutData((Object)gd);
        SelectionAdapter adapter = new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.pageChanged();
            }
        };
        this.searchOnlyRadio = new Button((Composite)this.downloadGroup, 16);
        this.searchOnlyRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_searchAndNotify);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchOnlyRadio.setLayoutData((Object)gd);
        this.searchOnlyRadio.addSelectionListener((SelectionListener)adapter);
        this.searchAndDownloadRadio = new Button((Composite)this.downloadGroup, 16);
        this.searchAndDownloadRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_downloadAndNotify);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.searchAndDownloadRadio.setLayoutData((Object)gd);
        this.searchAndDownloadRadio.addSelectionListener((SelectionListener)adapter);
        this.networkConfigurationGroup = new Group(container, 0);
        this.networkConfigurationGroup.setText("Network Configuration");
        GridLayout ncgLayout = new GridLayout(2, false);
        this.networkConfigurationGroup.setLayout((Layout)ncgLayout);
        this.networkConfigurationGroup.setLayoutData((Object)new GridData(4, 4, true, false));
        this.networkConfigurationLabel = new Link((Composite)this.networkConfigurationGroup, 0);
        this.networkConfigurationLabel.setText("<a>Click here</a> for more information on network update issues");
        this.networkConfigurationLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURL((String)"http://www.aptana.com/studio/redirect/?action=studio_network_troubleshooting");
            }
        });
        GridData nclData = new GridData(4, 4, true, false);
        nclData.horizontalSpan = 2;
        this.networkConfigurationLabel.setLayoutData((Object)nclData);
        Label ls1 = new Label((Composite)this.networkConfigurationGroup, 0);
        ls1.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_LimitGenericLimitFeatures);
        this.connections_limit = new Spinner((Composite)this.networkConfigurationGroup, 2048);
        this.connections_limit.setMinimum(1);
        this.connections_limit.setMaximum(10);
        this.connections_limit.setLayoutData((Object)GridDataFactory.swtDefaults().indent(0, 5).span(1, 1).create());
        Label ls2 = new Label((Composite)this.networkConfigurationGroup, 0);
        ls2.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_PAUSE_TIME);
        this.pause_time = new Spinner((Composite)this.networkConfigurationGroup, 2048);
        this.pause_time.setMinimum(1);
        this.pause_time.setMaximum(20000);
        this.pause_time.setLayoutData((Object)GridDataFactory.swtDefaults().span(1, 1).create());
        boolean isEnabled = CoreUIPlugin.isKeyValid();
        this.updateTypeGroup = new Group(container, 0);
        this.updateTypeGroup.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_WhatTypesOfUpdates);
        layout = new GridLayout();
        layout.numColumns = 3;
        this.updateTypeGroup.setLayout((Layout)layout);
        gd = new GridData(768);
        this.updateTypeGroup.setLayoutData((Object)gd);
        Label basicLabel = new Label((Composite)this.updateTypeGroup, 0);
        basicLabel.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_AptanaWillDownloadOnNextRestart);
        basicLabel.setFont(SWTUtils.getDefaultSmallFont());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalIndent = 10;
        basicLabel.setLayoutData((Object)gd);
        basicLabel.setEnabled(isEnabled);
        this.currentRadio = new Button((Composite)this.updateTypeGroup, 16);
        this.currentRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_StableReleasesOnly);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.currentRadio.setLayoutData((Object)gd);
        this.currentRadio.addSelectionListener((SelectionListener)adapter);
        this.currentRadio.setEnabled(isEnabled);
        this.nextRadio = new Button((Composite)this.updateTypeGroup, 16);
        this.nextRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_NextCandidateBuilds);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.nextRadio.setLayoutData((Object)gd);
        this.nextRadio.addSelectionListener((SelectionListener)adapter);
        this.nextRadio.setEnabled(isEnabled);
        this.nightlyRadio = new Button((Composite)this.updateTypeGroup, 16);
        this.nightlyRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_NightlyBuilds);
        gd = new GridData();
        gd.horizontalSpan = 3;
        this.nightlyRadio.setLayoutData((Object)gd);
        this.nightlyRadio.addSelectionListener((SelectionListener)adapter);
        this.nightlyRadio.setEnabled(isEnabled);
        this.eclipseRadio = new Button((Composite)this.updateTypeGroup, 16);
        this.eclipseRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_CustomUpdatePolicy);
        gd = new GridData();
        gd.horizontalSpan = 1;
        this.eclipseRadio.setLayoutData((Object)gd);
        this.eclipseRadio.addSelectionListener((SelectionListener)adapter);
        this.eclipseRadio.setEnabled(isEnabled);
        this.changeEclipse = new Link((Composite)this.updateTypeGroup, 0);
        this.changeEclipse.setText("<a>Edit</a>");
        GridData ceData = new GridData(4, 4, true, false);
        ceData.horizontalSpan = 2;
        this.changeEclipse.setLayoutData((Object)ceData);
        this.changeEclipse.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                ((IWorkbenchPreferenceContainer)AutomaticUpdatesPreferencePage.this.getContainer()).openPage("org.eclipse.update.internal.ui.preferences.MainPreferencePage", null);
            }
        });
        this.fullURLRadio = new Button((Composite)this.updateTypeGroup, 16);
        this.fullURLRadio.setText("Specify Policy URL:");
        this.fullURLRadio.setEnabled(isEnabled);
        this.fullURLRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.fullURLText.setEnabled(AutomaticUpdatesPreferencePage.this.fullURLRadio.getSelection());
            }
        });
        this.fullURLRadio.addSelectionListener((SelectionListener)adapter);
        this.fullURLText = new Text((Composite)this.updateTypeGroup, 2052);
        this.fullURLText.setEnabled(false);
        GridData futData = new GridData(4, 4, true, false);
        futData.horizontalSpan = 2;
        this.fullURLText.setLayoutData((Object)futData);
        Label developerLabel = new Label((Composite)this.updateTypeGroup, 0);
        developerLabel.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_ForAdvancedUsers);
        developerLabel.setFont(SWTUtils.getDefaultSmallFont());
        gd = new GridData();
        gd.horizontalSpan = 3;
        gd.verticalIndent = 10;
        developerLabel.setLayoutData((Object)gd);
        developerLabel.setEnabled(isEnabled);
        this.developerRadio = new Button((Composite)this.updateTypeGroup, 16);
        this.developerRadio.setText(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_SpecifyBranchName);
        gd = new GridData();
        gd.horizontalSpan = 2;
        this.developerRadio.setLayoutData((Object)gd);
        this.developerRadio.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                AutomaticUpdatesPreferencePage.this.testBranchName();
            }
        });
        this.developerRadio.setEnabled(isEnabled);
        this.branchText = new Text((Composite)this.updateTypeGroup, 2048);
        gd = new GridData();
        gd.grabExcessVerticalSpace = true;
        gd.horizontalAlignment = 4;
        this.branchText.setLayoutData((Object)gd);
        this.branchText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                AutomaticUpdatesPreferencePage.this.testBranchName();
            }
        });
        this.branchText.setEnabled(isEnabled);
        this.initialize();
        this.enabledCheck.addSelectionListener((SelectionListener)adapter);
        Dialog.applyDialogFont((Control)container);
        return container;
    }

    private void testBranchName() {
        if (this.developerRadio.getSelection() && this.branchText.getText().equals("")) {
            this.setValid(false);
            this.setErrorMessage(UpdateSchedulerMessages.AutomaticUpdatesPreferencePage_MustSpecifyBranchName);
        } else {
            this.setValid(true);
            this.setErrorMessage(null);
        }
    }

    protected void createSpacer(Composite composite, int columnSpan) {
        Label label = new Label(composite, 0);
        GridData gd = new GridData();
        gd.horizontalSpan = columnSpan;
        label.setLayoutData((Object)gd);
    }

    private void initialize() {
        Preferences pref = CoreUIPlugin.getDefault().getPluginPreferences();
        this.enabledCheck.setSelection(pref.getBoolean("enabled"));
        this.searchOnlyRadio.setSelection(!pref.getBoolean("download"));
        this.searchAndDownloadRadio.setSelection(pref.getBoolean("download"));
        pref = UpdateCore.getPlugin().getPluginPreferences();
        int maxFeatureDownloadingThreads = AptanaUpdatePatchProxy.getMaxFeatureDownloadingThreads();
        boolean hasAptanaUpdate = AptanaUpdatePatchProxy.hasAptanaUpdate();
        this.connections_limit.setEnabled(hasAptanaUpdate);
        this.connections_limit.setSelection(maxFeatureDownloadingThreads);
        this.pause_time.setSelection(AptanaUpdatePatchProxy.getPauseTime());
        this.pause_time.setEnabled(hasAptanaUpdate);
        String updateUrl = Activator.getDefault().getPreferenceStore().getString("updatePolicyURL");
        boolean useEclipse = Activator.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.update.preferences.USE_DEFAULT_ECLIPSE_PREF");
        boolean useCustom = Activator.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.update.preferences.USE_CUSTOM_POLICY_URL");
        if (useEclipse) {
            this.eclipseRadio.setSelection(true);
        } else if (useCustom) {
            this.fullURLRadio.setSelection(true);
            this.fullURLText.setEnabled(true);
            this.fullURLText.setText(updateUrl);
        } else if (updateUrl.equals("")) {
            this.currentRadio.setSelection(true);
        } else if (updateUrl.equals("http://update.aptana.com/update/next/3.2/policy.xml")) {
            this.nextRadio.setSelection(true);
        } else if (updateUrl.equals("http://update.aptana.com/update/nightly/3.2/policy.xml")) {
            this.nightlyRadio.setSelection(true);
        } else if (updateUrl.startsWith("http://build.aptana.com/update/")) {
            int length = "http://build.aptana.com/update/".length();
            this.developerRadio.setSelection(true);
            int lastSlash = updateUrl.indexOf(47, length);
            String branchName = updateUrl.substring(length, lastSlash);
            this.branchText.setText(branchName);
        } else {
            this.eclipseRadio.setSelection(true);
        }
        this.pageChanged();
    }

    private void pageChanged() {
        boolean master = this.enabledCheck.getSelection();
        this.downloadGroup.setEnabled(master);
        this.searchOnlyRadio.setEnabled(master);
        this.searchAndDownloadRadio.setEnabled(master);
        this.branchText.setEnabled(this.developerRadio.getSelection());
    }

    protected void performDefaults() {
        super.performDefaults();
        Preferences pref = CoreUIPlugin.getDefault().getPluginPreferences();
        this.enabledCheck.setSelection(pref.getDefaultBoolean("enabled"));
        this.searchOnlyRadio.setSelection(!pref.getDefaultBoolean("download"));
        this.searchAndDownloadRadio.setSelection(pref.getDefaultBoolean("download"));
        this.pageChanged();
    }

    public boolean performOk() {
        Preferences pref = CoreUIPlugin.getDefault().getPluginPreferences();
        pref.setValue("enabled", this.enabledCheck.getSelection());
        pref.setValue("schedule", "on-startup");
        pref.setValue("download", this.searchAndDownloadRadio.getSelection());
        CoreUIPlugin.getDefault().savePluginPreferences();
        IPreferenceStore store = Activator.getDefault().getPreferenceStore();
        int selection = this.connections_limit.getSelection();
        AptanaUpdatePatchProxy.setMaxFeatureDownloadingThreads(selection);
        AptanaUpdatePatchProxy.setMaxLoadingThreads(selection);
        AptanaUpdatePatchProxy.setPauseTime(this.pause_time.getSelection());
        String updateUrl = pref.getString("updatePolicyURL");
        if (this.currentRadio.getSelection()) {
            updateUrl = "";
        } else if (this.nextRadio.getSelection()) {
            updateUrl = "http://update.aptana.com/update/next/3.2/policy.xml";
        } else if (this.nightlyRadio.getSelection()) {
            updateUrl = "http://update.aptana.com/update/nightly/3.2/policy.xml";
        } else if (this.developerRadio.getSelection()) {
            updateUrl = "http://build.aptana.com/update/" + this.branchText.getText() + "/3.2/policy.xml";
        } else if (this.fullURLRadio.getSelection()) {
            updateUrl = this.fullURLText.getText();
        } else if (this.eclipseRadio.getSelection()) {
            updateUrl = "";
        }
        store.setValue("updatePolicyURL", updateUrl);
        store.setValue("com.aptana.ide.update.preferences.USE_DEFAULT_ECLIPSE_PREF", this.eclipseRadio.getSelection());
        store.setValue("com.aptana.ide.update.preferences.USE_CUSTOM_POLICY_URL", this.fullURLRadio.getSelection());
        Activator.getDefault().savePluginPreferences();
        AutomaticUpdatesPreferencePage.savePortalUpdateType();
        Activator.getScheduler().scheduleUpdateJob();
        return true;
    }

    public static void savePortalUpdateType() {
        String portalUpdateType = "production";
        IPreferenceStore prefs = Activator.getDefault().getPreferenceStore();
        String updateUrl = prefs.getString("updatePolicyURL");
        boolean useEclipse = prefs.getBoolean("com.aptana.ide.update.preferences.USE_DEFAULT_ECLIPSE_PREF");
        boolean useCustom = prefs.getBoolean("com.aptana.ide.update.preferences.USE_CUSTOM_POLICY_URL");
        if (!useEclipse && !useCustom) {
            if (updateUrl.equals("http://update.aptana.com/update/next/3.2/policy.xml")) {
                portalUpdateType = "next";
            } else if (updateUrl.equals("http://update.aptana.com/update/nightly/3.2/policy.xml")) {
                portalUpdateType = "nightly";
            } else if (updateUrl.startsWith("http://build.aptana.com/update/")) {
                String branchName;
                int length = "http://build.aptana.com/update/".length();
                int lastSlash = updateUrl.indexOf(47, length);
                portalUpdateType = branchName = updateUrl.substring(length, lastSlash);
            }
        }
        JettyPlugin.getDefault().getPreferenceStore().setValue("com.aptana.ide.server.jetty.preferences.PORTAL_UPDATE_TYPE", portalUpdateType);
    }
}

