/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.feature.update.uninstall;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.feature.update.uninstall.Messages;
import com.aptana.ide.feature.update.uninstall.SelectFeatureDialog;
import com.aptana.ide.feature.update.uninstall.UninstallFeatureModel;
import com.aptana.ide.feature.update.uninstall.UninstallLabelProvider;
import com.aptana.ide.update.Activator;
import java.util.ArrayList;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.swt.widgets.TableItem;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.swt.widgets.ToolItem;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.eclipse.update.core.ISiteFeatureReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class UpdateWidget {
    private TableViewer table;

    public Control createControl(Composite parent) {
        Label ls0 = new Label(parent, 0);
        ls0.setText(Messages.UpdateWidget_Description0);
        Label ls = new Label(parent, 0);
        GridData sa = new GridData();
        sa.verticalIndent = 10;
        ls.setLayoutData((Object)sa);
        ls.setText(Messages.UpdateWidget_SELECT_FEATURES);
        Composite body = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout(1, false);
        gridLayout.verticalSpacing = 2;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        body.setLayout((Layout)gridLayout);
        ToolBar tb = new ToolBar(body, 0);
        this.table = new TableViewer(body, 2050);
        TableColumn name = new TableColumn(this.table.getTable(), 0);
        name.setText(Messages.UpdateWidget_NAME);
        TableColumn version = new TableColumn(this.table.getTable(), 0);
        version.setText(Messages.UpdateWidget_VERSION);
        this.table.setSorter(new ViewerSorter());
        TableLayout layout = new TableLayout();
        this.table.getTable().setLayout((Layout)layout);
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(2, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, true));
        ToolItem add = new ToolItem(tb, 0);
        add.setToolTipText(Messages.UpdateWidget_ADD_FEATURE);
        tb.setLayoutData((Object)new GridData(768));
        final Image addImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)Activator.getDefault().getBundle().getSymbolicName(), (String)"/icons/add.gif").createImage();
        final Image deleteImage = AbstractUIPlugin.imageDescriptorFromPlugin((String)Activator.getDefault().getBundle().getSymbolicName(), (String)"/icons/delete.gif").createImage();
        add.setImage(addImage);
        final ToolItem remove = new ToolItem(tb, 0);
        remove.setImage(deleteImage);
        tb.addDisposeListener(new DisposeListener(){

            public void widgetDisposed(DisposeEvent e) {
                addImage.dispose();
                deleteImage.dispose();
            }
        });
        remove.setToolTipText(Messages.UpdateWidget_REMOVE_FEATURE);
        this.table.getControl().setLayoutData((Object)new GridData(1808));
        this.table.getTable().setHeaderVisible(true);
        this.table.getTable().setLinesVisible(true);
        this.table.setLabelProvider((IBaseLabelProvider)new UninstallLabelProvider());
        add.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                SelectFeatureDialog dlg = new SelectFeatureDialog(Display.getCurrent().getActiveShell(), UpdateWidget.this.getContent());
                dlg.open();
                Object[] result = dlg.getResult();
                if (result != null) {
                    Object[] objectArray = result;
                    int n = 0;
                    int n2 = objectArray.length;
                    while (n < n2) {
                        Object ref = objectArray[n];
                        UpdateWidget.this.table.add(ref);
                        ++n;
                    }
                }
            }
        });
        body.setLayoutData((Object)new GridData(1808));
        this.table.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                remove.setEnabled(!event.getSelection().isEmpty());
            }
        });
        remove.setEnabled(false);
        remove.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StructuredSelection ss = (StructuredSelection)UpdateWidget.this.table.getSelection();
                UpdateWidget.this.table.remove(ss.toArray());
            }
        });
        return body;
    }

    HashSet<Object> getContent() {
        HashSet<Object> result = new HashSet<Object>();
        TableItem[] tableItemArray = this.table.getTable().getItems();
        int n = 0;
        int n2 = tableItemArray.length;
        while (n < n2) {
            TableItem i = tableItemArray[n];
            result.add(i.getData());
            ++n;
        }
        return result;
    }

    public void init(String string) {
        this.table.getControl().setRedraw(false);
        try {
            String[] features = string.split(",");
            ArrayList<ISiteFeatureReference> featureRefs = new UninstallFeatureModel().getAllFeatures();
            String[] stringArray = features;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String s = stringArray[n];
                if ((s = s.trim()).length() > 0) {
                    ISiteFeatureReference ref;
                    String id;
                    String name;
                    if (s.charAt(s.length() - 1) == '@' && (name = this.getFeatureName(featureRefs, id = s.substring(0, s.length() - 1))) != null) {
                        StringBuilder bld = new StringBuilder();
                        bld.append(id);
                        bld.append('@');
                        bld.append(name);
                        this.table.add((Object)bld.toString());
                    }
                    if ((ref = this.getFeature(featureRefs, s)) != null) {
                        this.table.add((Object)ref);
                    }
                }
                ++n;
            }
        }
        finally {
            this.table.getControl().setRedraw(true);
        }
    }

    private String getFeatureName(ArrayList<ISiteFeatureReference> featureRefs, String s) {
        for (ISiteFeatureReference f : featureRefs) {
            try {
                String id = f.getVersionedIdentifier().getIdentifier();
                if (!id.equals(s)) continue;
                return f.getName();
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"error while deserializing features", (Throwable)e);
            }
        }
        return null;
    }

    private ISiteFeatureReference getFeature(ArrayList<ISiteFeatureReference> featureRefs, String s) {
        for (ISiteFeatureReference f : featureRefs) {
            try {
                String id = f.getVersionedIdentifier().toString();
                if (!id.equals(s)) continue;
                return f;
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"error while deserializing features", (Throwable)e);
            }
        }
        return null;
    }

    public String toString() {
        StringBuilder bld = new StringBuilder();
        TableItem[] items = this.table.getTable().getItems();
        int a = 0;
        while (a < items.length) {
            Object fr = items[a].getData();
            try {
                if (fr instanceof ISiteFeatureReference) {
                    String id = ((ISiteFeatureReference)fr).getVersionedIdentifier().toString();
                    bld.append(id);
                } else {
                    String string = fr.toString();
                    bld.append(string.substring(0, string.indexOf(64) + 1));
                }
            }
            catch (CoreException e) {
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"error while serializing features", (Throwable)e);
            }
            if (a != items.length - 1) {
                bld.append(',');
            }
            ++a;
        }
        return bld.toString();
    }

    public void clear() {
        TableItem[] items = this.table.getTable().getItems();
        Object[] elements = new Object[items.length];
        int a = 0;
        while (a < items.length) {
            elements[a] = items[a].getData();
            ++a;
        }
        this.table.remove(elements);
    }
}

