/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.feature.update.uninstall;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.feature.update.uninstall.CleanupTreeContentProvider;
import com.aptana.ide.feature.update.uninstall.FeatureSelectionDialog;
import com.aptana.ide.feature.update.uninstall.Messages;
import com.aptana.ide.feature.update.uninstall.UninstallLabelProvider;
import com.aptana.ide.update.Activator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.PluginVersionIdentifier;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.IWorkbenchWindowActionDelegate;
import org.eclipse.ui.PlatformUI;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IIncludedFeatureReference;
import org.eclipse.update.core.ISite;
import org.eclipse.update.core.ISiteFeatureReference;
import org.eclipse.update.core.SiteManager;
import org.eclipse.update.core.VersionedIdentifier;
import org.eclipse.update.internal.core.InstallRegistry;
import org.eclipse.update.internal.operations.UninstallOperation;
import org.eclipse.update.operations.OperationsManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CleanupAction
implements IWorkbenchWindowActionDelegate {
    private static final String JOB_TITLE = Messages.CleanupAction_JOB_TITLE0;

    public void dispose() {
    }

    public void init(IWorkbenchWindow window) {
    }

    public void run(IAction action) {
        HashSet<ISiteFeatureReference> toUnistall = new HashSet<ISiteFeatureReference>();
        try {
            this.gatherFeaturesToUninstall(toUnistall);
            this.removeNotUnistallingFeatures(toUnistall);
        }
        catch (CoreException e) {
            CoreUIUtils.logAndDialogError((Shell)Display.getCurrent().getActiveShell(), (Plugin)Activator.getDefault(), (String)Messages.CleanupAction_ERROR_DURING_CLEANUP, (String)Messages.CleanupAction_UNABLE_TO_GATHER, (Throwable)e);
        }
        UninstallLabelProvider uninstallLabelProvider = new UninstallLabelProvider();
        uninstallLabelProvider.useNameVersion = true;
        CleanupTreeContentProvider cleanupTreeContentProvider = new CleanupTreeContentProvider();
        FeatureSelectionDialog ls = new FeatureSelectionDialog(Display.getCurrent().getActiveShell(), (ILabelProvider)uninstallLabelProvider, cleanupTreeContentProvider);
        ls.setInput(toUnistall);
        ls.setMessage(Messages.CleanupAction_SELECT_TO_UNINSTALL);
        cleanupTreeContentProvider.getElements(toUnistall);
        ArrayList<ISiteFeatureReference> allElements = new ArrayList<ISiteFeatureReference>((Collection)cleanupTreeContentProvider.result.keySet());
        allElements.addAll(toUnistall);
        ls.setInitialSelections(allElements.toArray());
        if (ls.open() == 0) {
            Object[] actuallyUninstall = ls.getResult();
            ArrayList<ISiteFeatureReference> as = new ArrayList<ISiteFeatureReference>();
            Object[] objectArray = actuallyUninstall;
            int n = 0;
            int n2 = objectArray.length;
            while (n < n2) {
                Object o = objectArray[n];
                if (o instanceof ISiteFeatureReference) {
                    as.add((ISiteFeatureReference)o);
                }
                ++n;
            }
            this.doRealUninstall(as.toArray(new ISiteFeatureReference[as.size()]));
        }
    }

    private void doRealUninstall(final ISiteFeatureReference[] actuallyUninstall) {
        if (actuallyUninstall != null && actuallyUninstall.length >= 0) {
            Job job = new Job(JOB_TITLE){

                protected IStatus run(IProgressMonitor monitor) {
                    final ArrayList errors = new ArrayList();
                    final int total = actuallyUninstall.length;
                    monitor.beginTask(JOB_TITLE, total);
                    int uninstalled = 0;
                    int number = 0;
                    final HashSet<String> ids = new HashSet<String>();
                    ISiteFeatureReference[] iSiteFeatureReferenceArray = actuallyUninstall;
                    int n = 0;
                    int n2 = iSiteFeatureReferenceArray.length;
                    while (n < n2) {
                        ISiteFeatureReference f = iSiteFeatureReferenceArray[n];
                        if (monitor.isCanceled()) break;
                        ++number;
                        final ISiteFeatureReference ss = f;
                        try {
                            monitor.subTask(StringUtils.format((String)Messages.CleanupAction_subTaskTitle1, (Object[])new Object[]{number, total, ss.getVersionedIdentifier().toString()}));
                            UninstallOperation ssa = new UninstallOperation(null, ss.getFeature(null));
                            ssa.execute(null, null);
                            ids.add(ss.getVersionedIdentifier().getIdentifier());
                            ++uninstalled;
                        }
                        catch (CoreException e) {
                            Display.getDefault().syncExec(new Runnable(){

                                public void run() {
                                    errors.add(CleanupAction.this.logError(ss));
                                }
                            });
                            IdeLog.logError((Plugin)Activator.getDefault(), (String)"Internal error during cleanup", (Throwable)e);
                        }
                        monitor.worked(1);
                        ++n;
                    }
                    int actuallyUninstalled = uninstalled;
                    if (total != actuallyUninstalled) {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                StringBuilder bld = new StringBuilder();
                                bld.append(Messages.CleanupAction_ERRORS_REPORTED);
                                for (String s : errors) {
                                    bld.append(s);
                                    bld.append('\n');
                                }
                                String message = bld.toString();
                                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)StringUtils.format((String)Messages.CleanupAction_UNINSTALL_TITLE, (int)ids.size()), (String)message);
                            }
                        });
                    } else {
                        Display.getDefault().syncExec(new Runnable(){

                            public void run() {
                                String format = total == 1 ? StringUtils.format((String)Messages.CleanupAction_SUCCESFULLY_REMOVED, (int)total) : Messages.CleanupAction_SUCCESFULLY_REMOVED1;
                                MessageDialog.openInformation((Shell)Display.getCurrent().getActiveShell(), (String)format, (String)format);
                            }
                        });
                    }
                    monitor.done();
                    return Status.OK_STATUS;
                }
            };
            job.schedule();
            PlatformUI.getWorkbench().getProgressService().showInDialog(Display.getCurrent().getActiveShell(), job);
        }
    }

    private String logError(final ISiteFeatureReference ss) {
        try {
            Shell shell = Display.getCurrent().getActiveShell();
            String format = StringUtils.format((String)Messages.CleanupAction_ERROR_DESCRIPTION, (String)ss.getVersionedIdentifier().toString());
            MessageDialog messageDialog = new MessageDialog(shell, Messages.CleanupAction_ERROR_TITLE, null, format, 1, new String[]{IDialogConstants.OK_LABEL}, 0){

                protected Control createCustomArea(final Composite parent) {
                    Link notTryMoreLink = new Link(parent, 0);
                    notTryMoreLink.setText(Messages.CleanupAction_NEVER_UNINSTALL_LINK);
                    GridData gridData = new GridData(16384, 128, true, false);
                    gridData.horizontalIndent = 10;
                    notTryMoreLink.setLayoutData((Object)gridData);
                    notTryMoreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

                        public void widgetSelected(SelectionEvent e) {
                            String neverRemove = Activator.getDefault().getPreferenceStore().getString("neverRemove");
                            StringBuilder bld = new StringBuilder(neverRemove);
                            bld.append(',');
                            try {
                                bld.append(ss.getVersionedIdentifier().toString());
                                Activator.getDefault().getPreferenceStore().setValue("neverRemove", bld.toString());
                                this.close();
                            }
                            catch (CoreException coreException) {
                                CleanupAction.logVersioningProblem(ss);
                            }
                        }
                    });
                    parent.getDisplay().asyncExec(new Runnable(){

                        public void run() {
                            parent.getShell().setActive();
                        }
                    });
                    return notTryMoreLink;
                }
            };
            messageDialog.open();
            return format;
        }
        catch (CoreException coreException) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)StringUtils.format((String)"Unable to get versioned identifier for feature {0}", (String)ss.getName()));
            return "Internal error";
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
    }

    private void removeNotUnistallingFeatures(HashSet<ISiteFeatureReference> result) throws CoreException {
        String neverRemove = Activator.getDefault().getPreferenceStore().getString("neverRemove");
        String[] features = neverRemove.split(",");
        HashSet<Object> toRemove = new HashSet();
        for (ISiteFeatureReference fr : result) {
            String id = fr.getVersionedIdentifier().toString();
            String shortId = String.valueOf(fr.getVersionedIdentifier().getIdentifier()) + '@';
            String[] stringArray = features;
            int n = 0;
            int n2 = stringArray.length;
            while (n < n2) {
                String s = stringArray[n];
                String trim = s.trim();
                if (trim.equals(id) || trim.equals(shortId)) {
                    toRemove.add(fr);
                }
                ++n;
            }
            IStatus validatePendingUnconfig = OperationsManager.getValidator().validatePendingUnconfig(fr.getFeature(null));
            if (validatePendingUnconfig == null || validatePendingUnconfig.getCode() != 4) continue;
            toRemove.add(fr);
        }
        result.removeAll(toRemove);
        toRemove = this.removeIncludedFeatures(result);
        result.removeAll(toRemove);
    }

    private HashSet<ISiteFeatureReference> removeIncludedFeatures(HashSet<ISiteFeatureReference> result) throws CoreException {
        HashSet<ISiteFeatureReference> toRemove = new HashSet<ISiteFeatureReference>();
        for (ISiteFeatureReference f : result) {
            VersionedIdentifier versionedIdentifier = f.getVersionedIdentifier();
            if (InstallRegistry.getInstance().get((Object)("feature_" + versionedIdentifier)) == null) {
                toRemove.add(f);
                continue;
            }
            try {
                IIncludedFeatureReference[] refs;
                IFeature feature = f.getFeature(null);
                if (feature.getSite().getCurrentConfiguredSite().isConfigured(feature)) {
                    toRemove.add(f);
                }
                IIncludedFeatureReference[] iIncludedFeatureReferenceArray = refs = feature.getIncludedFeatureReferences();
                int n = 0;
                int n2 = iIncludedFeatureReferenceArray.length;
                while (n < n2) {
                    IIncludedFeatureReference fa = iIncludedFeatureReferenceArray[n];
                    VersionedIdentifier ra = fa.getVersionedIdentifier();
                    for (ISiteFeatureReference a : result) {
                        if (!a.getVersionedIdentifier().equals((Object)ra)) continue;
                        toRemove.add(a);
                    }
                    ++n;
                }
            }
            catch (CoreException e) {
                toRemove.add(f);
                IdeLog.logError((Plugin)Activator.getDefault(), (String)"Exception during attempt to unconfigure feature", (Throwable)e);
            }
        }
        return toRemove;
    }

    private void gatherFeaturesToUninstall(HashSet<ISiteFeatureReference> toUnistall) throws CoreException {
        IConfiguredSite[] sites;
        IConfiguredSite[] iConfiguredSiteArray = sites = SiteManager.getLocalSite().getCurrentConfiguration().getConfiguredSites();
        int n = 0;
        int n2 = iConfiguredSiteArray.length;
        while (n < n2) {
            ISiteFeatureReference[] frs;
            IConfiguredSite csite = iConfiguredSiteArray[n];
            HashMap<String, ArrayList<ISiteFeatureReference>> dublicate_features = new HashMap<String, ArrayList<ISiteFeatureReference>>();
            ISite site = csite.getSite();
            ISiteFeatureReference[] iSiteFeatureReferenceArray = frs = site.getFeatureReferences();
            int n3 = 0;
            int n4 = iSiteFeatureReferenceArray.length;
            while (n3 < n4) {
                ISiteFeatureReference f = iSiteFeatureReferenceArray[n3];
                VersionedIdentifier ia = f.getVersionedIdentifier();
                ArrayList<ISiteFeatureReference> fsl = (ArrayList<ISiteFeatureReference>)dublicate_features.get(ia.getIdentifier());
                if (fsl == null) {
                    fsl = new ArrayList<ISiteFeatureReference>();
                    dublicate_features.put(ia.getIdentifier(), fsl);
                }
                fsl.add(f);
                ++n3;
            }
            for (String s : dublicate_features.keySet()) {
                ArrayList pls = (ArrayList)dublicate_features.get(s);
                if (pls.size() <= 1) continue;
                ISiteFeatureReference max = null;
                for (ISiteFeatureReference e : pls) {
                    PluginVersionIdentifier pa = e.getVersionedIdentifier().getVersion();
                    if (max == null) {
                        max = e;
                        continue;
                    }
                    if (!pa.isGreaterThan(max.getVersionedIdentifier().getVersion())) continue;
                    max = e;
                }
                for (ISiteFeatureReference e : pls) {
                    if (e == max) continue;
                    toUnistall.add(e);
                }
            }
            ++n;
        }
    }

    static void logVersioningProblem(ISiteFeatureReference f) {
        IdeLog.logError((Plugin)Activator.getDefault(), (String)StringUtils.format((String)"Unable to get versioned identifier for feature {0}", (String)f.getName()));
    }
}

