/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.update;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.core.ui.CoreUIPlugin;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.update.Activator;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.internal.browser.BrowserViewer;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.core.IFeature;

public class UpdateMessageDialog
extends MessageDialog {
    private String[] initialBrowserURL = null;
    private IFeature[] features = null;
    private Shell parentShell;
    private Link networkConfigurationLabel;

    public UpdateMessageDialog(Shell parentShell, String dialogTitle, Image dialogTitleImage, String dialogMessage, int dialogImageType, String[] dialogButtonLabels, int defaultIndex, String[] initialBrowserURLs, IFeature[] features) {
        super(parentShell, dialogTitle, dialogTitleImage, dialogMessage, dialogImageType, dialogButtonLabels, defaultIndex);
        this.setShellStyle(67696);
        this.initialBrowserURL = initialBrowserURLs;
        this.features = features;
        this.parentShell = parentShell;
    }

    private final void runNowBrowserFoundDialog() {
        UIJob showErrorJob = new UIJob("Showing Error Dialog"){

            public IStatus runInUIThread(IProgressMonitor monitor) {
                CoreUIUtils.logAndDialogError((Shell)CoreUIUtils.getActiveShell(), (Plugin)Activator.getDefault(), (String)"Error: no browser found", (String)"No internal browser found.  Aptana requires an internal browser( ie. Firefox ).");
                return Status.OK_STATUS;
            }
        };
        showErrorJob.setPriority(10);
        showErrorJob.setSystem(true);
        showErrorJob.schedule();
    }

    protected Control createCustomArea(Composite parent) {
        if (this.initialBrowserURL != null && this.initialBrowserURL.length > 0) {
            Composite composite = new Composite(parent, 0);
            GridData data = new GridData(1808);
            composite.setLayoutData((Object)data);
            composite.setLayout((Layout)new GridLayout());
            this.getShell().setMinimumSize(500, 500);
            final BrowserViewer browser = new BrowserViewer(composite, 0);
            Browser tmpBrowser = browser.getBrowser();
            if (tmpBrowser == null) {
                this.runNowBrowserFoundDialog();
                return composite;
            }
            tmpBrowser.setText("<html><head></head><body style='font-size:90%;text-align:center;font-family:sans-serif;color:#AAAAAA;'>Loading...</body></html>");
            Job job = new Job("Download release notes"){

                public IStatus run(IProgressMonitor monitor) {
                    final String content = UpdateMessageDialog.this.downloadPages(UpdateMessageDialog.this.initialBrowserURL, UpdateMessageDialog.this.features);
                    IdeLog.logInfoToFile((Plugin)Activator.getDefault(), (String)"Logging content of update dialog", (String)"update", (String)".html", (String)content);
                    UIJob uiJob = new UIJob("Set browser contents"){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            try {
                                if (browser != null && !browser.isDisposed() && browser.getBrowser() != null && !browser.getBrowser().isDisposed()) {
                                    browser.getBrowser().setText(content);
                                }
                            }
                            catch (Exception e) {
                                IdeLog.logError((Plugin)Activator.getDefault(), (String)"Error setting browser contents", (Throwable)e);
                            }
                            catch (Error e) {
                                IdeLog.logError((Plugin)Activator.getDefault(), (String)"Error setting browser contents", (Throwable)e);
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.setSystem(true);
                    uiJob.schedule();
                    return Status.OK_STATUS;
                }
            };
            job.setSystem(true);
            job.schedule();
            this.networkConfigurationLabel = new Link(composite, 0);
            this.networkConfigurationLabel.setText("<a>Click here</a> for more information on network update issues");
            this.networkConfigurationLabel.addSelectionListener((SelectionListener)new SelectionAdapter(){

                public void widgetSelected(SelectionEvent e) {
                    CoreUIUtils.openBrowserURL((String)"http://www.aptana.com/studio/redirect/?action=studio_network_troubleshooting");
                }
            });
            return composite;
        }
        return null;
    }

    private String downloadPages(String[] urls, IFeature[] features) {
        String content = "<html><head><title>Update Release Notes</title><link rel=\"stylesheet\" href=\"http://ide.aptana.com/update/update.css\" type=\"text/css\" /></head><body>";
        int i = 0;
        while (i < urls.length) {
            String string = urls[i];
            IFeature feature = features[i];
            try {
                content = String.valueOf(content) + "<h2>" + feature.getLabel() + "<span class='featureInfo'>Version: " + feature.getVersionedIdentifier() + ", Size: " + feature.getInstallSize() + " KB</span></h2>";
                String result = this.downloadPage(new URL(string));
                content = result != null && !result.equals("") ? String.valueOf(content) + result : String.valueOf(content) + "<div class='nonotes'>No update notes available.</div>";
                IdeLog.logInfo((Plugin)CoreUIPlugin.getDefault(), (String)StringUtils.format((String)"Downloaded content from URL {0}", (String)string));
            }
            catch (MalformedURLException e) {
                IdeLog.logWarning((Plugin)Activator.getDefault(), (String)StringUtils.format((String)"Release notes URL {0} is malformed", (String)string), (Throwable)e);
            }
            ++i;
        }
        content = String.valueOf(content) + "</body></html>";
        return content;
    }

    private String downloadPage(URL pageUrl) {
        try {
            String line;
            URLConnection conn = pageUrl.openConnection();
            BufferedReader reader = new BufferedReader(new InputStreamReader(conn.getInputStream()));
            StringBuffer pageBuffer = new StringBuffer();
            while ((line = reader.readLine()) != null) {
                pageBuffer.append(String.valueOf(line) + "\n");
            }
            return pageBuffer.toString();
        }
        catch (Exception e) {
            IdeLog.logWarning((Plugin)Activator.getDefault(), (String)StringUtils.format((String)"Unable to download content for URL {0}", (String)pageUrl.toExternalForm()), (Throwable)e);
            return null;
        }
    }

    protected void constrainShellSize() {
        super.constrainShellSize();
        CoreUIUtils.placeDialogInScreenCenter((Shell)this.parentShell, (Shell)this.getShell());
    }
}

