/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.update;

import com.aptana.ide.core.AptanaAuthenticator;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.update.SchedulerStartup;
import com.aptana.ide.core.ui.update.UpdateUrlPatcher;
import com.aptana.ide.editors.unified.utils.UpdateURLDecoder;
import com.aptana.ide.update.Activator;
import java.io.UnsupportedEncodingException;
import java.net.Authenticator;
import java.net.MalformedURLException;
import java.net.URL;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.internal.core.UpdateCore;
import org.eclipse.update.search.UpdateSearchRequest;
import org.eclipse.update.ui.UpdateJob;

class AutomaticUpdateJob
extends UpdateJob {
    boolean showPrompt = false;

    public AutomaticUpdateJob(String name, boolean isAutomatic, boolean download) {
        super(name, isAutomatic, download);
        this.resetPolicyURL();
    }

    public static URL getUpdateMapURL() {
        String urlPref;
        IPreferenceStore pref = Activator.getDefault().getPreferenceStore();
        boolean useEclipse = Activator.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.update.preferences.USE_DEFAULT_ECLIPSE_PREF");
        if (!useEclipse && (urlPref = pref.getString("updatePolicyURL")) != null && urlPref.length() > 0) {
            try {
                String decodedURL = UpdateURLDecoder.decode((String)urlPref, (String)"UTF-8");
                return new URL(decodedURL);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {}
        }
        return null;
    }

    public AutomaticUpdateJob(String name, UpdateSearchRequest searchRequest) {
        super(name, searchRequest);
        this.resetPolicyURL();
    }

    public AutomaticUpdateJob(String name, boolean isAutomatic, boolean download, IFeature[] features, boolean showPrompt) {
        super(name, isAutomatic, download, features);
        this.resetPolicyURL();
        URL url = this.getSearchRequest().getScope().getUpdateMapURL();
        this.getSearchRequest().getScope().setUpdateMapURL(UpdateUrlPatcher.getNewPolicyURL(url));
        this.showPrompt = showPrompt;
        this.setPriority(50);
    }

    private void resetPolicyURL() {
        URL newPolicyURL = AutomaticUpdateJob.getUpdateMapURL();
        IdeLog.logInfo((Plugin)Activator.getDefault(), (String)("Policy URL: " + newPolicyURL));
        if (newPolicyURL != null && this.getSearchRequest() != null && this.getSearchRequest().getScope() != null) {
            this.getSearchRequest().getScope().setUpdateMapURL(newPolicyURL);
        }
    }

    public IStatus run(IProgressMonitor monitor) {
        AptanaAuthenticator aptanaAuth = new AptanaAuthenticator();
        Authenticator.setDefault((Authenticator)aptanaAuth);
        String value = this.getUpdateVersionsMode();
        this.setUpdateVersionsMode("compatible");
        IStatus status = super.run(monitor);
        this.setUpdateVersionsMode(value);
        return status;
    }

    private String getUpdateVersionsMode() {
        Preferences store = UpdateCore.getPlugin().getPluginPreferences();
        return store.getString("org.eclipse.update.core.updateVersions");
    }

    private void setUpdateVersionsMode(String value) {
        Preferences store = UpdateCore.getPlugin().getPluginPreferences();
        store.setValue("org.eclipse.update.core.updateVersions", value);
    }

    public boolean belongsTo(Object family) {
        return SchedulerStartup.automaticJobFamily == family;
    }
}

