/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.resources;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.resources.IHttpFolderResource;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Hashtable;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IFolder;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Plugin;

public class WorkspaceHttpFolderResource
implements IHttpFolderResource {
    IContainer _resource;
    String[] _fileNames;
    String[] _folderNames;

    public WorkspaceHttpFolderResource(IContainer resource) {
        this._resource = resource;
    }

    public InputStream getContentInputStream(HttpServer server) throws IOException {
        throw new IOException("Not a file");
    }

    public long getContentLength() {
        return -1L;
    }

    public String getContentType() {
        return null;
    }

    public String[] getFileNames() {
        if (this._fileNames == null) {
            this.loadMemberNames();
        }
        return this._fileNames;
    }

    public String[] getFolderNames() {
        if (this._folderNames == null) {
            this.loadMemberNames();
        }
        return this._folderNames;
    }

    private static IResource getResourceFromProject(IPath path, IProject project) {
        if (project.isOpen()) {
            if (path.segmentCount() == 0) {
                return project;
            }
            IResource resource = project.findMember(path);
            if (resource != null && resource.exists()) {
                return resource;
            }
        }
        return null;
    }

    private void loadMemberNames() {
        ArrayList fileList = new ArrayList();
        ArrayList folderList = new ArrayList();
        Hashtable usedNames = new Hashtable();
        this.addMemberNamesToList(this._resource, fileList, folderList, usedNames);
        try {
            IProject project = this._resource.getProject();
            if (project != null) {
                IProject[] referencedProjects = project.getReferencedProjects();
                IPath resourcePath = this._resource.getProjectRelativePath();
                int i = 0;
                while (i < referencedProjects.length) {
                    IResource referencedResource = WorkspaceHttpFolderResource.getResourceFromProject(resourcePath, referencedProjects[i]);
                    if (referencedResource instanceof IContainer) {
                        this.addMemberNamesToList((IContainer)referencedResource, fileList, folderList, usedNames);
                    }
                    ++i;
                }
            }
            Collections.sort(fileList);
            Collections.sort(folderList);
            this._fileNames = fileList.toArray(new String[0]);
            this._folderNames = folderList.toArray(new String[0]);
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)"Error in loading member names", (Throwable)e);
        }
    }

    private void addMemberNamesToList(IContainer folder, ArrayList fileList, ArrayList folderList, Hashtable usedNames) {
        try {
            IResource[] resources = folder.members();
            int i = 0;
            while (i < resources.length) {
                IResource resource = resources[i];
                if (!usedNames.contains(resource.getName())) {
                    if (resource instanceof IProject) {
                        folderList.add(resource.getName());
                    }
                    if (resource instanceof IFolder) {
                        folderList.add(resource.getName());
                    } else if (resource instanceof IFile) {
                        fileList.add(resource.getName());
                    }
                    usedNames.put(resource.getName(), resource.getName());
                }
                ++i;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)"Error in adding member names to list", (Throwable)e);
        }
    }
}

