/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.http;

import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.http.Worker;
import com.aptana.ide.server.logging.IHttpLog;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Vector;

public class ServerThreadRunnable
implements Runnable {
    private boolean _stopped;
    private HttpServer _server;
    private ServerSocket _socketServer;
    private IHttpResourceResolver _resourceResolver;
    private IHttpLog _logger;
    Vector threads = new Vector();
    int workers = 5;
    int timeout = 5000;

    public ServerThreadRunnable(HttpServer server) {
        this(server, 5000);
    }

    public ServerThreadRunnable(HttpServer server, int timeout) {
        this._server = server;
        this._socketServer = this._server.getSocketServer();
        this._resourceResolver = this._server.getResourceResolver();
        this._logger = this._server.getLogger();
        this.timeout = timeout;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        Worker w;
        int i = 0;
        while (i < this.workers) {
            w = new Worker();
            new Thread((Runnable)w, "Aptana: HTTP Worker " + i).start();
            this.threads.addElement(w);
            ++i;
        }
        while (!this._stopped && !this._socketServer.isClosed()) {
            try {
                Socket s = this._socketServer.accept();
                w = null;
                Vector vector = this.threads;
                synchronized (vector) {
                    if (this.threads.isEmpty()) {
                        Worker ws = new Worker();
                        ws.setSocket(this, s, this._server, this._resourceResolver, this._logger);
                        new Thread((Runnable)ws, "Aptana: HTTP Worker (Additional)").start();
                    } else {
                        w = (Worker)this.threads.elementAt(0);
                        this.threads.removeElementAt(0);
                        w.setSocket(this, s, this._server, this._resourceResolver, this._logger);
                    }
                }
            }
            catch (Exception e) {
                if (this._stopped && this._socketServer.isClosed()) continue;
                this._logger.logError(e.getMessage(), e);
            }
        }
    }

    public synchronized void stop() {
        if (!this._stopped) {
            this._stopped = true;
            try {
                this._socketServer.close();
            }
            catch (Exception e) {
                this._logger.logError(e.getMessage(), e);
            }
        }
    }
}

