/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.http;

import com.aptana.ide.core.SocketUtil;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.http.ServerThreadRunnable;
import com.aptana.ide.server.logging.IHttpLog;
import com.aptana.ide.server.logging.SystemHttpLog;
import com.aptana.ide.server.resolvers.FolderResourceResolver;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import java.io.File;
import java.io.IOException;
import java.net.BindException;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.SocketException;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Preferences;

public class HttpServer {
    private ServerSocket _socketServer;
    private int _portStart;
    private int _portEnd;
    private IHttpResourceResolver _resourceResolver;
    private ServerThreadRunnable _serverThreadRunnable;
    private IHttpLog _logger;
    private int _timeout = 5000;

    public IHttpLog getLogger() {
        return this._logger;
    }

    public void setLogger(IHttpLog log) {
        this._logger = log;
    }

    public IHttpResourceResolver getResourceResolver() {
        return this._resourceResolver;
    }

    public ServerSocket getSocketServer() {
        return this._socketServer;
    }

    public int getPort() {
        int result = -1;
        if (this._socketServer != null) {
            result = this._socketServer.getLocalPort();
        }
        return result;
    }

    public HttpServer(String path, int port) {
        this(new FolderResourceResolver(new File(path)), port, port);
    }

    public HttpServer(String path, int port, int endPort) {
        this(new FolderResourceResolver(new File(path)), port, endPort);
    }

    public HttpServer(IHttpResourceResolver resourceResolver, int port) {
        this(resourceResolver, port, port);
    }

    public HttpServer(IHttpResourceResolver resourceResolver, int portStartRange, int portEndRange) {
        this(resourceResolver, portStartRange, portEndRange, 5000);
    }

    public HttpServer(IHttpResourceResolver resourceResolver, int portStartRange, int portEndRange, int timeout) {
        this._resourceResolver = resourceResolver;
        this._portStart = portStartRange;
        this._portEnd = portEndRange;
        this._logger = SystemHttpLog.getInstance();
        this._timeout = timeout;
    }

    public void start() throws IOException {
        this._socketServer = this.createServerSocket(this._portStart, this._portEnd);
        this._serverThreadRunnable = new ServerThreadRunnable(this, this._timeout);
        Thread th = new Thread((Runnable)this._serverThreadRunnable, "Aptana: HTTP Server");
        th.setDaemon(true);
        th.start();
        this._logger.logTrace(StringUtils.format((String)"HttpServer listening on port {0}", (int)this.getPort()));
    }

    public void stop() throws IOException {
        this._serverThreadRunnable.stop();
    }

    private ServerSocket createServerSocket(int startRange, int endRange) throws IOException {
        ServerSocket result = null;
        SocketException exception = null;
        int failCount = 3;
        int i = startRange;
        while (i <= endRange) {
            block6: {
                try {
                    result = new ServerSocket(i, 0, null);
                    break;
                }
                catch (BindException e) {
                    exception = e;
                }
                catch (SocketException e) {
                    if (--failCount != 0) break block6;
                    exception = e;
                    break;
                }
            }
            ++i;
        }
        if (result == null) {
            if (exception == null) {
                exception = new BindException("Unable to bind to a port in the specified range: " + startRange + "-" + endRange);
            }
            throw exception;
        }
        return result;
    }

    public static String getServerAddress() {
        Preferences store = ServerCorePlugin.getDefault().getPluginPreferences();
        String serverAddress = "127.0.0.1";
        String address = store.getString("com.aptana.ide.server.core.http_server_address");
        InetAddress[] addrs = SocketUtil.getLocalAddresses();
        int i = 0;
        while (i < addrs.length) {
            if (addrs[i].getHostAddress().equals(address)) {
                serverAddress = address;
                break;
            }
            ++i;
        }
        return serverAddress;
    }

    public static int[] getPortRange() {
        Matcher matcher;
        Preferences store = ServerCorePlugin.getDefault().getPluginPreferences();
        int portsStart = 8000;
        int portsEnd = 8500;
        String ports = store.getString("com.aptana.ide.server.core.http_server_ports");
        if (ports.length() > 0 && (matcher = Pattern.compile("^(\\d+)(-(\\d+))?$").matcher(ports)).matches()) {
            try {
                int start;
                int end = start = Integer.parseInt(matcher.group(1));
                if (matcher.group(2) != null) {
                    end = Integer.parseInt(matcher.group(3));
                }
                if (start < end) {
                    portsStart = start;
                    portsEnd = end;
                }
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return new int[]{portsStart, portsEnd};
    }
}

