/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.http;

import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;
import java.util.Set;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.IPath;

public final class HttpResponseUtils {
    private HttpResponseUtils() {
    }

    static String createFileNotAccessibleMessage(IPath filePath, Set unreferencedProjects, IProject currentProject) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<H2>File is not accessible from the current project</h2>");
        pw.println("<p>The requested file was found in another workspace project that is not currently referenced this project.");
        pw.println("You need to update the project's reference settings if you would like to access this file</p>");
        pw.println("<br><b>Requested file: </b>" + filePath.toOSString());
        pw.println("<br><b>Current startup project: </b>" + currentProject.getName());
        pw.println("<p><b>Unreferenced projects containing file: </b></p>");
        pw.println("<ul>");
        Object[] projectNames = unreferencedProjects.toArray(new String[0]);
        Arrays.sort(projectNames);
        int i = 0;
        while (i < projectNames.length) {
            pw.println("<li>" + (String)projectNames[i] + "</li>");
            ++i;
        }
        pw.println("</ul>");
        pw.close();
        return sw.toString();
    }

    static String createBrowseFolderHTML(IPath parentFolder, String[] fileNames, String[] folderNames) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        pw.println("<h2>" + parentFolder.toPortableString() + "</h2>");
        pw.println("<h5>folders</h5>");
        pw.println("<ul>");
        int i = 0;
        while (i < folderNames.length) {
            pw.println("<li><a href='" + parentFolder.toPortableString() + folderNames[i] + "'>" + folderNames[i] + "</a></li>");
            ++i;
        }
        pw.println("</ul>");
        pw.println("<h5>files</h5>");
        pw.println("<ul>");
        i = 0;
        while (i < fileNames.length) {
            pw.println("<li><a href='" + parentFolder.toPortableString() + fileNames[i] + "'>" + fileNames[i] + "</a></li>");
            ++i;
        }
        pw.println("</ul>");
        pw.close();
        return sw.toString();
    }
}

