/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.http;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.http.HttpServerException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintWriter;
import java.net.SocketException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Hashtable;
import org.eclipse.core.runtime.Plugin;

public class HttpResponse {
    private static final int STATUS_OK = 200;
    private static final String STATUS_MSG_OK = "OK";
    private OutputStream _output;
    private PrintWriter _writer;
    private boolean _headerSent;

    HttpResponse(OutputStream output) {
        this._output = output;
        this._writer = new PrintWriter(output);
    }

    public void sendFileContent(InputStream input, long contentLength, String contentType) throws IOException {
        this.sendReponseHeader(200, STATUS_MSG_OK, contentLength, contentType);
        this.sendResponseContent(input);
        this._output.close();
    }

    public void sendFileContent(InputStream input, long contentLength, String contentType, Hashtable headers) throws IOException {
        this.sendReponseHeader(200, STATUS_MSG_OK, contentLength, contentType, headers);
        this.sendResponseContent(input);
        this._output.close();
    }

    public void sendContent(String content, String contentType) throws IOException {
        this.sendReponseHeader(200, STATUS_MSG_OK, -1L, contentType);
        this.sendResponseContent(content);
        this._output.close();
    }

    public void sendError(int errorCode, String message) throws IOException {
        this.sendReponseHeader(errorCode, message, -1L, null);
        this._output.close();
    }

    public void sendError(HttpServerException exception) throws IOException {
        this.sendError(exception.getStatusCode(), exception.getStatusMessage(), exception.getContent());
        this._output.close();
    }

    public void sendError(int errorCode, String message, String content) throws IOException {
        int contentLength = content != null ? content.getBytes().length : -1;
        this.sendReponseHeader(errorCode, message, contentLength, null);
        if (content != null) {
            this.sendResponseContent(content);
        }
        this._output.close();
    }

    private void sendReponseHeader(int statusCode, String statusMessage, long contentLength, String contentType) {
        this.sendReponseHeader(statusCode, statusMessage, contentLength, contentType, null);
    }

    public void sendReponseHeader(int statusCode, String statusMessage, long contentLength, String contentType, Hashtable headers) {
        if (!this._headerSent) {
            this._writer.print("HTTP/1.0 ");
            this._writer.print(statusCode);
            this._writer.print(" ");
            this._writer.println(statusMessage);
            if (contentLength > 0L) {
                this._writer.println(StringUtils.format((String)"Content-Length: {0}", (long)contentLength));
            }
            if (contentType != null) {
                this._writer.println(StringUtils.format((String)"Content-Type: {0}", (String)contentType));
            }
            SimpleDateFormat format = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zZ");
            this._writer.println("Date: " + format.format(new Date()));
            if (headers != null) {
                for (String hName : headers.keySet()) {
                    String hValue = (String)headers.get(hName);
                    this._writer.println(String.valueOf(hName) + ": " + hValue);
                }
                if (!headers.containsKey("Connection")) {
                    this._writer.println("Connection: close");
                }
            } else {
                this._writer.println("Connection: close");
            }
        } else {
            throw new IllegalStateException();
        }
        this._writer.print("\r\n");
        this._writer.flush();
        this._headerSent = true;
    }

    private void sendResponseContent(InputStream input) throws IOException {
        block3: {
            try {
                byte[] bytes = new byte[1024];
                int numRead = input.read(bytes);
                while (numRead != -1) {
                    this._output.write(bytes, 0, numRead);
                    numRead = input.read(bytes);
                }
                this._output.flush();
            }
            catch (SocketException e) {
                String msg = e.getMessage();
                if (msg.startsWith("Connection reset by peer")) break block3;
                IdeLog.logError((Plugin)ServerCorePlugin.getDefault(), (String)StringUtils.format((String)"sendResponseContent(): {0}", (String)e.getMessage()), (Throwable)e);
            }
        }
    }

    public void sendResponseContent(String content) throws IOException {
        this._output.write(content.getBytes("utf-8"));
        this._output.flush();
    }
}

