/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.core.ui.widgets.TableViewerSorter;
import com.aptana.ide.extras.Activator;
import com.aptana.ide.extras.plugins.CorePluginsViewerFilter;
import com.aptana.ide.extras.plugins.InstalledPluginsViewerFilter;
import com.aptana.ide.extras.plugins.LatestFeatureFilter;
import com.aptana.ide.extras.plugins.Plugin;
import com.aptana.ide.extras.plugins.PluginContentProvider;
import com.aptana.ide.extras.plugins.PluginLabelProvider;
import com.aptana.ide.extras.plugins.PluginListener;
import com.aptana.ide.extras.plugins.PluginMessages;
import com.aptana.ide.extras.plugins.PluginsManager;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.action.ActionContributionItem;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.ColumnLayoutData;
import org.eclipse.jface.viewers.ColumnPixelData;
import org.eclipse.jface.viewers.ColumnWeightData;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableLayout;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.CTabFolder;
import org.eclipse.swt.custom.CTabItem;
import org.eclipse.swt.custom.SashForm;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Link;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.TableColumn;
import org.eclipse.ui.IViewSite;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.progress.UIJob;
import org.eclipse.update.core.IFeatureReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PluginsView
extends ViewPart
implements ISelectionProvider,
ISelectionChangedListener {
    private static final String RELEASE_DATE_FORMAT = "yyyy-MM-dd";
    private static final String[] REMOTE_ACTION_IDS = new String[]{"com.aptana.ide.extras.plugins_view_context", "com.aptana.ide.plugins.ui.ActionInstallFeature"};
    private static final String[] INSTALLED_ACTION_IDS = new String[]{"com.aptana.ide.plugins.ui.ActionRemoveFeature", "com.aptana.ide.extras.plugins_view_context", "com.aptana.ide.plugins.ui.ActionDisableFeature", "com.aptana.ide.plugins.ui.ActionToggleLatest"};
    private static final String RELEASE_DATE = PluginMessages.PluginsView_ReleaseDate;
    private static final String DESCRIPTION = PluginMessages.PluginsView_Description;
    private static final String INSTALL = PluginMessages.PluginsView_Install;
    private static final String MANAGE = PluginMessages.PluginsView_Manage;
    private static final String NAME = PluginMessages.PluginsView_Name;
    private static final String VERSION = PluginMessages.PluginsView_Version;
    private TableViewer installedPluginsTableViewer;
    private CTabFolder tabs;
    private SashForm _outlineSash;
    private Composite _composite;
    private TableViewer remotePluginTableViewer;
    private Set<ISelectionChangedListener> listeners = new HashSet<ISelectionChangedListener>();
    private ISelection selection;
    private LatestFeatureFilter latestFilter;
    private boolean latestFilterOn;
    private PluginListener pluginsListener;

    public void createPartControl(Composite parent) {
        this._composite = this.createComposite(parent);
        this._outlineSash = this.createSash(this._composite);
        this.createTabs(this._composite);
        this.getSite().setSelectionProvider((ISelectionProvider)this);
        this.createPopupMenu(this.installedPluginsTableViewer, INSTALLED_ACTION_IDS);
        this.createPopupMenu(this.remotePluginTableViewer, REMOTE_ACTION_IDS);
        this.pluginsListener = new PluginListener(){

            public void pluginUninstalled() {
                PluginsView.this.installedPluginsTableViewer.refresh();
                PluginsView.this.remotePluginTableViewer.refresh();
            }

            public void pluginInstalled() {
                PluginsView.this.installedPluginsTableViewer.refresh();
                PluginsView.this.remotePluginTableViewer.refresh();
            }

            public void pluginDisabled() {
                PluginsView.this.installedPluginsTableViewer.refresh();
            }

            public void remotePluginsRefreshed() {
                Job fetchJob = new Job("Refreshing remote plugins"){

                    protected IStatus run(IProgressMonitor monitor) {
                        if (PluginsView.this.remotePluginTableViewer != null && PluginsView.this.remotePluginTableViewer.getContentProvider() != null) {
                            List plugins = PluginsView.this.getSortedRemotePlugins();
                            UIJob inputJob = new UIJob(this, "Updating Plugins Manager table", plugins){
                                final /* synthetic */ 1 this$2;
                                private final /* synthetic */ List val$plugins;
                                {
                                    this.this$2 = var1_1;
                                    this.val$plugins = list;
                                    super($anonymous0);
                                }

                                public IStatus runInUIThread(IProgressMonitor monitor) {
                                    PluginsView.access$1(1.access$0(1.access$0(this.this$2))).setInput((Object)this.val$plugins);
                                    return Status.OK_STATUS;
                                }
                            };
                            inputJob.schedule();
                        }
                        return Status.OK_STATUS;
                    }

                    static /* synthetic */ 1 access$0(1 var0) {
                        return var0.this;
                    }
                };
                fetchJob.setPriority(40);
                fetchJob.schedule();
            }
        };
        PluginsManager.addListener(this.pluginsListener);
        PreferenceUtils.registerBackgroundColorPreference((Control)this.installedPluginsTableViewer.getControl(), (String)"com.aptana.ide.core.ui.background.color.pluginsView");
        PreferenceUtils.registerBackgroundColorPreference((Control)this.remotePluginTableViewer.getControl(), (String)"com.aptana.ide.core.ui.background.color.pluginsView");
        PreferenceUtils.registerForegroundColorPreference((Control)this.installedPluginsTableViewer.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.pluginsView");
        PreferenceUtils.registerForegroundColorPreference((Control)this.remotePluginTableViewer.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.pluginsView");
    }

    public void dispose() {
        try {
            PluginsManager.removeListener(this.pluginsListener);
        }
        finally {
            super.dispose();
        }
    }

    private void createPopupMenu(TableViewer table, String[] ids) {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener((IMenuListener)new MyMenuListener(this.getViewSite(), ids));
        Menu menu = menuMgr.createContextMenu(table.getControl());
        table.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)table);
    }

    private Composite createComposite(Composite parent) {
        GridLayout contentAreaLayout = new GridLayout();
        contentAreaLayout.numColumns = 1;
        contentAreaLayout.makeColumnsEqualWidth = false;
        contentAreaLayout.marginHeight = 0;
        contentAreaLayout.marginWidth = 0;
        contentAreaLayout.verticalSpacing = 0;
        contentAreaLayout.horizontalSpacing = 0;
        Composite result = new Composite(parent, 0);
        result.setLayout((Layout)contentAreaLayout);
        result.setLayoutData((Object)new GridData(4, 4, true, true));
        return result;
    }

    private void createInstalledPluginsTable(Composite parent) {
        this.installedPluginsTableViewer = new TableViewer(parent, 65540);
        Table pluginsTable = this.installedPluginsTableViewer.getTable();
        pluginsTable.setHeaderVisible(true);
        pluginsTable.setLinesVisible(false);
        pluginsTable.setLayoutData((Object)new GridData(1808));
        this.createColumn(pluginsTable, "", 32);
        this.createColumn(pluginsTable, NAME, 275);
        this.createColumn(pluginsTable, VERSION, 100);
        this.installedPluginsTableViewer.setLabelProvider((IBaseLabelProvider)new PluginLabelProvider());
        this.installedPluginsTableViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        TableViewerSorter.bind((TableViewer)this.installedPluginsTableViewer);
        this.installedPluginsTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.installedPluginsTableViewer.addFilter((ViewerFilter)new CorePluginsViewerFilter());
        Job fetchJob = new Job("Fetching installed plugins"){

            protected IStatus run(IProgressMonitor monitor) {
                List<IFeatureReference> plugins = PluginsManager.getInstalledPlugins();
                final ArrayList<IFeatureReference> sorted = new ArrayList<IFeatureReference>(plugins);
                Collections.sort(sorted, new FeatureReferenceComparator());
                UIJob inputJob = new UIJob("Updating Plugins Manager table"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        PluginsView.this.installedPluginsTableViewer.setInput((Object)sorted);
                        return Status.OK_STATUS;
                    }
                };
                inputJob.schedule();
                return Status.OK_STATUS;
            }
        };
        fetchJob.setPriority(40);
        fetchJob.schedule();
        PreferenceUtils.persist((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (Table)pluginsTable, (String)"installedPlugins");
    }

    private SashForm createSash(Composite parent) {
        GridData gridData = new GridData(1808);
        gridData.exclude = true;
        SashForm result = new SashForm(parent, 512);
        result.setLayoutData((Object)gridData);
        result.setVisible(false);
        return result;
    }

    private void createTabs(Composite parent) {
        this.tabs = new CTabFolder(parent, 128);
        this.tabs.setLayoutData((Object)new GridData(1808));
        this.tabs.addSelectionListener(new SelectionListener(){

            public void widgetSelected(SelectionEvent e) {
                if (e.item instanceof CTabItem) {
                    PluginsView.this.remotePluginTableViewer.setSelection(null);
                    PluginsView.this.installedPluginsTableViewer.setSelection(null);
                }
            }

            public void widgetDefaultSelected(SelectionEvent e) {
            }
        });
        Composite links = new Composite((Composite)this.tabs, 0);
        GridLayout linksLayout = new GridLayout(1, true);
        linksLayout.marginHeight = 0;
        linksLayout.marginWidth = 0;
        links.setLayout((Layout)linksLayout);
        Link moreLink = new Link(links, 0);
        moreLink.setText("<a>More...</a>");
        moreLink.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                CoreUIUtils.openBrowserURLWithInfo((String)"http://www.aptana.com/plugins/", (boolean)true, (String)"studio_plugins");
            }
        });
        this.tabs.setTopRight((Control)links, 131072);
        CTabItem installTab = this.createInstallTab();
        this.createManageTab();
        this.tabs.setSelection(installTab);
    }

    private CTabItem createManageTab() {
        this.createTabLabel(MANAGE);
        SashForm manageForm = new SashForm((Composite)this.tabs, 0);
        manageForm.setLayoutData((Object)new GridData(1808));
        CTabItem sourceTab = new CTabItem(this.tabs, 0);
        sourceTab.setText(MANAGE);
        sourceTab.setControl((Control)manageForm);
        this.createInstalledPluginsTable((Composite)manageForm);
        return sourceTab;
    }

    private CTabItem createInstallTab() {
        this.createTabLabel(INSTALL);
        SashForm preForm = new SashForm((Composite)this.tabs, 0);
        preForm.setLayoutData((Object)new GridData(1808));
        CTabItem tab = new CTabItem(this.tabs, 0);
        tab.setText(INSTALL);
        tab.setControl((Control)preForm);
        this.createRemotePluginsTable((Composite)preForm);
        return tab;
    }

    private void createTabLabel(String label) {
        Composite previewComp = new Composite((Composite)this._outlineSash, 0);
        previewComp.setLayoutData((Object)new GridData(1808));
        Label outlineLabel = new Label(previewComp, 0);
        outlineLabel.setText(label);
        outlineLabel.setLayoutData((Object)new GridData(1808));
    }

    private void createRemotePluginsTable(Composite parent) {
        this.remotePluginTableViewer = new TableViewer(parent, 65540);
        Table pluginsTable = this.remotePluginTableViewer.getTable();
        pluginsTable.setHeaderVisible(true);
        pluginsTable.setLinesVisible(false);
        pluginsTable.setLayoutData((Object)new GridData(1808));
        this.createColumn(pluginsTable, NAME, 200);
        this.createColumn(pluginsTable, VERSION, 75);
        this.createColumn(pluginsTable, RELEASE_DATE, 100);
        this.createColumn(pluginsTable, DESCRIPTION, 250);
        TableLayout layout = new TableLayout();
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(200, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(75, true));
        layout.addColumnData((ColumnLayoutData)new ColumnPixelData(100, true));
        layout.addColumnData((ColumnLayoutData)new ColumnWeightData(1, 100, true));
        pluginsTable.setLayout((Layout)layout);
        this.remotePluginTableViewer.setLabelProvider((IBaseLabelProvider)new PluginLabelProvider(){

            public Image getColumnImage(Object element, int columnIndex) {
                return null;
            }

            public String getColumnText(Object element, int columnIndex) {
                if (columnIndex == 2) {
                    Plugin ref = (Plugin)element;
                    Calendar release = ref.getReleaseDate();
                    SimpleDateFormat format = new SimpleDateFormat(PluginsView.RELEASE_DATE_FORMAT);
                    return format.format(release.getTime());
                }
                if (columnIndex == 3) {
                    Plugin ref = (Plugin)element;
                    return ref.getDescription();
                }
                return super.getColumnText(element, columnIndex + 1);
            }
        });
        this.remotePluginTableViewer.setContentProvider((IContentProvider)new PluginContentProvider());
        TableViewerSorter.bind((TableViewer)this.remotePluginTableViewer);
        this.remotePluginTableViewer.addSelectionChangedListener((ISelectionChangedListener)this);
        this.remotePluginTableViewer.addFilter((ViewerFilter)new InstalledPluginsViewerFilter());
        Job fetchJob = new Job("Fetching remote plugins"){

            protected IStatus run(IProgressMonitor monitor) {
                final List plugins = PluginsView.this.getSortedRemotePlugins();
                UIJob inputJob = new UIJob("Updating Plugins Manager table"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        PluginsView.this.remotePluginTableViewer.setInput((Object)plugins);
                        return Status.OK_STATUS;
                    }
                };
                inputJob.schedule();
                return Status.OK_STATUS;
            }
        };
        fetchJob.setPriority(40);
        fetchJob.schedule();
        PreferenceUtils.persist((IPreferenceStore)Activator.getDefault().getPreferenceStore(), (Table)pluginsTable, (String)"remotePlugins");
    }

    private List<Plugin> getSortedRemotePlugins() {
        List<Plugin> plugins = PluginsManager.getRemotePlugins();
        ArrayList<Plugin> sorted = new ArrayList<Plugin>(plugins);
        Collections.sort(sorted, new FeatureReferenceComparator());
        return sorted;
    }

    private void createColumn(Table pluginsTable, String text, int width) {
        TableColumn nameColumn = new TableColumn(pluginsTable, 16384);
        nameColumn.setText(text);
        nameColumn.setWidth(width);
    }

    public void setFocus() {
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    public ISelection getSelection() {
        return this.selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
        this.selection = selection;
        for (ISelectionChangedListener listener : this.listeners) {
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
    }

    public void selectionChanged(SelectionChangedEvent event) {
        this.setSelection(event.getSelection());
    }

    public void toggleLatestFeatureFilter() {
        if (this.latestFilter == null) {
            this.latestFilter = new LatestFeatureFilter();
        }
        if (this.latestFilterOn) {
            this.installedPluginsTableViewer.removeFilter((ViewerFilter)this.latestFilter);
        } else {
            this.installedPluginsTableViewer.addFilter((ViewerFilter)this.latestFilter);
        }
        this.latestFilterOn = !this.latestFilterOn;
    }

    private static final class MyMenuListener
    implements IMenuListener {
        private String[] ids;
        private IViewSite fViewSite;

        public MyMenuListener(IViewSite viewSite, String[] strings) {
            this.fViewSite = viewSite;
            this.ids = strings;
        }

        public void menuAboutToShow(IMenuManager manager) {
            IContributionItem[] items = this.fViewSite.getActionBars().getToolBarManager().getItems();
            int i = 0;
            while (i < items.length) {
                ActionContributionItem aci;
                if (items[i] instanceof ActionContributionItem && !this.filtered((aci = (ActionContributionItem)items[i]).getId())) {
                    manager.add(aci.getAction());
                }
                ++i;
            }
            manager.add((IContributionItem)new Separator("additions"));
        }

        private boolean filtered(String id) {
            int i = 0;
            while (i < this.ids.length) {
                if (id.equals(this.ids[i])) {
                    return false;
                }
                ++i;
            }
            return true;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class FeatureReferenceComparator
    implements Comparator<IFeatureReference> {
        private FeatureReferenceComparator() {
        }

        @Override
        public int compare(IFeatureReference arg0, IFeatureReference arg1) {
            return arg0.getName().compareTo(arg1.getName());
        }
    }
}

