/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import com.aptana.ide.extras.Activator;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Display;
import org.osgi.framework.Bundle;

public class PluginImages {
    public static final String IMG_PLUGIN_DISABLED = "IMG_PLUGIN_DISABLED";
    public static final String IMG_PLUGIN_ENABLED = "IMG_PLUGIN_ENABLED";
    public static final String IMG_SHOW_OLD = "IMG_SHOW_OLD";
    public static final String IMG_SHOW_NEW = "IMG_SHOW_NEW";
    private static final String pluginEnabled = "icons/plugin.png";
    private static final String pluginDisabled = "icons/plugin_disabled.png";
    private static final String showNew = "icons/clock.png";
    private static final String showOld = "icons/hourglass.png";
    private static ImageRegistry imageRegistry;

    public static synchronized ImageRegistry initializeImageRegistry() {
        if (imageRegistry == null) {
            imageRegistry = new ImageRegistry(PluginImages.getStandardDisplay());
            PluginImages.declareImages();
        }
        return imageRegistry;
    }

    private static void declareImages() {
        PluginImages.declareRegistryImage(IMG_PLUGIN_DISABLED, pluginDisabled);
        PluginImages.declareRegistryImage(IMG_PLUGIN_ENABLED, pluginEnabled);
        PluginImages.declareRegistryImage(IMG_SHOW_NEW, showNew);
        PluginImages.declareRegistryImage(IMG_SHOW_OLD, showOld);
    }

    private static final void declareRegistryImage(String key, String path) {
        ImageDescriptor desc = ImageDescriptor.getMissingImageDescriptor();
        Bundle bundle = Activator.getDefault().getBundle();
        URL url = null;
        if (bundle != null) {
            url = FileLocator.find((Bundle)bundle, (IPath)new Path(path), null);
            desc = ImageDescriptor.createFromURL((URL)url);
        }
        imageRegistry.put(key, desc);
    }

    public static Display getStandardDisplay() {
        Display display = Display.getCurrent();
        if (display == null) {
            display = Display.getDefault();
        }
        return display;
    }

    public static ImageRegistry getImageRegistry() {
        if (imageRegistry == null) {
            PluginImages.initializeImageRegistry();
        }
        return imageRegistry;
    }

    public static Image getImage(String key) {
        return PluginImages.getImageRegistry().get(key);
    }

    public static ImageDescriptor getImageDescriptor(String key) {
        return PluginImages.getImageRegistry().getDescriptor(key);
    }
}

