/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.extras.Activator;
import java.util.Vector;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.update.configuration.IConfiguredSite;
import org.eclipse.update.configuration.IInstallConfiguration;
import org.eclipse.update.configuration.ILocalSite;
import org.eclipse.update.core.IFeature;
import org.eclipse.update.core.IFeatureReference;
import org.eclipse.update.core.SiteManager;

public abstract class FeatureUtil {
    public static boolean isDisabled(IFeatureReference ref) {
        try {
            IFeature feature = ref.getFeature();
            IConfiguredSite site = ref.getSite().getCurrentConfiguredSite();
            if (site != null) {
                return !site.isConfigured(feature);
            }
        }
        catch (CoreException coreException) {}
        return false;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean isInstalled(String pluginId) {
        try {
            ILocalSite localSite = SiteManager.getLocalSite();
            IInstallConfiguration config = localSite.getCurrentConfiguration();
            IConfiguredSite[] isites = config.getConfiguredSites();
            int i = 0;
            while (true) {
                if (i >= isites.length) {
                    return false;
                }
                IConfiguredSite isite = isites[i];
                if (FeatureUtil.searchSite(pluginId, isite, false)) {
                    return true;
                }
                ++i;
            }
        }
        catch (CoreException e) {
            IdeLog.logError((Plugin)Activator.getDefault(), (String)e.getMessage(), (Throwable)e);
        }
        return false;
    }

    private static boolean searchSite(String featureId, IConfiguredSite site, boolean onlyConfigured) throws CoreException {
        Object[] references = null;
        references = onlyConfigured ? site.getConfiguredFeatures() : site.getSite().getFeatureReferences();
        new Vector();
        int i = 0;
        while (i < references.length) {
            IFeature feature = references[i].getFeature(null);
            String id = feature.getVersionedIdentifier().getIdentifier();
            if (featureId.equals(id)) {
                return true;
            }
            ++i;
        }
        return false;
    }
}

