/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.extras.plugins;

import com.aptana.ide.extras.plugins.FeatureUtil;
import com.aptana.ide.extras.plugins.PluginsManager;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IObjectActionDelegate;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.update.core.IFeatureReference;

public class DisableFeatureActionDelegate
implements IObjectActionDelegate,
IViewActionDelegate {
    private IViewPart view;
    private IFeatureReference selectedFeature;

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
    }

    public void run(IAction action) {
        boolean okay = MessageDialog.openConfirm((Shell)this.view.getViewSite().getShell(), (String)"Are you sure?", (String)("Are you sure you'd like to disable " + this.selectedFeature.getName() + "?"));
        if (!okay) {
            return;
        }
        Display.getDefault().asyncExec(new Runnable(){

            public void run() {
                try {
                    PluginsManager.disable(DisableFeatureActionDelegate.this.selectedFeature.getVersionedIdentifier().getIdentifier());
                }
                catch (CoreException e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection sel;
        Object element;
        if (selection != null && !selection.isEmpty() && selection instanceof IStructuredSelection && (element = (sel = (IStructuredSelection)selection).getFirstElement()) instanceof IFeatureReference) {
            IFeatureReference ref = (IFeatureReference)element;
            URL url = ref.getURL();
            String protocol = url.getProtocol();
            if (protocol.equals("file") && !FeatureUtil.isDisabled(ref)) {
                action.setEnabled(true);
                this.selectedFeature = ref;
            } else {
                action.setEnabled(false);
            }
        }
    }

    public void init(IViewPart view) {
        this.view = view;
    }
}

