/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editor.xml.formatting;

import com.aptana.ide.editor.xml.parsing.XMLParseState;
import com.aptana.ide.editors.unified.ParentOffsetMapper;
import com.aptana.ide.lexer.Lexeme;
import com.aptana.ide.lexer.LexemeList;
import java.util.Arrays;
import java.util.Hashtable;
import java.util.Stack;
import org.eclipse.jface.preference.IPreferenceStore;

public final class XMLUtils {
    public static final int TAG_OPEN = 1;
    public static final int TAG_CLOSED = 2;
    public static final int TAG_SELF_CLOSED = 4;

    public static Lexeme getFirstLexemeBreaking(LexemeList lexemeList, int index, int[] acceptedTypes, int[] deniedTypes) {
        if (index >= lexemeList.size()) {
            return null;
        }
        int i = index;
        while (i < lexemeList.size()) {
            Lexeme currentLexeme = lexemeList.get(i);
            int j = 0;
            while (j < deniedTypes.length) {
                if (currentLexeme.typeIndex == deniedTypes[j]) {
                    return null;
                }
                ++j;
            }
            j = 0;
            while (j < acceptedTypes.length) {
                if (currentLexeme.typeIndex == acceptedTypes[j]) {
                    return currentLexeme;
                }
                ++j;
            }
            ++i;
        }
        return null;
    }

    public static Lexeme getFirstLexemeSkipping(LexemeList lexemeList, int index, int[] acceptedTypes, int[] typesToSkip) {
        if (index >= lexemeList.size()) {
            return null;
        }
        int i = index;
        while (i < lexemeList.size()) {
            block6: {
                Lexeme currentLexeme = lexemeList.get(i);
                int j = 0;
                while (j < acceptedTypes.length) {
                    if (currentLexeme.typeIndex == acceptedTypes[j]) {
                        return currentLexeme;
                    }
                    ++j;
                }
                j = 0;
                while (j < typesToSkip.length) {
                    if (currentLexeme.typeIndex != typesToSkip[j]) {
                        ++j;
                        continue;
                    }
                    break block6;
                }
                return null;
            }
            ++i;
        }
        return null;
    }

    public static boolean insideOpenTag(int offset, LexemeList lexemeList) {
        Lexeme startLexeme = XMLUtils.getTagOpenLexeme(offset, lexemeList);
        return startLexeme != null;
    }

    public static Lexeme getTagOpenLexeme(int offset, LexemeList lexemeList) {
        int index = ParentOffsetMapper.getLexemeIndexFromDocumentOffset((int)offset, (LexemeList)lexemeList);
        if (index > -1) {
            Lexeme l = lexemeList.get(index);
            return XMLUtils.getTagOpenLexeme(l, lexemeList);
        }
        return null;
    }

    public static Lexeme getTagOpenLexeme(Lexeme lexeme, LexemeList lexemeList) {
        Lexeme startTag = null;
        int position = lexemeList.getLexemeIndex(lexeme);
        while (position >= 0) {
            Lexeme curLexeme = lexemeList.get(position);
            if (curLexeme.typeIndex == 27 || curLexeme.typeIndex == 38 || curLexeme.typeIndex == 30) break;
            if (curLexeme.typeIndex == 40) {
                startTag = curLexeme;
                break;
            }
            --position;
        }
        return startTag;
    }

    private XMLUtils() {
    }

    public static Lexeme getTagCloseLexeme(int offset, LexemeList lexemeList) {
        Lexeme l = lexemeList.getCeilingLexeme(offset);
        return XMLUtils.getTagCloseLexeme(l, lexemeList);
    }

    public static Lexeme getTagCloseLexeme(Lexeme startLexeme, LexemeList lexemeList) {
        return XMLUtils.getNextLexemeOfType(startLexeme, new int[]{30, 38}, lexemeList);
    }

    public static Lexeme getNextLexemeOfType(Lexeme startLexeme, int[] lexemeTypes, LexemeList lexemeList) {
        return XMLUtils.getNextLexemeOfType(startLexeme, lexemeTypes, new int[0], lexemeList);
    }

    public static Lexeme getNextLexemeOfType(Lexeme startLexeme, int[] lexemeTypes, int[] lexemeTypesToBail, LexemeList lexemeList) {
        int index;
        Arrays.sort(lexemeTypes);
        Arrays.sort(lexemeTypesToBail);
        int i = index = lexemeList.getLexemeIndex(startLexeme);
        while (i < lexemeList.size()) {
            Lexeme l = lexemeList.get(i);
            if (Arrays.binarySearch(lexemeTypes, l.typeIndex) >= 0) {
                return l;
            }
            if (Arrays.binarySearch(lexemeTypesToBail, l.typeIndex) >= 0) {
                return null;
            }
            ++i;
        }
        return null;
    }

    /*
     * Unable to fully structure code
     */
    public static int isTagClosed(Lexeme tag, LexemeList lexemeList) {
        position = lexemeList.getLexemeIndex(tag) + 1;
        if (position >= 0) ** GOTO lbl12
        return 1;
lbl-1000:
        // 1 sources

        {
            curLexeme = lexemeList.get(position);
            if (curLexeme.typeIndex == 40 || curLexeme.typeIndex == 27) {
                return 1;
            }
            if (curLexeme.typeIndex == 38) {
                return 4;
            }
            if (curLexeme.typeIndex == 30) {
                return 2;
            }
            ++position;
lbl12:
            // 2 sources

            ** while (position < lexemeList.size())
        }
lbl13:
        // 1 sources

        return 1;
    }

    public static boolean isStartTag(Lexeme lexeme) {
        return lexeme.typeIndex == 40 || lexeme.typeIndex == 0 && lexeme.getText().equals("<");
    }

    public static boolean isEndTag(Lexeme lexeme) {
        return lexeme.typeIndex == 27 || lexeme.typeIndex == 0 && lexeme.getText().equals("</");
    }

    public static String getOpenTagName(Lexeme tag, int offset) {
        String lexemeText = tag.getText();
        if (tag.containsOffset(offset) && offset > tag.offset) {
            lexemeText = lexemeText.substring(0, offset - tag.offset);
        }
        String tempName = XMLUtils.stripTagEndings(lexemeText);
        return tempName;
    }

    public static String stripTagEndings(String tag) {
        String tempName = tag.replaceAll("</", "");
        tempName = tempName.replaceAll(">", "");
        return tempName.replaceAll("<", "");
    }

    public static String createOpenTag(String tagName, boolean close) {
        String temp = "<" + XMLUtils.stripTagEndings(tagName);
        if (close) {
            return String.valueOf(temp) + ">";
        }
        return temp;
    }

    public static String createSelfClosedTag(String tagName) {
        String temp = "<" + XMLUtils.stripTagEndings(tagName);
        return String.valueOf(temp) + " />";
    }

    public static String createCloseTag(Lexeme tag, boolean close) {
        if (tag.typeIndex == 40) {
            return XMLUtils.createCloseTag(tag.getText().substring(1), close);
        }
        return null;
    }

    public static String createCloseTag(String tagName, boolean close) {
        String temp = "</" + XMLUtils.stripTagEndings(tagName);
        if (close) {
            return String.valueOf(temp) + ">";
        }
        return temp;
    }

    public static String createCloseTag(Lexeme tag, int offset, boolean close) {
        String tempName = XMLUtils.getOpenTagName(tag, offset);
        return XMLUtils.createCloseTag(tempName, close);
    }

    public static String quoteAttributeValue(IPreferenceStore store, String value) {
        String quoteChar = "";
        return String.valueOf(quoteChar) + value + quoteChar;
    }

    public static boolean insertEquals(IPreferenceStore store) {
        if (store != null) {
            return store.getBoolean("com.aptana.ide.editor.html.HTMLEDITOR_INSERT_EQUALS");
        }
        return false;
    }

    public static Hashtable gatherAttributes(Lexeme openTagLexeme, Lexeme closeTagLexeme, LexemeList lexemeList) {
        Hashtable<String, String> h = new Hashtable<String, String>();
        if (openTagLexeme == null || closeTagLexeme == null) {
            return h;
        }
        int startIndex = lexemeList.getLexemeIndex(openTagLexeme);
        int endIndex = lexemeList.size() - 1;
        if (closeTagLexeme != null) {
            endIndex = lexemeList.getLexemeIndex(closeTagLexeme);
        }
        if (startIndex > endIndex) {
            throw new IndexOutOfBoundsException("");
        }
        String currentName = null;
        boolean foundEquals = false;
        boolean foundQuote = false;
        while (startIndex < endIndex) {
            Lexeme l = lexemeList.get(++startIndex);
            if (l.typeIndex == 42 && !foundEquals) {
                currentName = l.getText();
                continue;
            }
            if (l.typeIndex == 29) {
                foundEquals = true;
                continue;
            }
            if (l.typeIndex == 43 || foundEquals && l.typeIndex == 42) {
                foundEquals = false;
                if (currentName == null || h.containsKey(currentName)) continue;
                h.put(currentName, l.getText());
                continue;
            }
            if (l.typeIndex != 43) continue;
            if (foundQuote) {
                foundQuote = false;
                foundEquals = false;
                if (currentName == null || h.containsKey(currentName)) continue;
                h.put(currentName, "");
                continue;
            }
            foundQuote = true;
        }
        return h;
    }

    public static boolean insideQuotedString(Lexeme lexeme, int offset) {
        String text = lexeme.getText();
        return (text.startsWith("\"") || text.startsWith("'")) && lexeme.containsOffset(offset);
    }

    public static Lexeme getPreviousUnclosedTag(Lexeme lexeme, LexemeList lexemeList, XMLParseState parseState) {
        if (lexeme == null) {
            return null;
        }
        int position = lexemeList.getLexemeIndex(lexeme) - 1;
        Lexeme startTag = null;
        boolean selfClosed = false;
        Stack<Lexeme> tags = new Stack<Lexeme>();
        while (position >= 0) {
            Lexeme curLexeme = lexemeList.get(position);
            if (curLexeme.typeIndex == 27) {
                tags.push(curLexeme);
            }
            if (curLexeme.typeIndex == 38) {
                selfClosed = true;
            }
            if (curLexeme.typeIndex == 40) {
                if (selfClosed) {
                    selfClosed = false;
                    --position;
                    continue;
                }
                if (tags.size() == 0) {
                    return curLexeme;
                }
                Lexeme l = (Lexeme)tags.pop();
                if (l.typeIndex == 38) {
                    --position;
                    continue;
                }
                --position;
                continue;
            }
            --position;
        }
        return startTag;
    }

    public static boolean isStartTagBalanced(Lexeme tag, LexemeList lexemeList, XMLParseState parseState) {
        int index = lexemeList.getLexemeIndex(tag);
        if (index == lexemeList.size() - 1) {
            return false;
        }
        if (tag == null || lexemeList == null || parseState == null) {
            throw new IllegalArgumentException("null arguments are not accepted");
        }
        if (!XMLUtils.isStartTag(tag)) {
            return false;
        }
        if (XMLUtils.isTagSelfClosed(tag, lexemeList)) {
            return true;
        }
        String originalTagName = XMLUtils.stripTagEndings(tag.getText());
        int balance = 0;
        boolean trackingClose = false;
        int i = 0;
        while (i < lexemeList.size()) {
            String currenTagName;
            Lexeme currentLexeme = lexemeList.get(i);
            if (XMLUtils.isStartTag(currentLexeme)) {
                currenTagName = XMLUtils.stripTagEndings(currentLexeme.getText());
                if (originalTagName.equals(currenTagName)) {
                    trackingClose = true;
                }
            } else if (XMLUtils.isEndTag(currentLexeme)) {
                if (trackingClose) {
                    ++balance;
                    trackingClose = false;
                }
                if (originalTagName.equals(currenTagName = XMLUtils.stripTagEndings(currentLexeme.getText()))) {
                    --balance;
                }
            } else if (trackingClose) {
                if (currentLexeme.typeIndex == 40 || currentLexeme.typeIndex == 27) {
                    ++balance;
                    trackingClose = false;
                } else if (currentLexeme.typeIndex == 38) {
                    trackingClose = false;
                } else if (currentLexeme.typeIndex == 30) {
                    ++balance;
                    trackingClose = false;
                }
            }
            ++i;
        }
        return balance <= 0;
    }

    /*
     * Unable to fully structure code
     */
    public static boolean isTagSelfClosed(Lexeme tag, LexemeList lexemeList) {
        if (!XMLUtils.isStartTag(tag)) {
            return false;
        }
        position = lexemeList.getLexemeIndex(tag) + 1;
        if (position >= 0) ** GOTO lbl16
        return false;
lbl-1000:
        // 1 sources

        {
            curLexeme = lexemeList.get(position);
            if (curLexeme.typeIndex == 38) {
                return true;
            }
            if (curLexeme.typeIndex == 27) {
                return false;
            }
            if (curLexeme.typeIndex == 30) {
                return false;
            }
            if (curLexeme.typeIndex == 40) {
                return false;
            }
            ++position;
lbl16:
            // 2 sources

            ** while (position < lexemeList.size())
        }
lbl17:
        // 1 sources

        return false;
    }
}

