/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.views.actions;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerPatcher;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.ServerPatchers;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.ui.IConfigurationDialog;
import com.aptana.ide.server.ui.ServerDialogPageRegistry;
import com.aptana.ide.server.ui.ServerImagesRegistry;
import com.aptana.ide.server.ui.ServerPatchingWizard;
import com.aptana.ide.server.ui.ServerUIPlugin;
import com.aptana.ide.server.ui.views.Messages;
import com.aptana.ide.server.ui.views.actions.ICanAdd;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;

public final class NewServerAction
extends Action {
    private final IServerType type;
    private IServer createdServer = null;

    public NewServerAction(IServerType type) {
        this.type = type;
        this.setImageDescriptor(ServerImagesRegistry.getInstance().getDescriptor(type));
        String format = StringUtils.format((String)Messages.ServersView_CONNECT, (String)type.getName());
        this.setToolTipText(format);
        this.setText(format);
    }

    public String getCreatedServerID() {
        if (this.createdServer != null) {
            return this.createdServer.getId();
        }
        return null;
    }

    public void run() {
        try {
            ICanAdd adapter = (ICanAdd)this.type.getAdapter(ICanAdd.class);
            if (adapter != null) {
                adapter.doAdd();
                return;
            }
            IConfigurationDialog dialog = ServerDialogPageRegistry.getInstance().getDialog(this.type.getId());
            dialog.setConfiguration(ServerManager.getInstance().getInitialServerConfiguration(this.type.getId()));
            dialog.setEdit(false);
            Dialog dialog3 = dialog.getDialog();
            int open = dialog3.open();
            if (open == 0) {
                IAbstractConfiguration configuration = dialog.getConfiguration();
                this.createdServer = ServerManager.getInstance().addServer(configuration);
                List patchers = ServerPatchers.getPatchers((String)this.createdServer.getServerType().getId());
                if (patchers != null && patchers.size() != 0) {
                    ArrayList<IServerPatcher> requiredPatchers = new ArrayList<IServerPatcher>();
                    for (IServerPatcher patcher : patchers) {
                        if (!patcher.checkPatchRequired(this.createdServer)) continue;
                        requiredPatchers.add(patcher);
                    }
                    if (requiredPatchers.size() != 0) {
                        ServerPatchingWizard wizard = new ServerPatchingWizard(this.createdServer.getName(), requiredPatchers);
                        WizardDialog wizardDialog = new WizardDialog(Display.getDefault().getActiveShell(), (IWizard)wizard);
                        wizardDialog.create();
                        int result = wizardDialog.open();
                        if (result == 0) {
                            for (IServerPatcher patcher : requiredPatchers) {
                                if (!patcher.isConfigured()) continue;
                                patcher.applyPatch(this.createdServer);
                            }
                        }
                    }
                }
            }
        }
        catch (Exception e) {
            MessageDialog.openError((Shell)Display.getCurrent().getActiveShell(), (String)"Error while adding server", (String)e.getMessage());
            IdeLog.log((Plugin)ServerUIPlugin.getDefault(), (int)4, (String)"exception while opening new server dialog", (Throwable)e);
        }
    }
}

