/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.preferences;

import com.aptana.ide.core.SocketUtil;
import com.aptana.ide.server.core.ServerCorePlugin;
import com.aptana.ide.server.ui.preferences.Messages;
import java.net.InetAddress;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.Preferences;
import org.eclipse.jface.preference.PreferencePage;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPreferencePage;

public class HTTPServerPreferencePage
extends PreferencePage
implements IWorkbenchPreferencePage {
    private static final Pattern PORTS_PATTERN = Pattern.compile("^(\\d+)(-(\\d+))?$");
    private Preferences store = this.getPreferences();
    private Combo address;
    private Text ports;

    public HTTPServerPreferencePage() {
    }

    public HTTPServerPreferencePage(String title) {
        super(title);
    }

    public HTTPServerPreferencePage(String title, ImageDescriptor image) {
        super(title, image);
    }

    protected Control createContents(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setFont(parent.getFont());
        composite.setLayout((Layout)new GridLayout());
        composite.setLayoutData((Object)new GridData(768));
        Group group = new Group(composite, 0);
        group.setText(Messages.HTTPServerPreferencePage_BuiltinHTTPServer);
        group.setLayoutData((Object)new GridData(768));
        group.setLayout((Layout)new GridLayout(2, false));
        Label label = new Label((Composite)group, 0);
        label.setText(Messages.HTTPServerPreferencePage_IPAddress);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.address = new Combo((Composite)group, 8);
        GridData data = new GridData(16384, 0x1000000, false, false);
        data.widthHint = 140;
        this.address.setLayoutData((Object)data);
        InetAddress[] addresses = SocketUtil.getLocalAddresses();
        int i = 0;
        while (i < addresses.length) {
            this.address.add(addresses[i].getHostAddress());
            ++i;
        }
        label = new Label((Composite)group, 0);
        label.setText(Messages.HTTPServerPreferencePage_PortsLabel);
        label.setLayoutData((Object)new GridData(131072, 0x1000000, false, false));
        this.ports = new Text((Composite)group, 2048);
        data = new GridData(16384, 0x1000000, false, false);
        data.widthHint = 100;
        this.ports.setLayoutData((Object)data);
        this.ports.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                String message = Messages.HTTPServerPreferencePage_EnterValidPort;
                Matcher matcher = PORTS_PATTERN.matcher(((Text)e.widget).getText());
                if (matcher.matches()) {
                    try {
                        int start = Integer.parseInt(matcher.group(1));
                        if (matcher.group(2) != null) {
                            int end = Integer.parseInt(matcher.group(3));
                            if (start < end) {
                                message = null;
                            }
                        } else {
                            message = null;
                        }
                    }
                    catch (NumberFormatException numberFormatException) {}
                }
                HTTPServerPreferencePage.this.setErrorMessage(message);
                HTTPServerPreferencePage.this.setValid(message == null);
            }
        });
        this.setInitialValues();
        return composite;
    }

    public void init(IWorkbench workbench) {
    }

    protected Preferences getPreferences() {
        return ServerCorePlugin.getDefault().getPluginPreferences();
    }

    protected void performDefaults() {
        this.setDefaultValues();
    }

    public boolean performOk() {
        this.setValues();
        return super.performOk();
    }

    private void setAddressValue(String value) {
        String[] items = this.address.getItems();
        this.address.deselectAll();
        int i = 0;
        while (i < items.length) {
            if (items[i].equals(value)) {
                this.address.select(i);
                break;
            }
            ++i;
        }
    }

    private void setInitialValues() {
        this.setAddressValue(this.store.getString("com.aptana.ide.server.core.http_server_address"));
        this.ports.setText(this.store.getString("com.aptana.ide.server.core.http_server_ports"));
    }

    private void setDefaultValues() {
        this.setAddressValue(this.store.getDefaultString("com.aptana.ide.server.core.http_server_address"));
        this.ports.setText(this.store.getDefaultString("com.aptana.ide.server.core.http_server_ports"));
    }

    private void setValues() {
        String addr = "";
        if (this.address.getSelectionIndex() >= 0) {
            addr = this.address.getItem(this.address.getSelectionIndex());
        }
        this.store.setValue("com.aptana.ide.server.core.http_server_address", addr);
        this.store.setValue("com.aptana.ide.server.core.http_server_ports", this.ports.getText());
        ServerCorePlugin.getDefault().savePluginPreferences();
    }
}

