/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui.generic.dialogs;

import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.ui.ServerDialogPageRegistry;
import com.aptana.ide.server.ui.generic.dialogs.Messages;
import com.aptana.ide.server.ui.generic.dialogs.ServerTypeLabelProvider;
import com.aptana.ide.server.ui.views.actions.ICanAdd;
import java.util.ArrayList;
import org.eclipse.jface.dialogs.TitleAreaDialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.ViewerSorter;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.PlatformUI;

public class ServerTypeSelectionDialog
extends TitleAreaDialog {
    private TableViewer viewer;
    private IServerType result;
    private String title = Messages.ServerTypeSelectionDialog_TITLE;
    private String description = Messages.ServerTypeSelectionDialog_DESCRIPTION;
    private boolean showOnlyExternalServers;
    private String category;

    public ServerTypeSelectionDialog(Shell parentShell) {
        this(parentShell, false, null);
    }

    public ServerTypeSelectionDialog(Shell parentShell, boolean showOnlyExternalServers, String category) {
        super(parentShell);
        this.showOnlyExternalServers = showOnlyExternalServers;
        this.category = category;
    }

    public void create() {
        super.create();
        PlatformUI.getWorkbench().getHelpSystem().setHelp((Control)this.getShell(), "com.aptana.ide.server.ui.servers_add_server");
    }

    protected Control createDialogArea(Composite parent) {
        this.setTitle(this.title);
        this.setMessage(this.description);
        Label titleBarSeparator = new Label(parent, 258);
        titleBarSeparator.setLayoutData((Object)new GridData(768));
        this.viewer = new TableViewer(parent, 4);
        IServerType[] knownServerTypes = ServerCore.getServerManager().getServerTypes();
        ArrayList<IServerType> visibleTypes = new ArrayList<IServerType>();
        this.viewer.setContentProvider((IContentProvider)new ArrayContentProvider());
        int a = 0;
        while (a < knownServerTypes.length) {
            IServerType type = knownServerTypes[a];
            if (!(this.showOnlyExternalServers && !type.isExternal() || this.category != null && !this.category.equalsIgnoreCase(type.getCategory()))) {
                boolean b;
                boolean hasDialog = ServerDialogPageRegistry.getInstance().hasDialog(type.getId());
                boolean bl = b = type.getAdapter(ICanAdd.class) != null;
                if (hasDialog || b) {
                    visibleTypes.add(type);
                }
            }
            ++a;
        }
        this.viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                ServerTypeSelectionDialog.this.okPressed();
            }
        });
        this.viewer.setInput((Object)visibleTypes.toArray());
        this.viewer.setLabelProvider((IBaseLabelProvider)new ServerTypeLabelProvider());
        this.viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.viewer.setSorter(new ViewerSorter());
        this.getShell().setText(Messages.ServerTypeSelectionDialog_CHOOSE_SERVER_TITLE);
        return super.createDialogArea(parent);
    }

    protected Control createButtonBar(Composite parent) {
        Control createButtonBar = super.createButtonBar(parent);
        this.viewer.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                ServerTypeSelectionDialog.this.validate();
            }
        });
        this.validate();
        return createButtonBar;
    }

    public IServerType getResult() {
        return this.result;
    }

    private IServerType calcResult() {
        StructuredSelection ss = (StructuredSelection)this.viewer.getSelection();
        if (!ss.isEmpty()) {
            return (IServerType)ss.getFirstElement();
        }
        return null;
    }

    protected void okPressed() {
        this.result = this.calcResult();
        super.okPressed();
    }

    private void validate() {
        boolean empty = this.viewer.getSelection().isEmpty();
        this.getButton(0).setEnabled(!empty);
        if (empty) {
            this.setErrorMessage(Messages.ServerTypeSelectionDialog_PLEASE_SELECT_SERVER_TYPE);
        } else {
            this.setErrorMessage(null);
        }
    }
}

