/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.ui;

import com.aptana.ide.server.core.ServerCorePlugin;
import java.util.Observable;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Preferences;

public class StartPage
extends Observable {
    private static final String PREF_KEY_START_PAGE = "com.aptana.ide.server.start.resource";
    private IResource startPageResource;
    private String startPageResourcePath;
    private static StartPage instance;

    public static StartPage getInstance() {
        if (instance == null) {
            instance = new StartPage();
        }
        return instance;
    }

    public IResource getStartPageResource() {
        if (this.startPageResourcePath == null) {
            this.startPageResourcePath = this.getStartPagePath();
            if (!this.startPageResourcePath.equals("")) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                this.startPageResource = workspace.getRoot().findMember((IPath)new Path(this.startPageResourcePath));
            }
        }
        return this.startPageResource;
    }

    public void setStartPageResource(IResource resource) {
        Preferences prefs = ServerCorePlugin.getDefault().getPluginPreferences();
        String path = "";
        if (resource != null) {
            path = resource.getFullPath().toPortableString();
        }
        prefs.setValue(PREF_KEY_START_PAGE, path);
        ServerCorePlugin.getDefault().savePluginPreferences();
        this.startPageResourcePath = path;
        this.startPageResource = resource;
        this.setChanged();
        this.notifyObservers(null);
    }

    private String getStartPagePath() {
        if (this.startPageResourcePath == null) {
            Preferences prefs = ServerCorePlugin.getDefault().getPluginPreferences();
            this.startPageResourcePath = prefs.getString(PREF_KEY_START_PAGE);
            if (!this.startPageResourcePath.equals("")) {
                IWorkspace workspace = ResourcesPlugin.getWorkspace();
                this.startPageResource = workspace.getRoot().findMember((IPath)new Path(this.startPageResourcePath));
            }
        }
        return this.startPageResourcePath;
    }

    public String getProjectRelativePath() {
        IResource resource = this.getStartPageResource();
        if (resource != null) {
            IPath path = resource.getProjectRelativePath();
            return path.toPortableString();
        }
        return null;
    }
}

