/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.internal;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.internal.Messages;
import com.aptana.ide.server.ui.ServerUIPlugin;
import java.io.File;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.Launch;
import org.eclipse.debug.core.model.IProcess;

public final class LaunchUtils {
    private LaunchUtils() {
    }

    public static IProcess exec(String program, String[] arguments, String workingDirectory) throws CoreException {
        int cmdLineLength = arguments.length + 1;
        String[] cmdLine = new String[cmdLineLength];
        cmdLine[0] = program;
        if (arguments != null) {
            System.arraycopy(arguments, 0, cmdLine, 1, arguments.length);
        }
        File workingDir = null;
        if (workingDirectory != null) {
            workingDir = new File(workingDirectory);
        }
        Process p = DebugPlugin.exec((String[])cmdLine, workingDir);
        IProcess process = null;
        if (p != null) {
            IdeLog.logInfo((Plugin)ServerUIPlugin.getDefault(), (String)StringUtils.format((String)Messages.LaunchUtils_ERROR_MESSAGE, (Object[])new String[]{program, StringUtils.join((String)" ", (String[])arguments)}));
            Launch launch = new Launch(null, "run", null);
            process = DebugPlugin.newProcess((ILaunch)launch, (Process)p, (String)program);
            process.setAttribute(IProcess.ATTR_CMDLINE, LaunchUtils.renderCommandLine(cmdLine));
        }
        return process;
    }

    protected static String renderCommandLine(String[] commandLine) {
        if (commandLine.length < 1) {
            return "";
        }
        StringBuffer buf = new StringBuffer(commandLine[0]);
        int i = 1;
        while (i < commandLine.length) {
            buf.append(' ');
            buf.append(commandLine[i]);
            ++i;
        }
        return buf.toString();
    }
}

