/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.launch.http;

import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.server.core.HttpServerLaunchConfiguration;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.model.ILaunchConfigurationDelegate;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IPathEditorInput;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.FileEditorInput;

public abstract class AbstractHttpServerLaunchConfigurationDelegate
implements ILaunchConfigurationDelegate {
    public abstract void launch(ILaunchConfiguration var1, String var2, ILaunch var3, IProgressMonitor var4) throws CoreException;

    protected String showStartPage(String baseUrl, ILaunchConfiguration configuration) throws IOException, CoreException {
        HttpServerLaunchConfiguration config = new HttpServerLaunchConfiguration();
        config.load(configuration);
        if (baseUrl.endsWith("/")) {
            baseUrl = baseUrl.substring(0, baseUrl.length() - 1);
        }
        String browserExe = config.getBrowserExe();
        String serverUrl = baseUrl;
        if (config.getStartActionType() == 2) {
            IResource resource;
            String resourcePath = config.getStartPagePath();
            if (resourcePath != null && (resource = ResourcesPlugin.getWorkspace().getRoot().findMember((IPath)new Path(resourcePath))) != null) {
                serverUrl = String.valueOf(baseUrl) + resource.getFullPath().toPortableString();
            }
        } else if (config.getStartActionType() == 3) {
            serverUrl = config.getStartPageUrl();
        } else if (config.getStartActionType() == 1) {
            final String fBaseUrl = baseUrl;
            final StringBuffer activeEditorUrl = new StringBuffer();
            Display.getDefault().syncExec(new Runnable(){

                public void run() {
                    IPathEditorInput fileInput;
                    IPath path;
                    IEditorInput editorInput = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage().getActiveEditor().getEditorInput();
                    if (editorInput != null && editorInput instanceof FileEditorInput) {
                        FileEditorInput fileInput2 = (FileEditorInput)editorInput;
                        IFile resource = fileInput2.getFile();
                        if (resource != null) {
                            activeEditorUrl.append(fBaseUrl);
                            activeEditorUrl.append(resource.getFullPath().toPortableString());
                        }
                    } else if (editorInput != null && editorInput instanceof IPathEditorInput && (path = (fileInput = (IPathEditorInput)editorInput).getPath()) != null) {
                        activeEditorUrl.append("file://");
                        activeEditorUrl.append(path.toPortableString());
                    }
                }
            });
            if (activeEditorUrl.length() > 0) {
                serverUrl = activeEditorUrl.toString();
            }
        }
        if (browserExe != null && !browserExe.equals("") && new File(browserExe).exists()) {
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                Runtime.getRuntime().exec(new String[]{"open", browserExe, serverUrl});
            } else {
                Runtime.getRuntime().exec(new String[]{browserExe, serverUrl});
            }
        } else {
            WorkbenchHelper.launchBrowser((String)serverUrl);
        }
        return serverUrl;
    }
}

