/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.configuration.ui;

import com.aptana.ide.server.configuration.ui.Messages;
import com.aptana.ide.server.core.ServerPathUtils;
import java.io.File;
import java.util.HashSet;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BasicServerComposite
extends Composite {
    protected Text path;
    protected StatusUpdater updater;
    private Text name;
    private HashSet<String> serverNames = new HashSet();
    private Text descriptionText;
    private boolean isNested;
    private Text log;
    private boolean requiresPath = true;

    private boolean requiresPath() {
        return this.requiresPath;
    }

    protected boolean pathMustBeFile() {
        return true;
    }

    public boolean validate() {
        if (this.requiresPath()) {
            String originalPath = this.path.getText();
            String filePath = ServerPathUtils.getFileNameByPathWithParameters((String)originalPath);
            if (filePath == null) {
                this.updater.updateStatus(false, Messages.BasicServerComposite_FILE_SHOULD_BE_DIR);
                return false;
            }
            File file = new File(filePath);
            if (!this.isNested) {
                String name = this.name.getText();
                if (name.length() == 0) {
                    this.updater.updateStatus(false, Messages.BasicServerComposite_EMPTY_NAME);
                    return false;
                }
                if (this.serverNames.contains(name)) {
                    this.updater.updateStatus(false, Messages.BasicServerComposite_DUBLICATE_NAME);
                    return false;
                }
            }
            if (file.exists()) {
                if (!this.pathMustBeFile() || file.isFile()) {
                    String text;
                    this.updater.updateStatus(true, "");
                    if (!(this.log == null || (text = this.log.getText()).length() == 0 || (file = new File(text)).exists() && file.isFile())) {
                        this.updater.updateStatus(false, Messages.BasicServerComposite_LOG_SHOULD_BE_EMPTY_OR_POINT_TO_FILE);
                        return false;
                    }
                    return true;
                }
                this.updater.updateStatus(false, Messages.BasicServerComposite_FILE_SHOULD_BE_DIR);
                return false;
            }
            this.updater.updateStatus(false, Messages.BasicServerComposite_PATH_NOT_EXISTS);
            return false;
        }
        return true;
    }

    public BasicServerComposite(Composite parent, int style, StatusUpdater updater, boolean isNested, boolean requiresPath) {
        super(parent, style);
        this.requiresPath = requiresPath;
        this.initialize(updater, isNested);
    }

    public BasicServerComposite(Composite parent, int style, StatusUpdater updater, boolean isNested) {
        super(parent, style);
        this.initialize(updater, isNested);
    }

    private void initialize(StatusUpdater updater, boolean isNested) {
        this.updater = updater;
        this.setLayout((Layout)new GridLayout(3, false));
        this.isNested = isNested;
        if (!isNested) {
            Label nlabel = new Label((Composite)this, 0);
            nlabel.setText(Messages.BasicServerComposite_NAME);
            this.name = new Text((Composite)this, 2048);
            GridData gridData = new GridData(768);
            gridData.horizontalSpan = 2;
            this.name.setLayoutData((Object)gridData);
            Label ds = new Label((Composite)this, 0);
            ds.setText(Messages.BasicServerComposite_Description);
            this.descriptionText = new Text((Composite)this, 2048);
            GridData gridData2 = new GridData(768);
            gridData2.horizontalSpan = 2;
            this.descriptionText.setLayoutData((Object)gridData);
        }
        if (this.requiresPath()) {
            Label label = new Label((Composite)this, 0);
            label.setText(this.getPathLabel());
            this.path = new Text((Composite)this, 2048);
            ModifyListener modifyListener = new ModifyListener(){

                public void modifyText(ModifyEvent e) {
                    BasicServerComposite.this.validate();
                }
            };
            this.path.addModifyListener(modifyListener);
            if (this.name != null) {
                this.name.addModifyListener(modifyListener);
            }
            this.path.setLayoutData((Object)new GridData(768));
            Button browser = new Button((Composite)this, 8);
            browser.setText(Messages.BasicServerComposite_BROWSE);
            browser.addSelectionListener(new SelectionListener(){

                public void widgetDefaultSelected(SelectionEvent e) {
                }

                public void widgetSelected(SelectionEvent e) {
                    if (BasicServerComposite.this.pathMustBeFile()) {
                        String open;
                        File file;
                        File parentFile;
                        FileDialog fdlg = new FileDialog(BasicServerComposite.this.getShell(), 4096);
                        String text = BasicServerComposite.this.path.getText();
                        if (text.length() > 0 && (parentFile = (file = new File(text)).getParentFile()) != null) {
                            fdlg.setFilterPath(parentFile.getPath());
                        }
                        if ((open = fdlg.open()) != null) {
                            BasicServerComposite.this.path.setText(open);
                        }
                    } else {
                        String open;
                        File file;
                        File parentFile;
                        DirectoryDialog fdlg = new DirectoryDialog(BasicServerComposite.this.getShell(), 4096);
                        String text = BasicServerComposite.this.path.getText();
                        if (text.length() > 0 && (parentFile = (file = new File(text)).getParentFile()) != null) {
                            fdlg.setFilterPath(parentFile.getPath());
                        }
                        if ((open = fdlg.open()) != null) {
                            BasicServerComposite.this.path.setText(open);
                        }
                    }
                }
            });
        }
    }

    protected String getPathLabel() {
        return Messages.BasicServerComposite_PATH;
    }

    public void setServerNames(HashSet<String> names) {
        this.serverNames = names;
    }

    public String getServerPath() {
        if (this.path != null) {
            return this.path.getText();
        }
        return null;
    }

    public void setServerPath(String serverPath) {
        if (this.path != null) {
            this.path.setText(serverPath);
        }
        this.validate();
    }

    public void setServerName(String name) {
        if (this.name != null) {
            this.name.setText(name);
        }
    }

    public void setServerDescription(String name) {
        if (this.descriptionText != null) {
            this.descriptionText.setText(name);
        }
    }

    public String getServerName() {
        return this.name == null ? "" : this.name.getText();
    }

    public String getServerDescription() {
        return this.descriptionText == null ? "" : this.descriptionText.getText();
    }

    public String getLogPath() {
        return this.log == null ? "" : this.log.getText();
    }

    public void setLogPath(String path) {
        if (path == null) {
            path = "";
        }
        if (this.log != null) {
            this.log.setText(path);
        }
    }

    void createLogPath(Composite parent) {
        Label label = new Label(parent, 0);
        label.setText(Messages.BasicServerComposite_LOG_PATH_TITLE);
        this.log = new Text(parent, 2048);
        this.log.setLayoutData((Object)new GridData(768));
        Button browser = new Button(parent, 8);
        browser.addSelectionListener(new SelectionListener(){

            public void widgetDefaultSelected(SelectionEvent e) {
            }

            public void widgetSelected(SelectionEvent e) {
                String open;
                File file;
                File parentFile;
                FileDialog fdlg = new FileDialog(BasicServerComposite.this.getShell(), 4096);
                String text = BasicServerComposite.this.log.getText();
                if (text.length() > 0 && (parentFile = (file = new File(text)).getParentFile()) != null) {
                    fdlg.setFilterPath(parentFile.getPath());
                }
                if ((open = fdlg.open()) != null) {
                    BasicServerComposite.this.log.setText(open);
                }
            }
        });
        this.log.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                BasicServerComposite.this.validate();
            }
        });
        browser.setText(Messages.BasicServerComposite_LOG_PATH_CHOOSE);
    }

    public static abstract class StatusUpdater {
        public abstract void updateStatus(boolean var1, String var2);
    }
}

