/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.server.core.impl.servers;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ProgressDistributor;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.server.ServerCore;
import com.aptana.ide.server.core.IAbstractConfiguration;
import com.aptana.ide.server.core.ILog;
import com.aptana.ide.server.core.IModule;
import com.aptana.ide.server.core.IModuleType;
import com.aptana.ide.server.core.IOperationListener;
import com.aptana.ide.server.core.IPublishOperation;
import com.aptana.ide.server.core.IServer;
import com.aptana.ide.server.core.IServerListener;
import com.aptana.ide.server.core.IServerType;
import com.aptana.ide.server.core.OperationCompletionEvent;
import com.aptana.ide.server.core.ServerEvent;
import com.aptana.ide.server.core.impl.modules.ModuleTypeRegistry;
import com.aptana.ide.server.core.impl.servers.PublishOperationRegistry;
import com.aptana.ide.server.core.impl.servers.ServerManager;
import com.aptana.ide.server.internal.core.Messages;
import java.io.File;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.WeakHashMap;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.ISchedulingRule;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.debug.core.ILaunch;
import org.eclipse.debug.core.model.IProcess;
import org.eclipse.debug.core.model.IStreamsProxy;

public abstract class AbstractServer
implements IServer {
    private static final String PUBLISH_ID = "publish";
    private static final String RECONFIGURE_ID = "reconfigure";
    private WeakHashMap<IProcess, Object> processes = new WeakHashMap();
    private static final String RUNTIME_EXCEPTION_ERROR = "runtime exception during server job execution";
    public static final String SERVER_RESTART = "serverRestart";
    public static final String SERVER_STOP = "serverStop";
    public static final String SERVER_START = "serverStart";
    protected static final String SERVER_DOES_NOT_SUPPORTS_RESTARTING_IN_MODE = Messages.AbstractServer_DOES_NOT_SUPPORTS_RESTART;
    protected static final String SERVER_CAN_NOT_PUBLISH = Messages.AbstractServer_DOES_NOT_SUPPORTS_PUBLISH;
    protected static final String SERVER_IS_NOT_RUNNING = Messages.AbstractServer_IS_NOT_RUNNING;
    protected static final String SERVER_IS_RUNNING = Messages.AbstractServer_IS_RUNNG;
    public static final String SERVER_DOES_NOT_SUPPORTS_STARTING_IN_MODE = Messages.AbstractServer_DOES_NOT_SUPPORTS_START;
    private HashSet<IOperationListener> operationListeners = new HashSet();
    private HashSet<IServerListener> serverListeners = new HashSet();
    private int state;
    private String mode;
    private String description;
    private ILaunch launch;
    private String assotiatedServers;
    private IServerType type;
    private String id;
    protected IPath logPath;
    private String name;
    private HashSet<IModule> configuredModules = new HashSet();
    private ISchedulingRule rule = new ISchedulingRule(){

        public boolean contains(ISchedulingRule rule) {
            return rule == this;
        }

        public boolean isConflicting(ISchedulingRule rule) {
            return this == rule;
        }
    };

    public boolean isExternal() {
        return false;
    }

    public ILaunch getLaunch() {
        return this.launch;
    }

    public IStatus canDelete() {
        return Status.OK_STATUS;
    }

    protected void setLaunch(ILaunch launch) {
        this.launch = launch;
    }

    protected void setMode(String mode) {
        this.mode = mode;
    }

    public IStreamsProxy getStreamsProxy() {
        if (this.launch == null) {
            return null;
        }
        IProcess[] processes = this.launch.getProcesses();
        if (processes.length == 0) {
            return null;
        }
        return processes[0].getStreamsProxy();
    }

    public int getServerState() {
        return this.state;
    }

    public String getName() {
        return this.name;
    }

    protected void setName(String name) {
        this.name = name;
    }

    protected void setServerState(int state) {
        if (this.state != state) {
            this.state = state;
        }
    }

    public AbstractServer(IServerType type, int state, IAbstractConfiguration configuration) {
        this.type = type;
        this.state = state;
        this.id = ServerManager.getFreeId();
        this.installConfig(configuration);
    }

    public AbstractServer(IServerType type, IAbstractConfiguration configuration) {
        this.type = type;
        this.id = ServerManager.getFreeId();
        this.installConfig(configuration);
        this.setServerState(4);
    }

    protected void serverChanged() {
        ((ServerManager)ServerCore.getServerManager()).serverChanged(this);
        this.fireListenersOnly();
    }

    protected void fireListenersOnly() {
        ServerEvent serverEvent = new ServerEvent(this);
        for (IServerListener name : this.serverListeners) {
            name.serverChanged(serverEvent);
        }
    }

    protected void operationExecuted(OperationCompletionEvent event) {
        for (IOperationListener ol : this.operationListeners) {
            ol.done(event);
        }
    }

    public IServerType getServerType() {
        return this.type;
    }

    public IModule[] getModules() {
        IModule[] mods = new IModule[this.configuredModules.size()];
        this.configuredModules.toArray(mods);
        return mods;
    }

    public IPath getServerRoot() {
        return null;
    }

    public synchronized void addOperationListener(IOperationListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("can not be null");
        }
        this.operationListeners.add(listener);
    }

    public synchronized void addServerListener(IServerListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("can not be null");
        }
        this.serverListeners.add(listener);
    }

    public synchronized void removeOperationListener(IServerListener listener) {
        this.operationListeners.remove(listener);
    }

    public synchronized void removeServerListener(IServerListener listener) {
        this.serverListeners.remove(listener);
    }

    public synchronized IStatus canPublish() {
        return this.type.supportsPublish() ? Status.OK_STATUS : new Status(4, "com.aptana.ide.server", 4, StringUtils.format((String)SERVER_CAN_NOT_PUBLISH, (String)this.getName()), null);
    }

    public synchronized IStatus canRestart(String mode) {
        if (this.getServerState() == 1 || this.getServerState() == 2) {
            return this.type.supportsRestart(mode) ? Status.OK_STATUS : new Status(4, "com.aptana.ide.server", 4, StringUtils.format((String)SERVER_DOES_NOT_SUPPORTS_RESTARTING_IN_MODE, (Object[])new Object[]{this.getName(), mode}), null);
        }
        return new Status(4, "com.aptana.ide.server", 4, StringUtils.format((String)SERVER_IS_NOT_RUNNING, (String)this.getName()), null);
    }

    public synchronized IStatus canStart(String launchMode) {
        if (this.getServerState() == 4) {
            return this.type.supportsLaunchMode(launchMode) ? Status.OK_STATUS : new Status(4, "com.aptana.ide.server", 4, StringUtils.format((String)SERVER_DOES_NOT_SUPPORTS_STARTING_IN_MODE, (Object[])new Object[]{this.getName(), launchMode}), null);
        }
        return new Status(4, "com.aptana.ide.server", 4, StringUtils.format((String)SERVER_IS_RUNNING, (String)this.getName()), null);
    }

    public String getMode() {
        return this.mode;
    }

    public synchronized IStatus canStop() {
        if (this.getServerState() == 1 || this.getServerState() == 2) {
            return Status.OK_STATUS;
        }
        return new Status(4, "com.aptana.ide.server", 4, StringUtils.format((String)SERVER_IS_NOT_RUNNING, (String)this.getName()), null);
    }

    public IStatus canModify() {
        return Status.OK_STATUS;
    }

    public ISchedulingRule getServerOwnerRule() {
        return this.rule;
    }

    protected void executeOperation(final ServerOperation operation, final IOperationListener listener) {
        Job runnable = new Job(this.getLabel(operation.getId())){

            protected IStatus run(IProgressMonitor monitor) {
                try {
                    Platform.getJobManager().beginRule(AbstractServer.this.rule, monitor);
                    IStatus execute = operation.execute(AbstractServer.this, monitor);
                    OperationCompletionEvent operationCompletionEvent = new OperationCompletionEvent(AbstractServer.this, operation.getId(), execute);
                    AbstractServer.this.operationExecuted(operationCompletionEvent);
                    if (listener != null) {
                        listener.done(operationCompletionEvent);
                    }
                    IStatus iStatus = execute;
                    return iStatus;
                }
                catch (Exception e) {
                    Status es = new Status(4, "com.aptana.ide.server", 4, AbstractServer.RUNTIME_EXCEPTION_ERROR, (Throwable)e);
                    IdeLog.logError((Plugin)ServerCore.getDefault(), (String)AbstractServer.RUNTIME_EXCEPTION_ERROR, (Throwable)e);
                    OperationCompletionEvent operationCompletionEvent = new OperationCompletionEvent(AbstractServer.this, operation.getId(), (IStatus)es);
                    if (listener != null) {
                        listener.done(operationCompletionEvent);
                    }
                    Status status = es;
                    return status;
                }
                finally {
                    Platform.getJobManager().endRule(AbstractServer.this.rule);
                }
            }
        };
        runnable.schedule();
    }

    protected String getLabel(String operationId) {
        if (operationId.equals(SERVER_RESTART)) {
            return StringUtils.format((String)Messages.AbstractServer_RESTART_OP_LABEL, (String)this.getName());
        }
        if (operationId.equals(SERVER_START)) {
            return StringUtils.format((String)Messages.AbstractServer_START_OP_LABEL, (String)this.getName());
        }
        if (operationId.equals(SERVER_STOP)) {
            return StringUtils.format((String)Messages.AbstractServer_STOP_OP_LABEL, (String)this.getName());
        }
        if (operationId.equals(PUBLISH_ID)) {
            return StringUtils.format((String)Messages.AbstractServer_PUBLISH_ON_OP_LABEL, (String)this.getName());
        }
        if (operationId.equals(RECONFIGURE_ID)) {
            return StringUtils.format((String)Messages.AbstractServer_RECONFIGURE_OP_LABEL, (String)this.getName());
        }
        return "Unknown Label";
    }

    protected abstract IStatus restart(String var1, IProgressMonitor var2);

    protected abstract IStatus start(String var1, IProgressMonitor var2);

    protected abstract IStatus stop(boolean var1, IProgressMonitor var2);

    public void start(final String mode, IOperationListener listener, IProgressMonitor monitor) {
        IStatus canStart = this.canStart(mode);
        if (canStart.getSeverity() != 0) {
            if (listener != null) {
                listener.done(new OperationCompletionEvent(this, SERVER_START, canStart));
            }
            return;
        }
        this.executeOperation(new ServerOperation(SERVER_START, monitor){

            protected IStatus internalExecute(IServer server, IProgressMonitor monitor) {
                return AbstractServer.this.start(mode, monitor);
            }
        }, listener);
    }

    public void stop(final boolean force, IOperationListener listener, IProgressMonitor monitor) {
        IStatus canStart = this.canStop();
        if (canStart.getSeverity() != 0) {
            if (listener != null) {
                listener.done(new OperationCompletionEvent(this, SERVER_STOP, canStart));
            }
            return;
        }
        this.executeOperation(new ServerOperation(SERVER_STOP, monitor){

            protected IStatus internalExecute(IServer server, IProgressMonitor monitor) {
                return AbstractServer.this.stop(force, monitor);
            }
        }, listener);
    }

    public void restart(final String mode, IOperationListener listener, IProgressMonitor monitor) {
        IStatus canStart = this.canRestart(mode);
        if (canStart.getSeverity() != 0) {
            if (listener != null) {
                listener.done(new OperationCompletionEvent(this, SERVER_RESTART, canStart));
            }
            return;
        }
        this.executeOperation(new ServerOperation(SERVER_RESTART, monitor){

            protected IStatus internalExecute(IServer server, IProgressMonitor monitor) {
                return AbstractServer.this.restart(mode, monitor);
            }
        }, listener);
    }

    public void publish(final int kind, final IModule[] modules, IOperationListener listener, IProgressMonitor monitor) {
        this.executeOperation(new ServerOperation(PUBLISH_ID, null){

            protected IStatus internalExecute(IServer server, IProgressMonitor monitor) {
                int a = 0;
                while (a < modules.length) {
                    if (monitor.isCanceled()) {
                        return Status.OK_STATUS;
                    }
                    String[] publishOperationIds = modules[a].getPublishOperationIds();
                    try {
                        IPublishOperation[] operations = PublishOperationRegistry.getOperationRegistry().getOperations(publishOperationIds);
                        int b = 0;
                        while (b < operations.length) {
                            if (monitor.isCanceled()) {
                                return Status.OK_STATUS;
                            }
                            IStatus performPublish = operations[b].performPublish(AbstractServer.this, kind, modules, monitor);
                            if (performPublish.getSeverity() == 4) {
                                return performPublish;
                            }
                            ++b;
                        }
                    }
                    catch (CoreException e) {
                        return e.getStatus();
                    }
                    ++a;
                }
                return Status.OK_STATUS;
            }
        }, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void reconfigure(final IAbstractConfiguration configuration) throws CoreException {
        final Object sync = new Object();
        IOperationListener operationListener = new IOperationListener(){
            private boolean isDone = false;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public synchronized void done(OperationCompletionEvent operation) {
                this.isDone = true;
                Object object = sync;
                synchronized (object) {
                    sync.notify();
                }
            }

            public synchronized boolean isDone() {
                return this.isDone;
            }
        };
        this.executeOperation(new ServerOperation(RECONFIGURE_ID, null){

            protected IStatus internalExecute(IServer server, IProgressMonitor monitor) {
                AbstractServer.this.installConfig(configuration);
                AbstractServer.this.flushConfig();
                return Status.OK_STATUS;
            }
        }, operationListener);
        if (!operationListener.isDone()) {
            Object object = sync;
            synchronized (object) {
                try {
                    sync.wait();
                }
                catch (InterruptedException e) {
                    throw new CoreException((IStatus)new Status(4, "com.aptana.ide.server", 4, e.getMessage(), (Throwable)e));
                }
            }
        }
    }

    protected void installConfig(IAbstractConfiguration configuration) {
        this.configuredModules.clear();
        String newId = configuration.getStringAttribute("id");
        if (newId != null && newId.trim().length() > 0) {
            this.id = newId;
        }
        this.name = configuration.getStringAttribute("name");
        this.description = configuration.getStringAttribute("description");
        this.assotiatedServers = configuration.getStringAttribute("association_id");
        IAbstractConfiguration subConfiguration = configuration.createSubConfiguration("modules");
        int intAttribute = subConfiguration.getIntAttribute("count");
        String ps = configuration.getStringAttribute("logpath");
        this.logPath = ps != null && ps.length() > 0 ? new Path(ps) : null;
        int a = 0;
        while (a < intAttribute) {
            IAbstractConfiguration moduleConfiguration = subConfiguration.createSubConfiguration(Integer.toString(a));
            String module = moduleConfiguration.getStringAttribute("type");
            IModuleType moduleType = ModuleTypeRegistry.getInstance().getModuleType(module);
            IModule createModule = moduleType.createModule(moduleConfiguration);
            this.configuredModules.add(createModule);
            ++a;
        }
    }

    public void storeConfiguration(IAbstractConfiguration config) {
        config.setStringAttribute("id", this.id);
        config.setStringAttribute("name", this.name);
        config.setStringAttribute("logpath", this.logPath == null ? "" : this.logPath.toString());
        if (this.description != null && this.description.length() > 0) {
            config.setStringAttribute("description", this.description);
        } else {
            config.setStringAttribute("description", this.getConfigurationDescription());
        }
        IAbstractConfiguration conf = config.createSubConfiguration("modules");
        int a = 0;
        for (IModule module : this.configuredModules) {
            IAbstractConfiguration subConfiguration = conf.createSubConfiguration(Integer.toString(a));
            module.storeConfig(subConfiguration);
            subConfiguration.setStringAttribute("type", module.getType().getId());
            ++a;
        }
        conf.setIntAttribute("count", a);
    }

    protected void flushConfig() {
    }

    public final void unconfigureModule(final IModule module, IOperationListener listener, IProgressMonitor monitor) {
        this.executeOperation(new ServerOperation("moduleUnconfigure", monitor){

            protected IStatus internalExecute(IServer server, IProgressMonitor monitor) {
                AbstractServer.this.configuredModules.remove(module);
                AbstractServer.this.flushConfig();
                return Status.OK_STATUS;
            }
        }, listener);
    }

    public void configureModule(final IModule module, IOperationListener listener, IProgressMonitor monitor) {
        this.executeOperation(new ServerOperation("moduleConfigure", monitor){

            protected IStatus internalExecute(IServer server, IProgressMonitor monitor) {
                AbstractServer.this.configuredModules.add(module);
                AbstractServer.this.flushConfig();
                return Status.OK_STATUS;
            }
        }, listener);
    }

    public boolean isConfigured(IModule module) {
        return this.configuredModules.contains(module);
    }

    public String getId() {
        return this.id;
    }

    public Object getAdapter(Class adapter) {
        return Platform.getAdapterManager().getAdapter((Object)this, adapter);
    }

    public void configureModule(IAbstractConfiguration config, IOperationListener listener, IProgressMonitor monitor) {
        IModuleType moduleType = ModuleTypeRegistry.getInstance().getModuleType(config.getStringAttribute("type"));
        this.configureModule(moduleType.createModule(config), listener, monitor);
    }

    public IProcess[] getProcesses() {
        IProcess[] prs = new IProcess[this.processes.size()];
        return this.processes.keySet().toArray(prs);
    }

    public void registerProcess(IProcess process) {
        this.processes.put(process, "");
        this.serverChanged();
    }

    public boolean isWebServer() {
        return false;
    }

    public boolean isTransient() {
        return false;
    }

    public IServer[] getAssociatedServers() {
        ArrayList<IServer> result = new ArrayList<IServer>();
        IServer[] iServerArray = ServerCore.getServerManager().getServers();
        int n = 0;
        int n2 = iServerArray.length;
        while (n < n2) {
            IServer s = iServerArray[n];
            if (s != null && s.getId() != null && s.getId().trim().length() != 0 && this.assotiatedServers.contains(s.getId())) {
                result.add(s);
            }
            ++n;
        }
        IServer[] resultA = new IServer[result.size()];
        result.toArray(resultA);
        return resultA;
    }

    public String getDescription() {
        return this.description;
    }

    public abstract String getConfigurationDescription();

    public boolean suppliesStatistics() {
        return false;
    }

    public String fetchStatistics() {
        return "";
    }

    public void showStatisticsInterface() {
    }

    public boolean suppliesStatisticsInterface() {
        return false;
    }

    public void setLogFilePath(IPath logFileURI) {
        this.logPath = logFileURI;
    }

    public IPath getLogFilePath() {
        if (this.logPath == null || this.logPath.isEmpty()) {
            this.logPath = this.getDefaultLogPath();
        }
        return this.logPath;
    }

    protected IPath getDefaultLogPath() {
        return null;
    }

    public ILog[] getAllLogs() {
        return new ILog[]{this.getLog()};
    }

    public ILog getLog() {
        return new ILog(){

            public URI getURI() {
                if (AbstractServer.this.logPath == null) {
                    AbstractServer.this.logPath = AbstractServer.this.getLogFilePath();
                    if (AbstractServer.this.logPath == null) {
                        return null;
                    }
                }
                return AbstractServer.this.logPath.toFile().toURI();
            }

            public boolean exists() {
                if (AbstractServer.this.logPath == null) {
                    AbstractServer.this.logPath = AbstractServer.this.getLogFilePath();
                }
                if (AbstractServer.this.logPath != null) {
                    File file = AbstractServer.this.logPath.toFile();
                    return file.exists();
                }
                return false;
            }
        };
    }

    public static abstract class ServerOperation {
        private final String id;
        private ProgressDistributor distributor = new ProgressDistributor();

        public ServerOperation(String id, IProgressMonitor mon) {
            this.id = id;
            if (mon != null) {
                this.distributor.addMonitor(mon);
            }
        }

        IStatus execute(AbstractServer server, IProgressMonitor monitor) {
            if (monitor != null) {
                this.distributor.addMonitor(monitor);
            }
            IStatus internalExecute = this.internalExecute(server, (IProgressMonitor)this.distributor);
            server.serverChanged();
            this.distributor.done();
            return internalExecute;
        }

        protected abstract IStatus internalExecute(IServer var1, IProgressMonitor var2);

        String getId() {
            return this.id;
        }
    }
}

