/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.samples;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.samples.handlers.IPreviewHandler;
import com.aptana.ide.samples.handlers.IProjectCreationHandler;
import com.aptana.ide.samples.model.SamplesInfo;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Hashtable;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.IExtensionRegistry;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.InvalidRegistryObjectException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class SamplesPlugin
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "com.aptana.ide.samples";
    private static SamplesPlugin plugin;
    private static Hashtable<String, Image> images;

    static {
        images = new Hashtable();
    }

    public SamplesPlugin() {
        plugin = this;
    }

    public static Image getImage(String path) {
        if (images.get(path) == null) {
            ImageDescriptor id = SamplesPlugin.getImageDescriptor(path);
            if (id == null) {
                return null;
            }
            Image i = id.createImage();
            images.put(path, i);
            return i;
        }
        return images.get(path);
    }

    public static ImageDescriptor getImageDescriptor(String path) {
        return AbstractUIPlugin.imageDescriptorFromPlugin((String)PLUGIN_ID, (String)path);
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static SamplesPlugin getDefault() {
        return plugin;
    }

    public static SamplesInfo[] findSamplesInfoExtensions() {
        ArrayList<SamplesInfo> list = new ArrayList<SamplesInfo>();
        IExtensionRegistry registry = Platform.getExtensionRegistry();
        IExtensionPoint point = registry.getExtensionPoint("com.aptana.ide.samples.samplespath");
        if (point != null) {
            IExtension[] extensions = point.getExtensions();
            int i = 0;
            while (i < extensions.length) {
                IExtension extension = extensions[i];
                IConfigurationElement[] configurations = extension.getConfigurationElements();
                int j = 0;
                while (j < configurations.length) {
                    block21: {
                        IConfigurationElement element = configurations[j];
                        try {
                            IConfigurationElement[] includes;
                            IConfigurationElement[] natures;
                            String previewHandler;
                            String projectHandler;
                            String iconFile;
                            String resolvedPath;
                            IExtension declaring = element.getDeclaringExtension();
                            String declaringPluginID = declaring.getNamespaceIdentifier();
                            Bundle bundle = Platform.getBundle((String)declaringPluginID);
                            SamplesInfo samplesInfo = new SamplesInfo();
                            String name = element.getAttribute("name");
                            samplesInfo.setName(name);
                            String directory = element.getAttribute("directory");
                            if (directory == null || (resolvedPath = SamplesPlugin.getResolvedFilename(bundle, directory)) == null) break block21;
                            samplesInfo.setDirectory(resolvedPath);
                            File f = new File(resolvedPath);
                            if (f.listFiles().length == 0) break block21;
                            String infoFile = element.getAttribute("infoFile");
                            if (infoFile != null && infoFile.length() > 0) {
                                samplesInfo.setInfoFile(SamplesPlugin.getResolvedURL(bundle, infoFile));
                            }
                            if ((iconFile = element.getAttribute("iconFile")) != null && iconFile.length() > 0) {
                                resolvedPath = SamplesPlugin.getResolvedFilename(bundle, iconFile);
                                samplesInfo.setIconFile(resolvedPath);
                            }
                            if ((projectHandler = element.getAttribute("projectHandler")) != null) {
                                try {
                                    Object handler = element.createExecutableExtension("projectHandler");
                                    if (handler instanceof IProjectCreationHandler) {
                                        samplesInfo.setCreationHandler((IProjectCreationHandler)handler);
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                            if ((previewHandler = element.getAttribute("previewHandler")) != null) {
                                try {
                                    Object handler = element.createExecutableExtension("previewHandler");
                                    if (handler instanceof IPreviewHandler) {
                                        samplesInfo.setPreviewHandler((IPreviewHandler)handler);
                                    }
                                }
                                catch (CoreException coreException) {}
                            }
                            if ((natures = element.getChildren("nature")) != null) {
                                int k = 0;
                                while (k < natures.length) {
                                    String natureId = natures[k].getAttribute("id");
                                    if (natureId != null && natureId.length() > 0) {
                                        samplesInfo.addNature(natureId);
                                    }
                                    ++k;
                                }
                            }
                            if ((includes = element.getChildren("include")) != null) {
                                int k = 0;
                                while (k < includes.length) {
                                    String includePath = includes[k].getAttribute("path");
                                    if (includePath != null && includePath.length() > 0) {
                                        String resolvedInclude = SamplesPlugin.getResolvedFilename(bundle, includePath);
                                        samplesInfo.addIncludePath(resolvedInclude);
                                    }
                                    ++k;
                                }
                            }
                            list.add(samplesInfo);
                        }
                        catch (InvalidRegistryObjectException invalidRegistryObjectException) {}
                    }
                    ++j;
                }
                ++i;
            }
        }
        return list.toArray(new SamplesInfo[0]);
    }

    private static URL getResolvedURL(Bundle b, String fullPath) {
        URL url = FileLocator.find((Bundle)b, (IPath)new Path(fullPath), null);
        if (url != null) {
            try {
                URL localUrl = FileLocator.toFileURL((URL)url);
                if (localUrl != null) {
                    return localUrl;
                }
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)SamplesPlugin.getDefault(), (String)e.getMessage());
            }
        }
        return null;
    }

    private static String getResolvedFilename(Bundle b, String fullPath) {
        URL url;
        String[] split = fullPath.split("/");
        if (split.length > 0) {
            SamplesPlugin.getResolvedURL(b, split[0]);
        }
        if ((url = SamplesPlugin.getResolvedURL(b, fullPath)) != null) {
            return url.getFile();
        }
        return null;
    }
}

