/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.scripting.Messages;
import com.aptana.ide.scripting.ScriptInfo;
import com.aptana.ide.scripting.ScriptThread;
import com.aptana.ide.scripting.ScriptingHttpResource;
import com.aptana.ide.scripting.ScriptingHttpServer;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.http.RequestLineParser;
import com.aptana.ide.server.resolvers.IHttpResourceResolver;
import com.aptana.ide.server.resources.IHttpResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.core.runtime.Plugin;
import org.mozilla.javascript.Undefined;

public class ScriptingResourceResolver
implements IHttpResourceResolver {
    private File _rootDirectory;
    private ScriptingHttpServer _server;

    public void setServer(ScriptingHttpServer server) {
        this._server = server;
    }

    public ScriptingResourceResolver(File dir) {
        this._rootDirectory = dir;
    }

    public IHttpResource getResource(RequestLineParser requestLine) {
        ScriptingHttpResource result = null;
        String uri = requestLine.getUri();
        if (uri.startsWith("/")) {
            uri = uri.substring(1);
        }
        File file = new File(this._rootDirectory, uri.replace('/', File.separatorChar));
        if (requestLine.hasKey("action")) {
            String path = null;
            try {
                path = file.getCanonicalPath();
            }
            catch (IOException e) {
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptingResourceResolver_Error, (Throwable)e);
            }
            String id = this._server.getGlobal().getXrefId(path);
            String scriptThreadResultString = "";
            if (id != null) {
                ScriptInfo info = this._server.getGlobal().getScriptInfo(id);
                if (info != null) {
                    String func = requestLine.getKeyValue("action");
                    Object funcObj = info.getScope().get(func, info.getScope());
                    String data = requestLine.getKeyValue("data");
                    ScriptThread scriptThread = new ScriptThread(info.getScope(), funcObj, new Object[]{data});
                    scriptThread.run();
                    Object scriptThreadResult = scriptThread.getResult();
                    if (scriptThreadResult != null && !(scriptThreadResult instanceof Undefined)) {
                        scriptThreadResultString = scriptThreadResult.toString();
                    }
                } else {
                    scriptThreadResultString = "<<InvalidScriptIdException>>";
                }
            } else {
                scriptThreadResultString = "<<InvalidScriptIdException>>";
            }
            final String scriptResult = scriptThreadResultString;
            result = new IHttpResource(){

                public InputStream getContentInputStream(HttpServer server) throws IOException {
                    return new ByteArrayInputStream(scriptResult.getBytes("UTF-8"));
                }

                public long getContentLength() {
                    try {
                        return scriptResult.getBytes("UTF-8").length;
                    }
                    catch (UnsupportedEncodingException e) {
                        IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptingResourceResolver_Error, (Throwable)e);
                        return 0L;
                    }
                }

                public String getContentType() {
                    return "text/plain";
                }
            };
        } else if (file.exists()) {
            result = new ScriptingHttpResource(file);
        }
        return result;
    }
}

