/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.scripting;

import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.StringUtils;
import com.aptana.ide.scripting.FileUtilities;
import com.aptana.ide.scripting.Global;
import com.aptana.ide.scripting.Messages;
import com.aptana.ide.scripting.ScriptInfo;
import com.aptana.ide.scripting.ScriptingHttpServer;
import com.aptana.ide.scripting.ScriptingPlugin;
import com.aptana.ide.server.http.HttpContentTypes;
import com.aptana.ide.server.http.HttpServer;
import com.aptana.ide.server.resources.IHttpResource;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringWriter;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashSet;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerConfigurationException;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.eclipse.core.runtime.Plugin;
import org.mozilla.javascript.Callable;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Script;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;
import org.xml.sax.SAXException;

public class ScriptingHttpResource
implements IHttpResource {
    private static String RUNAT_ATTR = "runat";
    private static String SERVER = "server";
    private static String SERVER_ONLY = "server-only";
    private static String BOTH = "both";
    private File _file;
    private String _text;
    private String _type;
    private Document _document;
    private ScriptingHttpServer _server;

    private Document getCachedDocument() {
        Object doc;
        ScriptInfo info = this.getScriptInfo();
        Document result = null;
        if (info != null && (doc = info.getScope().get("document", info.getScope())) instanceof NativeJavaObject) {
            NativeJavaObject nativeObject = (NativeJavaObject)doc;
            result = (Document)nativeObject.unwrap();
        }
        return result;
    }

    private void setCachedDocument() {
        ScriptInfo info = this.getScriptInfo();
        if (info != null) {
            Context.enter();
            Scriptable global = info.getScope();
            Object wrappedDocument = Context.javaToJS((Object)this._document, (Scriptable)global);
            global.put("document", global, wrappedDocument);
            global.put("location", global, (Object)info.getFile().getAbsolutePath());
            Context.exit();
        }
    }

    public long getContentLength() {
        long result = this._text != null ? (long)this._text.length() : this._file.length();
        return result;
    }

    public String getContentType() {
        return this._type;
    }

    private ScriptInfo getScriptInfo() {
        Global global = this._server.getGlobal();
        String id = global.getXrefId(this.getUri());
        ScriptInfo result = null;
        if (global.hasScriptInfo(id)) {
            result = global.getScriptInfo(id);
        }
        return result;
    }

    private boolean isScriptanaResource() {
        boolean result = false;
        int fileExtIndex = this._file.getName().lastIndexOf(46);
        if (fileExtIndex != -1) {
            String fileExtension = this._file.getName().substring(fileExtIndex);
            this._type = HttpContentTypes.getContentType((String)fileExtension);
            if (this._type.equals("application/xhtml+xml")) {
                this._type = "text/html";
                result = true;
            }
        }
        return result;
    }

    public String getUri() {
        String result = "";
        try {
            result = this._file.getCanonicalPath();
        }
        catch (IOException e) {
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptingHttpResource_Error, (Throwable)e);
        }
        return result;
    }

    public ScriptingHttpResource(File file) {
        this._file = file;
        this._text = null;
        this._type = "text/plain";
    }

    public InputStream getContentInputStream(HttpServer server) {
        InputStream result = null;
        this._server = (ScriptingHttpServer)server;
        try {
            if (this.isScriptanaResource()) {
                this._document = this.getCachedDocument();
                if (this._document == null) {
                    this.loadXHTML();
                } else {
                    ScriptInfo info = this.getScriptInfo();
                    if (info.needsRefresh()) {
                        this._server.removeScriptEnvironment(this.getUri());
                        this.loadXHTML();
                    } else {
                        Script[] scripts = info.getScripts();
                        Context cx = Context.enter();
                        int i = 0;
                        while (i < scripts.length) {
                            scripts[i].exec(cx, info.getScope());
                            ++i;
                        }
                        Context.exit();
                    }
                }
                this._text = this.nodeToString(this._document);
                result = new ByteArrayInputStream(this._text.getBytes("UTF-8"));
            } else {
                result = new FileInputStream(this._file);
            }
        }
        catch (UnsupportedEncodingException e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
        catch (FileNotFoundException e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
        return result;
    }

    private void loadXHTML() {
        this._server.createScriptEnvironment(this.getUri());
        try {
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            DocumentBuilder builder = factory.newDocumentBuilder();
            this._document = builder.parse(this._file);
            this.setCachedDocument();
            this.processScriptElements();
        }
        catch (ParserConfigurationException e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
        catch (SAXException e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
        catch (IOException e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
        catch (TransformerFactoryConfigurationError e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
    }

    private String nodeToString(Node node) {
        String result = "";
        try {
            DOMSource source = new DOMSource(node);
            StringWriter writer = new StringWriter();
            StreamResult streamResult = new StreamResult(writer);
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, streamResult);
            result = writer.toString();
        }
        catch (TransformerConfigurationException e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
        catch (TransformerException e) {
            String message = StringUtils.format((String)Messages.ScriptingHttpResource_Processing_Error, (String)this.getUri());
            IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message, (Throwable)e);
        }
        return result;
    }

    private void processScriptElements() {
        Element script;
        NodeList scripts = this._document.getElementsByTagName("script");
        Element[] scriptElements = new Element[scripts.getLength()];
        ArrayList<Element> serverScripts = new ArrayList<Element>();
        ArrayList<Element> serverOnlyScripts = new ArrayList<Element>();
        ArrayList<Element> clientServerScripts = new ArrayList<Element>();
        int i = 0;
        while (i < scripts.getLength()) {
            scriptElements[i] = (Element)scripts.item(i);
            ++i;
        }
        i = 0;
        while (i < scriptElements.length) {
            Element script2 = scriptElements[i];
            if (script2.hasAttribute(RUNAT_ATTR)) {
                String runAt = script2.getAttribute(RUNAT_ATTR);
                if (runAt.equals(SERVER)) {
                    serverScripts.add(script2);
                } else if (runAt.equals(SERVER_ONLY)) {
                    serverOnlyScripts.add(script2);
                } else if (runAt.equals(BOTH)) {
                    clientServerScripts.add(script2);
                }
            }
            ++i;
        }
        HashSet baselineFunctions = this.getFunctionNames();
        HashSet bothFunctions = new HashSet();
        HashSet serverFunctions = new HashSet();
        int i2 = 0;
        while (i2 < clientServerScripts.size()) {
            script = (Element)clientServerScripts.get(i2);
            this.runScript(script);
            script.removeAttribute(RUNAT_ATTR);
            bothFunctions.addAll(this.getFunctionNames());
            ++i2;
        }
        i2 = 0;
        while (i2 < serverScripts.size()) {
            script = (Element)serverScripts.get(i2);
            this.runScript(script);
            script.getParentNode().removeChild(script);
            serverFunctions.addAll(this.getFunctionNames());
            ++i2;
        }
        i2 = 0;
        while (i2 < serverOnlyScripts.size()) {
            script = (Element)serverOnlyScripts.get(i2);
            this.runScript(script);
            script.getParentNode().removeChild(script);
            ++i2;
        }
        bothFunctions.removeAll(baselineFunctions);
        serverFunctions.removeAll(baselineFunctions);
        serverFunctions.removeAll(bothFunctions);
        Element wrapper = this.createWrappers(serverFunctions.toArray(new String[0]));
        if (wrapper != null) {
            Element head;
            script = this._document.createElement("script");
            script.setAttribute("type", "text/javascript");
            script.setAttribute("src", "/aptana/libs/xmlhttp.js");
            NodeList heads = this._document.getElementsByTagName("head");
            if (heads.getLength() > 0) {
                head = (Element)heads.item(0);
            } else {
                Element html = this._document.getDocumentElement();
                head = this._document.createElement("head");
                if (html.hasChildNodes()) {
                    html.insertBefore(head, html.getFirstChild());
                } else {
                    html.appendChild(head);
                }
            }
            if (head.hasChildNodes()) {
                head.insertBefore(wrapper, head.getFirstChild());
            } else {
                head.appendChild(wrapper);
            }
            head.insertBefore(script, wrapper);
        }
    }

    private Element createWrappers(String[] names) {
        Element result = null;
        if (names.length > 0) {
            StringBuffer buffer = new StringBuffer();
            int i = 0;
            while (i < names.length) {
                buffer.append("\n");
                buffer.append(this.createFunctionWrapper(names[i]));
                ++i;
            }
            buffer.append("\n");
            String genCode = buffer.toString();
            result = this._document.createElement("script");
            Text wrapperCode = this._document.createTextNode(genCode);
            result.setAttribute("type", "text/javascript");
            result.appendChild(wrapperCode);
        }
        return result;
    }

    private String createFunctionWrapper(String name) {
        StringBuffer buffer = new StringBuffer();
        buffer.append("function ").append(name).append("() {").append(" ");
        buffer.append("return ___invokeFunction.call(null, \"").append(name).append("\", arguments);").append(" ");
        buffer.append("}");
        return buffer.toString();
    }

    private HashSet getFunctionNames() {
        ScriptInfo info = this.getScriptInfo();
        ScriptableObject global = (ScriptableObject)info.getScope();
        Object[] ids = global.getIds();
        HashSet<String> names = new HashSet<String>();
        int i = 0;
        while (i < ids.length) {
            Object idObject = ids[i];
            if (idObject instanceof String) {
                Object value;
                boolean readonly;
                String id = (String)idObject;
                int attrs = global.getAttributes(id);
                boolean bl = readonly = (attrs & 1) == 1;
                if (!readonly && (value = global.get(id, (Scriptable)global)) instanceof Callable) {
                    names.add(id);
                }
            }
            ++i;
        }
        return names;
    }

    private void runScript(Element script) {
        String code = null;
        if (script.hasAttribute("src")) {
            String candidate;
            String filename = script.getAttribute("src");
            File file = new File(filename);
            if (!file.exists()) {
                String parentDirectory = this._file.getParent();
                candidate = String.valueOf(parentDirectory) + File.separator + filename;
                file = new File(candidate);
            }
            if (!file.exists() && filename.startsWith("/")) {
                String rootServerPath = this._server.getRootPath();
                candidate = String.valueOf(rootServerPath) + filename;
                file = new File(candidate);
            }
            if (file.exists()) {
                try {
                    FileInputStream input = new FileInputStream(file);
                    code = FileUtilities.getStreamText(input);
                }
                catch (FileNotFoundException e) {
                    IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)Messages.ScriptingHttpResource_Error, (Throwable)e);
                }
            } else {
                String message = StringUtils.format((String)Messages.ScriptingHttpResource_File_Does_Not_Exist, (String)filename);
                IdeLog.logError((Plugin)ScriptingPlugin.getDefault(), (String)message);
            }
        } else {
            StringBuffer codePieces = new StringBuffer();
            Node child = script.getFirstChild();
            while (child != null) {
                codePieces.append(child.getNodeValue());
                child = child.getNextSibling();
            }
            code = codePieces.toString();
        }
        if (code != null && code.length() > 0) {
            this.runScript(code);
        }
    }

    private void runScript(String script) {
        this._server.include(this.getUri(), script);
    }
}

