/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.xul;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.core.IdeLog;
import com.aptana.ide.core.ui.CoreUIUtils;
import com.aptana.ide.editors.UnifiedEditorsPlugin;
import com.aptana.ide.editors.unified.ContributedBrowser;
import com.aptana.ide.editors.unified.ContributedOutline;
import com.aptana.ide.xul.FirefoxConsole;
import com.aptana.ide.xul.FirefoxExtensionsSupport;
import com.aptana.ide.xul.SelectionBox;
import com.aptana.ide.xul.XULPlugin;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.SWT;
import org.eclipse.swt.browser.Browser;
import org.eclipse.swt.browser.LocationListener;
import org.eclipse.swt.browser.ProgressEvent;
import org.eclipse.swt.browser.ProgressListener;
import org.eclipse.swt.events.MouseAdapter;
import org.eclipse.swt.events.MouseEvent;
import org.eclipse.swt.events.MouseListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.ide.IDE;
import org.eclipse.ui.progress.UIJob;
import org.mozilla.interfaces.nsICacheService;
import org.mozilla.interfaces.nsIConsoleListener;
import org.mozilla.interfaces.nsIConsoleMessage;
import org.mozilla.interfaces.nsIConsoleService;
import org.mozilla.interfaces.nsIDOMDocument;
import org.mozilla.interfaces.nsIDOMElement;
import org.mozilla.interfaces.nsIDOMHTMLScriptElement;
import org.mozilla.interfaces.nsIDOMNode;
import org.mozilla.interfaces.nsIDOMSerializer;
import org.mozilla.interfaces.nsIDOMWindow;
import org.mozilla.interfaces.nsIScriptError;
import org.mozilla.interfaces.nsISupports;
import org.mozilla.interfaces.nsIWebBrowser;
import org.mozilla.xpcom.Mozilla;
import org.mozilla.xpcom.XPCOMException;
import org.osgi.framework.Bundle;

public class FirefoxBrowser
extends ContributedBrowser {
    public static final String XULRUNNER_ENV = "org.eclipse.swt.browser.XULRunnerPath";
    public static final String XULRUNNER_MAC_PLUGIN = "org.mozilla.xulrunner.carbon.macosx";
    public static final String XULRUNNER_WIN32_PLUGIN = "org.mozilla.xulrunner.win32.win32.x86";
    public static final String XULRUNNER_PATH = "/xulrunner";
    private static boolean useNativeMozilla = false;
    private static int nativeMozillaField = 0;
    private static Class MozillaBrowser = null;
    private Composite errors;
    private Label errorIcon;
    private Label errorLabel;
    private Cursor hand;
    private int errorCount;
    private nsIConsoleListener errorListener = new nsIConsoleListener(){

        public nsISupports queryInterface(String arg0) {
            return null;
        }

        public void observe(nsIConsoleMessage message) {
            nsIScriptError error = (nsIScriptError)message.queryInterface("{b0196fc7-1913-441a-882a-453c0d8b89b8}");
            if (error == null) {
                return;
            }
            if (FirefoxBrowser.this.browser == null || FirefoxBrowser.this.browser.isDisposed()) {
                return;
            }
            long flag = error.getFlags();
            if ((flag == 0L || flag == 2L) && error.getSourceName().equals(FirefoxBrowser.this.internalGetUrl())) {
                FirefoxBrowser firefoxBrowser = FirefoxBrowser.this;
                firefoxBrowser.errorCount = firefoxBrowser.errorCount + 1;
                if (FirefoxBrowser.this.errorCount == 1) {
                    FirefoxBrowser.this.errorIcon.setImage(XULPlugin.getDefault().getImage("ERRORS_IMG_ID"));
                    FirefoxBrowser.this.errorLabel.setText(String.valueOf(FirefoxBrowser.this.errorCount) + " Error");
                    FirefoxBrowser.this.errorLabel.setToolTipText("Errors exist in the current page");
                    FirefoxBrowser.this.errorIcon.setToolTipText(FirefoxBrowser.this.errorLabel.getToolTipText());
                } else {
                    FirefoxBrowser.this.errorLabel.setText(String.valueOf(FirefoxBrowser.this.errorCount) + " Errors");
                }
                FirefoxBrowser.this.errors.layout(true, true);
                FirefoxBrowser.this.errors.getParent().layout(true, true);
            }
        }
    };
    private ProgressListener progressListener = new ProgressListener(){

        public void changed(ProgressEvent event) {
        }

        public void completed(ProgressEvent event) {
            FirefoxBrowser.this.progressCompleted(event);
            FirefoxBrowser.this.handleProgressCompleted(event);
        }
    };
    private Composite browser;
    private nsIDOMDocument document;
    private ContributedOutline outline;
    private SelectionBox selectionBox = null;

    static {
        if (CoreUIUtils.inEclipse34orHigher) {
            try {
                Field mozillaField = SWT.class.getField("MOZILLA");
                if (mozillaField.getType().equals(Integer.TYPE)) {
                    nativeMozillaField = mozillaField.getInt(SWT.class);
                    useNativeMozilla = true;
                }
            }
            catch (Exception exception) {
                useNativeMozilla = false;
            }
        }
        if (!useNativeMozilla) {
            Bundle bundle = Platform.getBundle((String)"org.eclipse.swt");
            try {
                MozillaBrowser = bundle.loadClass("org.eclipse.swt.browser.MozillaBrowser");
                if (MozillaBrowser != null) {
                    useNativeMozilla = false;
                }
            }
            catch (ClassNotFoundException e1) {
                IdeLog.logError((Plugin)XULPlugin.getDefault(), (String)"No Mozilla browser found", (Throwable)e1);
                useNativeMozilla = true;
            }
        }
        if (useNativeMozilla) {
            FirefoxExtensionsSupport.init();
        }
    }

    private Composite createSWTBrowser(Composite parent) {
        block8: {
            try {
                URL xulrunner;
                if (System.getProperty(XULRUNNER_ENV) != null) break block8;
                Bundle bundle = null;
                if (CoreUIUtils.onWindows) {
                    bundle = Platform.getBundle((String)XULRUNNER_WIN32_PLUGIN);
                } else if (CoreUIUtils.onMacOSX) {
                    bundle = Platform.getBundle((String)XULRUNNER_MAC_PLUGIN);
                }
                if (bundle == null || (xulrunner = bundle.getEntry(XULRUNNER_PATH)) == null) break block8;
                try {
                    xulrunner = FileLocator.toFileURL((URL)xulrunner);
                    if (xulrunner != null) {
                        File xulrunnerFolder = new File(xulrunner.getFile());
                        System.setProperty(XULRUNNER_ENV, xulrunnerFolder.getAbsolutePath());
                        IdeLog.logInfo((Plugin)XULPlugin.getDefault(), (String)("Setting XULRunnerPath to: " + xulrunnerFolder.getAbsolutePath()));
                    }
                }
                catch (IOException e) {
                    IdeLog.logError((Plugin)XULPlugin.getDefault(), (String)"Error setting XULRunnerPath", (Throwable)e);
                }
            }
            catch (Exception e) {
                IdeLog.logError((Plugin)XULPlugin.getDefault(), (String)"Error setting XULRunnerPath", (Throwable)e);
            }
        }
        this.browser = new Browser(parent, nativeMozillaField);
        ((Browser)this.browser).addProgressListener(this.progressListener);
        return this.browser;
    }

    private Composite createMozillaBrowser(Composite parent) {
        try {
            if (MozillaBrowser != null) {
                Constructor mozillaBrowserConstructor = MozillaBrowser.getConstructor(Composite.class, Integer.TYPE);
                Object mozillaBrowser = mozillaBrowserConstructor.newInstance(parent, 0);
                Method addProgressListener = MozillaBrowser.getMethod("addProgressListener", ProgressListener.class);
                addProgressListener.invoke(mozillaBrowser, this.progressListener);
                if (mozillaBrowser instanceof Composite) {
                    this.browser = (Composite)mozillaBrowser;
                }
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return this.browser;
    }

    public void createControl(Composite parent) {
        this.browser = useNativeMozilla ? this.createSWTBrowser(parent) : this.createMozillaBrowser(parent);
        this.browser.setLayoutData((Object)new GridData(4, 4, true, true));
        this.errors = new Composite(parent, 0);
        GridLayout eLayout = new GridLayout(2, false);
        eLayout.marginHeight = 1;
        eLayout.marginWidth = 1;
        eLayout.horizontalSpacing = 2;
        this.errors.setLayout((Layout)eLayout);
        this.errors.setLayoutData((Object)new GridData(4, 4, true, false));
        this.hand = new Cursor((Device)this.errors.getDisplay(), 21);
        this.errorIcon = new Label(this.errors, 16384);
        this.errorIcon.setCursor(this.hand);
        MouseAdapter showConsole = new MouseAdapter(){

            public void mouseDown(MouseEvent e) {
                ConsolePlugin.getDefault().getConsoleManager().showConsoleView((IConsole)FirefoxConsole.getConsole());
            }
        };
        this.errorIcon.setLayoutData((Object)new GridData(0x1000008, 4, true, true));
        this.errorIcon.addMouseListener((MouseListener)showConsole);
        this.errorLabel = new Label(this.errors, 16384);
        this.errorLabel.setCursor(this.hand);
        this.errorLabel.addMouseListener((MouseListener)showConsole);
        this.errorLabel.setForeground(this.errorLabel.getDisplay().getSystemColor(4));
        this.errorLabel.setLayoutData((Object)new GridData(0x1000008, 0x1000000, false, true));
        nsIConsoleService service = (nsIConsoleService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/consoleservice;1", "{a647f184-1dd1-11b2-a9d1-8537b201161b}");
        service.registerListener(this.errorListener);
        FirefoxConsole.getConsole();
    }

    private void internalRefresh() {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).refresh();
        } else {
            try {
                Method refresh = this.browser.getClass().getMethod("refresh", new Class[0]);
                refresh.invoke((Object)this.browser, new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public void refresh() {
        if (this.browser != null && !this.browser.isDisposed()) {
            this.clearCache();
            this.clearErrors();
            this.internalRefresh();
        }
    }

    private void clearCache() {
        if (UnifiedEditorsPlugin.getDefault().getPreferenceStore().getBoolean("com.aptana.ide.editors.CACHE_BUST_BROWSERS")) {
            try {
                nsICacheService cache = (nsICacheService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/network/cache-service;1", "{de114eb4-29fc-4959-b2f7-2d03eb9bc771}");
                cache.evictEntries(0);
            }
            catch (Exception e) {
                if (e instanceof XPCOMException && ((XPCOMException)((Object)e)).errorcode == 2152857618L) {
                    return;
                }
                IdeLog.logError((Plugin)XULPlugin.getDefault(), (String)"Error clearing cache on Firefox browser", (Throwable)e);
            }
        }
    }

    public void dispose() {
        this.browser.dispose();
        if (this.hand != null && !this.hand.isDisposed()) {
            this.hand.dispose();
        }
        this.errors.dispose();
        nsIConsoleService service = (nsIConsoleService)Mozilla.getInstance().getServiceManager().getServiceByContractID("@mozilla.org/consoleservice;1", "{a647f184-1dd1-11b2-a9d1-8537b201161b}");
        service.unregisterListener(this.errorListener);
    }

    public Control getControl() {
        return this.browser;
    }

    private void clearErrors() {
        this.errorCount = 0;
        this.errorIcon.setImage(XULPlugin.getDefault().getImage("NO_ERRORS_IMG_ID"));
        this.errorLabel.setText("");
        this.errorLabel.setToolTipText("");
        this.errorIcon.setToolTipText("No errors in the current page");
        this.errors.layout(true, true);
    }

    public void setURL(String url) {
        this.clearCache();
        this.clearErrors();
        this.internalSetUrl(url);
    }

    private void internalSetUrl(String url) {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).setUrl(url);
        } else {
            try {
                Method setUrl = this.browser.getClass().getMethod("setUrl", String.class);
                setUrl.invoke((Object)this.browser, url);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    private String internalGetUrl() {
        if (this.browser instanceof Browser) {
            return ((Browser)this.browser).getUrl();
        }
        try {
            Method getUrl = this.browser.getClass().getMethod("getUrl", new Class[0]);
            Object retVal = getUrl.invoke((Object)this.browser, new Object[0]);
            if (retVal instanceof String) {
                return (String)retVal;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        return null;
    }

    public nsIDOMDocument getDocument() {
        return this.document;
    }

    public void setOutline(ContributedOutline outline) {
        this.outline = outline;
    }

    private void handleProgressCompleted(ProgressEvent event) {
        this.document = this.internalGetDocument();
        if (this.document != null) {
            this.selectionBox = new SelectionBox(this.document);
        } else {
            IdeLog.logError((Plugin)XULPlugin.getDefault(), (String)"Unable to get XulRunner document for creation of SelectionBox");
        }
        if (this.outline != null) {
            this.outline.refresh();
        }
    }

    public void highlightElement(nsIDOMNode element) {
        if (element.getNodeType() == 1) {
            this.selectionBox.highlight((nsIDOMElement)element.queryInterface("{a6cf9078-15b3-11d2-932e-00805f8add32}"));
        } else {
            this.selectionBox.hide();
        }
    }

    public void back() {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).back();
        } else {
            try {
                Method back = this.browser.getClass().getMethod("back", new Class[0]);
                back.invoke((Object)this.browser, new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public void forward() {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).forward();
        } else {
            try {
                Method forward = this.browser.getClass().getMethod("forward", new Class[0]);
                forward.invoke((Object)this.browser, new Object[0]);
            }
            catch (SecurityException securityException) {
            }
            catch (NoSuchMethodException noSuchMethodException) {
            }
            catch (IllegalArgumentException illegalArgumentException) {
            }
            catch (IllegalAccessException illegalAccessException) {
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    public Object getUnderlyingBrowserObject() {
        return this.browser;
    }

    private nsIDOMDocument internalGetDocument() {
        nsIWebBrowser webBrowser = null;
        nsIDOMDocument nsidomdocument = null;
        try {
            Method getWebBrowser = this.browser.getClass().getMethod("getWebBrowser", new Class[0]);
            Object retVal = getWebBrowser.invoke((Object)this.browser, new Object[0]);
            if (retVal instanceof nsIWebBrowser) {
                webBrowser = (nsIWebBrowser)retVal;
            }
        }
        catch (SecurityException securityException) {
        }
        catch (NoSuchMethodException noSuchMethodException) {
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (InvocationTargetException invocationTargetException) {}
        if (webBrowser != null) {
            nsIDOMWindow nsidomwindow = webBrowser.getContentDOMWindow();
            nsidomdocument = nsidomwindow.getDocument();
        }
        return nsidomdocument;
    }

    public boolean execute(String script) {
        nsIDOMDocument document = this.internalGetDocument();
        if (document != null) {
            nsIDOMElement se = document.createElement("script");
            nsIDOMHTMLScriptElement scriptBlock = (nsIDOMHTMLScriptElement)se.queryInterface("{a6cf90b1-15b3-11d2-932e-00805f8add32}");
            String s2 = "if(" + script + "){" + "document.getElementById('execute').setAttribute('text','success');}";
            scriptBlock.setText(s2);
            nsIDOMElement executeBlock = document.getElementById("execute");
            if (executeBlock == null) {
                executeBlock = document.createElement("div");
                executeBlock.setAttribute("id", "execute");
                nsIDOMNode body = document.getElementsByTagName("body").item(0L);
                body.appendChild((nsIDOMNode)executeBlock);
            }
            executeBlock.setAttribute("text", "");
            nsIDOMNode head = document.getElementsByTagName("head").item(0L);
            head.appendChild((nsIDOMNode)scriptBlock);
            executeBlock = document.getElementById("execute");
            return "success".equals(executeBlock.getAttribute("text"));
        }
        return false;
    }

    public void displaySource() {
        if (this.document != null) {
            nsIDOMSerializer serializer = (nsIDOMSerializer)Mozilla.getInstance().getComponentManager().createInstanceByContractID("@mozilla.org/xmlextras/xmlserializer;1", null, "{9fd4ba15-e67c-4c98-b52c-7715f62c9196}");
            String source = serializer.serializeToString((nsIDOMNode)this.document.getDocumentElement());
            try {
                String newFileName = FileUtils.getRandomFileName((String)"source", (String)".html");
                final File temp = new File(String.valueOf(FileUtils.systemTempDir) + File.separator + newFileName);
                FileUtils.writeStringToFile((String)source, (File)temp);
                UIJob openJob = new UIJob("Open source editor"){

                    public IStatus runInUIThread(IProgressMonitor monitor) {
                        IEditorInput input = CoreUIUtils.createJavaFileEditorInput((File)temp);
                        try {
                            IDE.openEditor((IWorkbenchPage)XULPlugin.getDefault().getWorkbench().getActiveWorkbenchWindow().getActivePage(), (IEditorInput)input, (String)"com.aptana.ide.editors.HTMLEditor");
                        }
                        catch (PartInitException e) {
                            e.printStackTrace();
                        }
                        return Status.OK_STATUS;
                    }
                };
                openJob.schedule();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void addLocationListener(LocationListener listener) {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).addLocationListener(listener);
        } else {
            try {
                Method addLocationListener = MozillaBrowser.getMethod("addLocationListener", LocationListener.class);
                addLocationListener.invoke((Object)this.browser, listener);
            }
            catch (SecurityException e) {
                this.error(e);
            }
            catch (NoSuchMethodException e) {
                this.error(e);
            }
            catch (IllegalArgumentException e) {
                this.error(e);
            }
            catch (IllegalAccessException e) {
                this.error(e);
            }
            catch (InvocationTargetException e) {
                this.error(e);
            }
        }
    }

    public void removeLocationListener(LocationListener listener) {
        if (this.browser instanceof Browser) {
            ((Browser)this.browser).removeLocationListener(listener);
        } else {
            try {
                Method removeLocationListener = MozillaBrowser.getMethod("removeLocationListener", LocationListener.class);
                removeLocationListener.invoke((Object)this.browser, listener);
            }
            catch (SecurityException e) {
                this.error(e);
            }
            catch (NoSuchMethodException e) {
                this.error(e);
            }
            catch (IllegalArgumentException e) {
                this.error(e);
            }
            catch (IllegalAccessException e) {
                this.error(e);
            }
            catch (InvocationTargetException invocationTargetException) {}
        }
    }

    private void error(Exception e) {
        IdeLog.logError((Plugin)XULPlugin.getDefault(), (String)"Failed to interact with the Mozilla browser", (Throwable)e);
    }
}

