/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.internet.internal.proxy;

import com.aptana.ide.core.AptanaAuthenticator;
import com.aptana.ide.internet.internal.proxy.Encoder;
import com.aptana.ide.internet.internal.proxy.Log;
import com.aptana.ide.internet.internal.proxy.Messages;
import java.util.Properties;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.IStartup;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;

public class InternetPlugin
extends AbstractUIPlugin
implements IStartup {
    public static final String ID = "com.aptana.ide.internet.proxy";
    private static InternetPlugin instance;
    public static final String PREFERENCE_PROXYCHECKED = "proxyCheckBox";
    public static final String PREFERENCE_NAMECHECKED = "nameCheckBox";
    public static final String PREFERENCE_SOCKSCHECKED = "socksCheckBox";
    public static final String PREFERENCE_HOSTNAME = "hostnameText";
    public static final String PREFERENCE_PORT = "portText";
    public static final String PREFERENCE_USERNAME = "userNameText";
    public static final String PREFERENCE_PASSWORD = "passwordText";
    public static final String PREFERENCE_NON_PROXY_HOSTS = "nonProxyHostsText";

    public InternetPlugin() {
        instance = this;
    }

    public static InternetPlugin getInstance() {
        return instance;
    }

    public void start(BundleContext context) throws Exception {
        super.start(context);
        this.updateProxyProperties();
    }

    public void earlyStartup() {
        this.updateProxyProperties();
    }

    public void updateProxyProperties() {
        IPreferenceStore store = this.getPreferenceStore();
        boolean setProxy = store.getBoolean(PREFERENCE_PROXYCHECKED);
        boolean useSOCKS = store.getBoolean(PREFERENCE_SOCKSCHECKED);
        boolean setName = store.getBoolean(PREFERENCE_NAMECHECKED);
        Properties sysProps = System.getProperties();
        Log.write((Object)this, "updateProxyProperties", 1, "proxySet: " + setProxy);
        if (setProxy) {
            String hostname = store.getString(PREFERENCE_HOSTNAME);
            String port = store.getString(PREFERENCE_PORT);
            String nonProxyHosts = store.getString(PREFERENCE_NON_PROXY_HOSTS);
            sysProps.put("proxySet", "true");
            if (useSOCKS) {
                sysProps.put("socksProxyHost", hostname);
                sysProps.put("socksProxyPort", port);
                sysProps.remove("proxyHost");
                sysProps.remove("proxyPort");
                sysProps.remove("http.proxySet");
                sysProps.remove("http.proxyHost");
                sysProps.remove("http.proxyPort");
                sysProps.remove("http.nonProxyHosts");
                sysProps.remove("https.proxySet");
                sysProps.remove("https.proxyHost");
                sysProps.remove("https.proxyPort");
                sysProps.remove("https.nonProxyHosts");
            } else {
                sysProps.remove("socksProxyHost");
                sysProps.remove("socksProxyPort");
                sysProps.put("proxyHost", hostname);
                sysProps.put("proxyPort", port);
                sysProps.put("http.proxySet", "true");
                sysProps.put("http.proxyHost", hostname);
                sysProps.put("http.proxyPort", port);
                sysProps.put("http.nonProxyHosts", nonProxyHosts);
                sysProps.put("https.proxySet", "true");
                sysProps.put("https.proxyHost", hostname);
                sysProps.put("https.proxyPort", port);
                sysProps.put("https.nonProxyHosts", nonProxyHosts);
            }
            if (setName) {
                String userName = store.getString(PREFERENCE_USERNAME);
                String password = store.getString(PREFERENCE_PASSWORD);
                userName = Encoder.isEncoded(userName) ? Encoder.decode(userName) : userName;
                password = Encoder.isEncoded(password) ? Encoder.decode(password) : password;
                AptanaAuthenticator.addProxyEntry((String)hostname, (String)userName, (String)password);
                sysProps.put("http.proxyUserName", userName);
                sysProps.put("http.proxyPassword", password);
                sysProps.put("https.proxyUserName", userName);
                sysProps.put("https.proxyPassword", password);
            } else {
                Log.write((Object)this, "updateProxyProperties", 1, Messages.InternetPlugin_RemovingProxyNameProperties);
                sysProps.remove("http.proxyUserName");
                sysProps.remove("http.proxyPassword");
                sysProps.remove("https.proxyUserName");
                sysProps.remove("https.proxyPassword");
            }
            Log.write((Object)this, "updateProxyProperties", 1, "proxyHost: " + hostname);
            Log.write((Object)this, "updateProxyProperties", 1, "proxyPort: " + port);
            Log.write((Object)this, "updateProxyProperties", 1, "http.proxyHost: " + hostname);
            Log.write((Object)this, "updateProxyProperties", 1, "http.proxyPort: " + port);
            Log.write((Object)this, "updateProxyProperties", 1, "http.nonProxyHosts: " + nonProxyHosts);
        } else {
            Log.write((Object)this, "updateProxyProperties", 1, Messages.InternetPlugin_RemovingProxyProperties);
            sysProps.remove("proxySet");
            sysProps.remove("proxyHost");
            sysProps.remove("proxyPort");
            sysProps.remove("socksProxyHost");
            sysProps.remove("socksProxyPort");
            sysProps.remove("http.proxySet");
            sysProps.remove("http.proxyHost");
            sysProps.remove("http.proxyPort");
            sysProps.remove("http.proxyUserName");
            sysProps.remove("http.proxyPassword");
            sysProps.remove("http.nonProxyHosts");
            sysProps.remove("https.proxySet");
            sysProps.remove("https.proxyHost");
            sysProps.remove("https.proxyPort");
            sysProps.remove("https.proxyUserName");
            sysProps.remove("https.proxyPassword");
            sysProps.remove("https.nonProxyHosts");
        }
    }
}

