/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.intro.messaging;

import org.eclipse.jface.dialogs.PopupDialog;
import org.eclipse.jface.text.DefaultInformationControl;
import org.eclipse.jface.text.IInformationControl;
import org.eclipse.jface.text.IInformationControlExtension;
import org.eclipse.jface.text.IInformationControlExtension3;
import org.eclipse.jface.text.TextPresentation;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.DisposeEvent;
import org.eclipse.swt.events.DisposeListener;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.KeyEvent;
import org.eclipse.swt.events.KeyListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class ExtensibleInformationControl
implements IInformationControl,
IInformationControlExtension,
IInformationControlExtension3,
DisposeListener {
    private static final int INNER_BORDER = 1;
    private PopupDialog fPopupDialog;
    private StyledText fText;
    private DefaultInformationControl.IInformationPresenter fPresenter;
    private TextPresentation fPresentation = new TextPresentation();
    private int fMaxWidth = -1;
    private int fMaxHeight = -1;

    public StyledText getWidget() {
        return this.fText;
    }

    public ExtensibleInformationControl(Shell parent, int shellStyle, int style, DefaultInformationControl.IInformationPresenter presenter) {
        this(parent, shellStyle, style, presenter, null);
    }

    public ExtensibleInformationControl(Shell parentShell, int shellStyle, final int style, DefaultInformationControl.IInformationPresenter presenter, String statusFieldText) {
        shellStyle = shellStyle | 0x80000 | 0x4000;
        this.fPopupDialog = new PopupDialog(parentShell, shellStyle, false, false, false, false, null, statusFieldText){

            protected Control createDialogArea(Composite parent) {
                ExtensibleInformationControl.this.fText = new StyledText(parent, 0xA | style);
                GridData gd = new GridData(1809);
                gd.horizontalIndent = 1;
                gd.verticalIndent = 1;
                ExtensibleInformationControl.this.fText.setLayoutData((Object)gd);
                ExtensibleInformationControl.this.fText.addKeyListener(new KeyListener(){

                    public void keyPressed(KeyEvent e) {
                        if (e.character == '\u001b') {
                            this.close();
                        }
                    }

                    public void keyReleased(KeyEvent e) {
                    }
                });
                return ExtensibleInformationControl.this.fText;
            }
        };
        this.fPresenter = presenter;
        this.fPopupDialog.create();
    }

    public ExtensibleInformationControl(Shell parent, int style, DefaultInformationControl.IInformationPresenter presenter) {
        this(parent, 12, style, presenter);
    }

    public ExtensibleInformationControl(Shell parent, int style, DefaultInformationControl.IInformationPresenter presenter, String statusFieldText) {
        this(parent, 12, style, presenter, statusFieldText);
    }

    public ExtensibleInformationControl(Shell parent) {
        this(parent, 0, null);
    }

    public ExtensibleInformationControl(Shell parent, DefaultInformationControl.IInformationPresenter presenter) {
        this(parent, 0, presenter);
    }

    public void setInformation(String content) {
        if (this.fPresenter == null) {
            this.fText.setText(content);
        } else {
            this.fPresentation.clear();
            content = this.fPresenter instanceof DefaultInformationControl.IInformationPresenterExtension ? ((DefaultInformationControl.IInformationPresenterExtension)this.fPresenter).updatePresentation((Drawable)this.fPopupDialog.getShell(), content, this.fPresentation, this.fMaxWidth, this.fMaxHeight) : this.fPresenter.updatePresentation(this.fPopupDialog.getShell().getDisplay(), content, this.fPresentation, this.fMaxWidth, this.fMaxHeight);
            if (content != null) {
                this.fText.setText(content);
                TextPresentation.applyTextPresentation((TextPresentation)this.fPresentation, (StyledText)this.fText);
            } else {
                this.fText.setText("");
            }
        }
    }

    public void setVisible(boolean visible) {
        if (visible) {
            if (this.fText.getWordWrap()) {
                Point currentSize = this.fPopupDialog.getShell().getSize();
                this.fPopupDialog.getShell().pack(true);
                Point newSize = this.fPopupDialog.getShell().getSize();
                if (newSize.x > currentSize.x || newSize.y > currentSize.y) {
                    this.setSize(currentSize.x, currentSize.y);
                }
            }
            this.fPopupDialog.open();
        } else {
            this.fPopupDialog.getShell().setVisible(false);
        }
    }

    public void dispose() {
        this.fPopupDialog.close();
        this.fPopupDialog = null;
    }

    public void setSize(int width, int height) {
        this.fPopupDialog.getShell().setSize(width, height);
    }

    public void setLocation(Point location) {
        this.fPopupDialog.getShell().setLocation(location);
    }

    public void setSizeConstraints(int maxWidth, int maxHeight) {
        this.fMaxWidth = maxWidth;
        this.fMaxHeight = maxHeight;
    }

    public Point computeSizeHint() {
        int widthHint = -1;
        if (this.fMaxWidth > -1 && this.fText.getWordWrap()) {
            widthHint = this.fMaxWidth;
        }
        return this.fPopupDialog.getShell().computeSize(widthHint, -1, true);
    }

    public Rectangle computeTrim() {
        return this.fPopupDialog.getShell().computeTrim(0, 0, 0, 0);
    }

    public Rectangle getBounds() {
        return this.fPopupDialog.getShell().getBounds();
    }

    public boolean restoresLocation() {
        return false;
    }

    public boolean restoresSize() {
        return false;
    }

    public void addDisposeListener(DisposeListener listener) {
        this.fPopupDialog.getShell().addDisposeListener(listener);
    }

    public void removeDisposeListener(DisposeListener listener) {
        this.fPopupDialog.getShell().removeDisposeListener(listener);
    }

    public void setForegroundColor(Color foreground) {
        this.fText.setForeground(foreground);
    }

    public void setBackgroundColor(Color background) {
        this.fText.setBackground(background);
    }

    public boolean isFocusControl() {
        return this.fText.isFocusControl();
    }

    public void setFocus() {
        this.fPopupDialog.getShell().forceFocus();
        this.fText.setFocus();
    }

    public void addFocusListener(FocusListener listener) {
        this.fText.addFocusListener(listener);
    }

    public void removeFocusListener(FocusListener listener) {
        this.fText.removeFocusListener(listener);
    }

    public boolean hasContents() {
        return this.fText.getCharCount() > 0;
    }

    public void widgetDisposed(DisposeEvent event) {
    }
}

