/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.utils;

import com.aptana.ide.editors.unified.utils.FileNode;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.text.MessageFormat;
import java.util.HashSet;
import java.util.ResourceBundle;
import java.util.Set;
import org.eclipse.compare.CompareConfiguration;
import org.eclipse.compare.CompareEditorInput;
import org.eclipse.compare.ITypedElement;
import org.eclipse.compare.internal.BufferedResourceNode;
import org.eclipse.compare.internal.Utilities;
import org.eclipse.compare.structuremergeviewer.DiffNode;
import org.eclipse.compare.structuremergeviewer.DiffTreeViewer;
import org.eclipse.compare.structuremergeviewer.Differencer;
import org.eclipse.compare.structuremergeviewer.IDiffContainer;
import org.eclipse.compare.structuremergeviewer.IDiffElement;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.widgets.Composite;

public class FileCompareEditorInput
extends CompareEditorInput {
    private static final boolean NORMALIZE_CASE = true;
    private Object fRoot;
    private FileNode fLeft;
    private FileNode fRight;
    private File fLeftResource;
    private File fRightResource;
    private DiffTreeViewer fDiffViewer;
    private IAction fOpenAction;

    public FileCompareEditorInput(CompareConfiguration config) {
        super(config);
    }

    public Viewer createDiffViewer(Composite parent) {
        this.fDiffViewer = new DiffTreeViewer(parent, this.getCompareConfiguration()){

            protected void fillContextMenu(IMenuManager manager) {
                IStructuredSelection ss;
                if (FileCompareEditorInput.this.fOpenAction == null) {
                    FileCompareEditorInput.this.fOpenAction = (IAction)new Action(){

                        public void run() {
                            this.handleOpen(null);
                        }
                    };
                    Utilities.initAction((IAction)FileCompareEditorInput.this.fOpenAction, (ResourceBundle)this.getBundle(), (String)"action.CompareContents.");
                }
                boolean enable = false;
                ISelection selection = this.getSelection();
                if (selection instanceof IStructuredSelection && (ss = (IStructuredSelection)selection).size() == 1) {
                    Object element = ss.getFirstElement();
                    if (element instanceof MyDiffNode) {
                        ITypedElement te = ((MyDiffNode)((Object)element)).getId();
                        if (te != null) {
                            enable = !"FOLDER".equals(te.getType());
                        }
                    } else {
                        enable = true;
                    }
                }
                FileCompareEditorInput.this.fOpenAction.setEnabled(enable);
                manager.add(FileCompareEditorInput.this.fOpenAction);
                super.fillContextMenu(manager);
            }
        };
        return this.fDiffViewer;
    }

    public void setLeftResource(File resource) {
        this.fLeftResource = resource;
        this.fLeft = new FileNode(this.fLeftResource);
    }

    public void setRightResource(File resource) {
        this.fRightResource = resource;
        this.fRight = new FileNode(this.fRightResource);
    }

    void initializeCompareConfiguration() {
        CompareConfiguration cc = this.getCompareConfiguration();
        if (this.fLeft != null) {
            cc.setLeftLabel(this.fLeft.getName());
            cc.setLeftImage(this.fLeft.getImage());
        }
        if (this.fRight != null) {
            cc.setRightLabel(this.fRight.getName());
            cc.setRightImage(this.fRight.getImage());
        }
    }

    protected void prepareFiles() {
    }

    public Object prepareInput(IProgressMonitor pm) throws InvocationTargetException {
        try {
            pm.beginTask(Utilities.getString((String)"ResourceCompare.taskName"), -1);
            this.prepareFiles();
            String leftLabel = this.fLeftResource.getName();
            String rightLabel = this.fRightResource.getName();
            String format = Utilities.getString((String)"ResourceCompare.twoWay.title");
            String title = MessageFormat.format(format, leftLabel, rightLabel);
            this.setTitle(title);
            Differencer d = new Differencer(){

                protected Object visit(Object parent, int description, Object ancestor, Object left, Object right) {
                    return new MyDiffNode((IDiffContainer)parent, description, (ITypedElement)ancestor, (ITypedElement)left, (ITypedElement)right);
                }
            };
            Object object = this.fRoot = d.findDifferences(false, pm, null, null, (Object)this.fLeft, (Object)this.fRight);
            return object;
        }
        finally {
            pm.done();
        }
    }

    public String getToolTipText() {
        if (this.fLeftResource != null && this.fRightResource != null) {
            String leftLabel = this.fLeftResource.getAbsolutePath();
            String rightLabel = this.fRightResource.getAbsolutePath();
            String format = Utilities.getString((String)"ResourceCompare.twoWay.tooltip");
            return MessageFormat.format(format, leftLabel, rightLabel);
        }
        return super.getToolTipText();
    }

    public void saveChanges(IProgressMonitor pm) throws CoreException {
        super.saveChanges(pm);
        if (this.fRoot instanceof DiffNode) {
            try {
                FileCompareEditorInput.commit(pm, (DiffNode)this.fRoot);
            }
            finally {
                if (this.fDiffViewer != null) {
                    this.fDiffViewer.refresh();
                }
                this.setDirty(false);
            }
        }
    }

    private static void commit(IProgressMonitor pm, DiffNode node) throws CoreException {
        IDiffElement[] children;
        ITypedElement right;
        ITypedElement left;
        if (node instanceof MyDiffNode) {
            ((MyDiffNode)node).clearDirty();
        }
        if ((left = node.getLeft()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)left).commit(pm);
        }
        if ((right = node.getRight()) instanceof BufferedResourceNode) {
            ((BufferedResourceNode)right).commit(pm);
        }
        if ((children = node.getChildren()) != null) {
            int i = 0;
            while (i < children.length) {
                IDiffElement element = children[i];
                if (element instanceof DiffNode) {
                    FileCompareEditorInput.commit(pm, (DiffNode)element);
                }
                ++i;
            }
        }
    }

    public Object getAdapter(Class adapter) {
        if (IFile[].class.equals((Object)adapter)) {
            HashSet collector = new HashSet();
            this.collectDirtyResources(this.fRoot, collector);
            return collector.toArray(new IFile[collector.size()]);
        }
        return super.getAdapter(adapter);
    }

    private void collectDirtyResources(Object o, Set collector) {
        if (o instanceof DiffNode) {
            IDiffElement[] children;
            IResource resource;
            BufferedResourceNode bn;
            ITypedElement right;
            IResource resource2;
            BufferedResourceNode bn2;
            DiffNode node = (DiffNode)o;
            ITypedElement left = node.getLeft();
            if (left instanceof BufferedResourceNode && (bn2 = (BufferedResourceNode)left).isDirty() && (resource2 = bn2.getResource()) instanceof IFile) {
                collector.add(resource2);
            }
            if ((right = node.getRight()) instanceof BufferedResourceNode && (bn = (BufferedResourceNode)right).isDirty() && (resource = bn.getResource()) instanceof IFile) {
                collector.add(resource);
            }
            if ((children = node.getChildren()) != null) {
                int i = 0;
                while (i < children.length) {
                    IDiffElement element = children[i];
                    if (element instanceof DiffNode) {
                        this.collectDirtyResources(element, collector);
                    }
                    ++i;
                }
            }
        }
    }

    private static String normalizeCase(String s) {
        if (s != null) {
            return s.toUpperCase();
        }
        return s;
    }

    class MyDiffNode
    extends DiffNode {
        private boolean fDirty;
        private ITypedElement fLastId;
        private String fLastName;

        public MyDiffNode(IDiffContainer parent, int description, ITypedElement ancestor, ITypedElement left, ITypedElement right) {
            super(parent, description, ancestor, left, right);
            this.fDirty = false;
        }

        public void fireChange() {
            super.fireChange();
            FileCompareEditorInput.this.setDirty(true);
            this.fDirty = true;
            if (FileCompareEditorInput.this.fDiffViewer != null) {
                FileCompareEditorInput.this.fDiffViewer.refresh((Object)this);
            }
        }

        void clearDirty() {
            this.fDirty = false;
        }

        public String getName() {
            if (this.fLastName == null) {
                this.fLastName = super.getName();
            }
            if (this.fDirty) {
                return String.valueOf('<') + this.fLastName + '>';
            }
            return this.fLastName;
        }

        public ITypedElement getId() {
            ITypedElement id = super.getId();
            if (id == null) {
                return this.fLastId;
            }
            this.fLastId = id;
            return id;
        }
    }
}

