/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.editors.unified.painting;

import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IPaintPositionManager;
import org.eclipse.jface.text.IPainter;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITextViewerExtension5;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.events.PaintEvent;
import org.eclipse.swt.events.PaintListener;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;

public final class WhitespacePainter
implements IPainter,
PaintListener {
    private boolean _isActive = false;
    private ITextViewer _sourceViewer;
    private StyledText _textWidget;
    private Color _color;
    private String _spaceCharacter;
    private String _tabCharacter;
    private int _maxColorizingColumns;

    public WhitespacePainter(ITextViewer sourceViewer, String spaceChar, String tabChar, int maxColorizingColumns) {
        this._sourceViewer = sourceViewer;
        this._textWidget = sourceViewer.getTextWidget();
        this._spaceCharacter = spaceChar;
        this._tabCharacter = tabChar;
        this._maxColorizingColumns = maxColorizingColumns;
    }

    public void deactivate(boolean redraw) {
        if (this._isActive) {
            this._isActive = false;
            if (this._textWidget != null && !this._textWidget.isDisposed()) {
                this._textWidget.removePaintListener((PaintListener)this);
                if (redraw) {
                    this.handleDrawRequest(null);
                }
            }
        }
    }

    public void dispose() {
    }

    private void draw(GC gc, int offset, String whitespace) {
        Point point = this._textWidget.getLocationAtOffset(offset);
        gc.setForeground(this._color);
        gc.drawText(whitespace, point.x, point.y, true);
    }

    public void handleDrawRequest(GC gc) {
        int len;
        if (gc == null) {
            this._textWidget.redraw();
            return;
        }
        int offset = this.getInclusiveTopIndexStartOffset();
        if (offset + (len = this.getExclusiveBottomIndexEndOffset() - offset) > this._textWidget.getCharCount()) {
            len = this._textWidget.getCharCount() - offset;
        }
        try {
            int line;
            String visibleText = this._textWidget.getText(offset, offset + len - 1);
            int prevLine = line = -1;
            int i = 0;
            while (i < len) {
                block14: {
                    block13: {
                        int thisLine;
                        block12: {
                            thisLine = this._textWidget.getLineAtOffset(i);
                            if (thisLine != prevLine) break block12;
                            int column = i - this._textWidget.getOffsetAtLine(thisLine);
                            if (column < this._maxColorizingColumns) break block13;
                            break block14;
                        }
                        prevLine = thisLine;
                    }
                    char c = visibleText.charAt(i);
                    switch (c) {
                        case ' ': {
                            this.draw(gc, offset + i, this._spaceCharacter);
                            break;
                        }
                        case '\t': {
                            this.draw(gc, offset + i, this._tabCharacter);
                            break;
                        }
                        case '\r': {
                            if (i + 1 < len && visibleText.charAt(i + 1) == '\n') {
                                this.draw(gc, offset + i, "\\r\\n");
                                ++i;
                                break;
                            }
                            this.draw(gc, offset + i, "\\r");
                            break;
                        }
                        case '\n': {
                            this.draw(gc, offset + i, "\\n");
                            break;
                        }
                    }
                }
                ++i;
            }
        }
        catch (Exception exception) {
            return;
        }
    }

    private int getInclusiveTopIndexStartOffset() {
        if (this._textWidget != null && !this._textWidget.isDisposed()) {
            int top = -1;
            if (this._sourceViewer instanceof ITextViewerExtension5) {
                top = this._textWidget.getTopIndex();
                if (this._textWidget.getTopPixel() % this._textWidget.getLineHeight() != 0) {
                    --top;
                }
                ITextViewerExtension5 extension = (ITextViewerExtension5)this._sourceViewer;
                top = extension.widgetLine2ModelLine(top);
            } else {
                top = this._sourceViewer.getTopIndex();
                if (this._textWidget.getTopPixel() % this._textWidget.getLineHeight() != 0) {
                    --top;
                }
            }
            try {
                IDocument document = this._sourceViewer.getDocument();
                return document.getLineOffset(top);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    private int getExclusiveBottomIndexEndOffset() {
        if (this._textWidget != null && !this._textWidget.isDisposed()) {
            int bottom = this._sourceViewer.getBottomIndex();
            if ((this._textWidget.getTopPixel() + this._textWidget.getClientArea().height) % this._textWidget.getLineHeight() != 0) {
                ++bottom;
            }
            try {
                IDocument document = this._sourceViewer.getDocument();
                if (bottom >= document.getNumberOfLines()) {
                    bottom = document.getNumberOfLines() - 1;
                }
                return document.getLineOffset(bottom) + document.getLineLength(bottom);
            }
            catch (BadLocationException badLocationException) {}
        }
        return -1;
    }

    public void paint(int reason) {
        IDocument document = this._sourceViewer.getDocument();
        if (document == null) {
            this.deactivate(false);
            return;
        }
        if (!this._isActive) {
            this._isActive = true;
            this._textWidget.addPaintListener((PaintListener)this);
            this.handleDrawRequest(null);
        }
    }

    public void paintControl(PaintEvent event) {
        if (this._textWidget != null) {
            this.handleDrawRequest(event.gc);
        }
    }

    public void setColor(Color color) {
        this._color = color;
    }

    public void setPositionManager(IPaintPositionManager manager) {
    }
}

