/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.core.ui.wizards;

import com.aptana.ide.core.ui.wizards.Messages;
import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IProjectDescription;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IWorkspace;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.OperationCanceledException;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.operation.IRunnableWithProgress;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.osgi.util.NLS;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.DirectoryDialog;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.actions.WorkspaceModifyOperation;
import org.eclipse.ui.dialogs.IOverwriteQuery;
import org.eclipse.ui.internal.ide.IDEWorkbenchMessages;
import org.eclipse.ui.internal.ide.IDEWorkbenchPlugin;
import org.eclipse.ui.internal.wizards.datatransfer.DataTransferMessages;
import org.eclipse.ui.wizards.datatransfer.IImportStructureProvider;
import org.eclipse.ui.wizards.datatransfer.ImportOperation;
import org.eclipse.ui.wizards.newresource.BasicNewResourceWizard;

public class WizardFolderImportPage
extends WizardPage
implements IOverwriteQuery {
    private Text directoryPathField;
    private Text projectNameField;
    private String directoryPath;
    private ModifyListener modifyListener;
    private HashSet<String> projectsNames;
    private static String previouslyBrowsedDirectory = "";
    private Button browseDirectoriesButton;

    public WizardFolderImportPage() {
        this("wizardExternalProjectsPage");
    }

    public WizardFolderImportPage(String pageName) {
        super(pageName);
        this.setPageComplete(false);
        this.setTitle(Messages.WizardFolderImportPage_ExistingFolderAsNewProject);
    }

    public WizardFolderImportPage(String pageName, String title, ImageDescriptor titleImage) {
        super(pageName, title, titleImage);
    }

    public void createControl(Composite parent) {
        IProject[] projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        this.projectsNames = new HashSet();
        IProject[] iProjectArray = projects;
        int n = 0;
        int n2 = iProjectArray.length;
        while (n < n2) {
            IProject project = iProjectArray[n];
            this.projectsNames.add(project.getName());
            ++n;
        }
        this.modifyListener = new InputModifyListener();
        this.initializeDialogUnits((Control)parent);
        Composite workArea = new Composite(parent, 0);
        this.setControl((Control)workArea);
        workArea.setLayout((Layout)new GridLayout());
        workArea.setLayoutData((Object)new GridData(1808));
        this.createProjectsRoot(workArea);
        if (this.directoryPath != null) {
            this.directoryPathField.setText(this.directoryPath);
            this.setProjectName();
            this.setPageComplete(true);
        }
        Dialog.applyDialogFont((Control)workArea);
        this.setPageComplete(this.validate());
    }

    private void createProjectsRoot(Composite workArea) {
        Composite projectGroup = new Composite(workArea, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        projectGroup.setLayout((Layout)layout);
        projectGroup.setLayoutData((Object)new GridData(768));
        Label l = new Label(projectGroup, 0);
        l.setText(Messages.WizardFolderImportPage_SelectFolder);
        this.directoryPathField = new Text(projectGroup, 2048);
        this.directoryPathField.addModifyListener(this.modifyListener);
        this.directoryPathField.setLayoutData((Object)new GridData(768));
        this.browseDirectoriesButton = new Button(projectGroup, 8);
        this.browseDirectoriesButton.setText(DataTransferMessages.DataTransfer_browse);
        this.setButtonLayoutData(this.browseDirectoriesButton);
        this.browseDirectoriesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                WizardFolderImportPage.this.handleLocationDirectoryButtonPressed();
            }
        });
        l = new Label(projectGroup, 0);
        l.setText(Messages.WizardFolderImportPage_ProjectName);
        this.projectNameField = new Text(projectGroup, 2048);
        this.projectNameField.addModifyListener(this.modifyListener);
        this.projectNameField.setLayoutData((Object)new GridData(768));
    }

    protected boolean validate() {
        if (this.directoryPathField.getText().trim().length() == 0) {
            this.setErrorMessage("Please select a folder");
            return false;
        }
        if (!new File(this.directoryPathField.getText()).exists()) {
            this.setErrorMessage("The selected folder does not exist");
            return false;
        }
        String name = this.projectNameField.getText().trim();
        if (name.length() == 0) {
            this.setErrorMessage("Please provide a project name");
            return false;
        }
        if (this.projectsNames.contains(name)) {
            this.setErrorMessage("A project with this name already exists");
            return false;
        }
        this.setErrorMessage(null);
        return true;
    }

    protected void displayErrorDialog(String message) {
        MessageDialog.openError((Shell)this.getContainer().getShell(), (String)this.getErrorDialogTitle(), (String)message);
    }

    protected String getErrorDialogTitle() {
        return IDEWorkbenchMessages.WizardExportPage_internalErrorTitle;
    }

    protected void handleLocationDirectoryButtonPressed() {
        DirectoryDialog dialog = new DirectoryDialog(this.directoryPathField.getShell());
        dialog.setMessage(DataTransferMessages.WizardProjectsImportPage_SelectDialogTitle);
        String dirName = this.directoryPathField.getText().trim();
        if (dirName.length() == 0) {
            dirName = previouslyBrowsedDirectory;
        }
        if (dirName.length() == 0) {
            dialog.setFilterPath(IDEWorkbenchPlugin.getPluginWorkspace().getRoot().getLocation().toOSString());
        } else {
            File path = new File(dirName);
            if (path.exists()) {
                dialog.setFilterPath(new Path(dirName).toOSString());
            }
        }
        String selectedDirectory = dialog.open();
        if (selectedDirectory != null) {
            previouslyBrowsedDirectory = selectedDirectory;
            this.directoryPathField.setText(previouslyBrowsedDirectory);
        }
        this.setProjectName();
        this.setPageComplete(this.directoryPathField.getText() != null);
    }

    private void setProjectName() {
        Path path;
        if (this.directoryPathField.getText() != null && (path = new Path(this.directoryPathField.getText())).segmentCount() > 0) {
            this.projectNameField.setText(path.lastSegment());
        }
    }

    public IProject createProject() {
        String projectPath = this.directoryPathField.getText();
        File project = new File(projectPath);
        if (project.exists()) {
            ProjectRecord pr = new ProjectRecord(project, this.projectNameField.getText());
            return this.createExistingProject(pr);
        }
        return null;
    }

    public boolean createProjects() {
        return this.createProject() != null;
    }

    private IProject createExistingProject(final ProjectRecord record) {
        String projectName = record.getProjectName();
        IWorkspace workspace = ResourcesPlugin.getWorkspace();
        final IProject project = workspace.getRoot().getProject(projectName);
        if (record.description == null) {
            record.description = workspace.newProjectDescription(projectName);
            Path locationPath = new Path(record.projectSystemFile.getAbsolutePath());
            if (Platform.getLocation().isPrefixOf((IPath)locationPath)) {
                record.description.setLocation(null);
            } else {
                record.description.setLocation((IPath)locationPath);
            }
        } else {
            record.description.setName(projectName);
        }
        WorkspaceModifyOperation op = new WorkspaceModifyOperation(){

            protected void execute(IProgressMonitor monitor) throws CoreException {
                monitor.beginTask("", 2000);
                project.create(record.description, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
                if (monitor.isCanceled()) {
                    throw new OperationCanceledException();
                }
                project.open(128, (IProgressMonitor)new SubProgressMonitor(monitor, 1000));
            }
        };
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        catch (InvocationTargetException e) {
            Throwable t = e.getTargetException();
            if (((CoreException)t).getStatus().getCode() == 275) {
                MessageDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, (String)NLS.bind((String)DataTransferMessages.WizardExternalProjectImportPage_caseVariantExistsError, (Object)record.description.getName()));
            } else {
                ErrorDialog.openError((Shell)this.getShell(), (String)DataTransferMessages.WizardExternalProjectImportPage_errorMessage, (String)((CoreException)t).getLocalizedMessage(), (IStatus)((CoreException)t).getStatus());
            }
            return null;
        }
        try {
            WizardFolderImportPage.showView("com.aptana.ide.core.ui.AptanaNavigator", PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
        catch (PartInitException partInitException) {}
        BasicNewResourceWizard.selectAndReveal((IResource)project, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        return project;
    }

    protected boolean getFilesForProject(Collection files, IImportStructureProvider provider, Object entry) {
        List children = provider.getChildren(entry);
        for (Object child : children) {
            files.add(child);
            if (!provider.isFolder(child)) continue;
            this.getFilesForProject(files, provider, child);
        }
        return true;
    }

    protected boolean executeImportOperation(ImportOperation op) {
        try {
            this.getContainer().run(true, true, (IRunnableWithProgress)op);
        }
        catch (InterruptedException interruptedException) {
            return false;
        }
        catch (InvocationTargetException invocationTargetException) {
            return false;
        }
        IStatus status = op.getStatus();
        if (!status.isOK()) {
            ErrorDialog.openError((Shell)this.getContainer().getShell(), (String)DataTransferMessages.FileImport_importProblems, null, (IStatus)status);
            return false;
        }
        return true;
    }

    public String queryOverwrite(String pathString) {
        Path path = new Path(pathString);
        String messageString = path.getFileExtension() == null || path.segmentCount() < 2 ? NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_existsQuestion, (Object)pathString) : NLS.bind((String)IDEWorkbenchMessages.WizardDataTransfer_overwriteNameAndPathQuestion, (Object)path.lastSegment(), (Object)path.removeLastSegments(1).toOSString());
        final MessageDialog dialog = new MessageDialog(this.getContainer().getShell(), IDEWorkbenchMessages.Question, null, messageString, 3, new String[]{IDialogConstants.YES_LABEL, IDialogConstants.YES_TO_ALL_LABEL, IDialogConstants.NO_LABEL, IDialogConstants.NO_TO_ALL_LABEL, IDialogConstants.CANCEL_LABEL}, 0);
        String[] response = new String[]{"YES", "ALL", "NO", "NOALL", "CANCEL"};
        this.getControl().getDisplay().syncExec(new Runnable(){

            public void run() {
                dialog.open();
            }
        });
        return dialog.getReturnCode() < 0 ? "CANCEL" : response[dialog.getReturnCode()];
    }

    public String getDirectoryPath() {
        return this.directoryPath;
    }

    public void setDirectoryPath(String directoryPath) {
        this.directoryPath = directoryPath;
        if (this.directoryPathField != null) {
            this.directoryPathField.setText(directoryPath);
            this.setProjectName();
            this.setPageComplete(true);
        }
    }

    public static IViewPart showView(String viewId, IWorkbenchWindow window) throws PartInitException {
        IWorkbenchPage page = window.getActivePage();
        if (page != null) {
            return page.showView(viewId);
        }
        return null;
    }

    private static class ProjectRecord {
        File projectSystemFile;
        Object projectArchiveFile;
        String projectName;
        Object parent;
        int level;
        IProjectDescription description;

        ProjectRecord(File file, String name) {
            this.projectSystemFile = file;
            this.setProjectName(name);
        }

        private void setProjectName(String name) {
            this.projectName = name;
        }

        public String getProjectName() {
            return this.projectName;
        }
    }

    private class InputModifyListener
    implements ModifyListener {
        private InputModifyListener() {
        }

        public void modifyText(ModifyEvent e) {
            WizardFolderImportPage.this.setPageComplete(WizardFolderImportPage.this.validate());
        }
    }
}

