/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh.impl;

import com.aptana.ide.ssh.Activator;
import com.aptana.ide.ssh.impl.Utilities;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Arrays;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.console.ConsolePlugin;
import org.eclipse.ui.console.IConsole;
import org.eclipse.ui.console.MessageConsole;
import org.eclipse.ui.console.MessageConsoleStream;
import org.eclipse.ui.progress.UIJob;

public class CommandLauncher {
    private static MessageConsole messageConsole;
    private static boolean firstTime;

    static {
        firstTime = true;
    }

    public static void launch(final String command) {
        new Thread(new Runnable(){

            public void run() {
                Activator activator = Activator.getDefault();
                String[] commandArray = Utilities.parseParameters(command);
                try {
                    final Process process = Runtime.getRuntime().exec(commandArray);
                    final MessageConsole messageConsole = CommandLauncher.getMessageConsole();
                    MessageConsoleStream newMessageStream = messageConsole.newMessageStream();
                    if (firstTime) {
                        firstTime = false;
                    } else {
                        newMessageStream.println();
                        newMessageStream.println();
                        newMessageStream.println();
                    }
                    messageConsole.newMessageStream().println(command);
                    UIJob uiJob = new UIJob(""){

                        public IStatus runInUIThread(IProgressMonitor monitor) {
                            IWorkbenchPage activePage;
                            IWorkbenchWindow activeWorkbenchWindow = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
                            if (activeWorkbenchWindow != null && (activePage = activeWorkbenchWindow.getActivePage()) != null) {
                                new Thread(new MessageConsoleWriter(messageConsole, process.getInputStream())).start();
                                new Thread(new MessageConsoleWriter(messageConsole, process.getErrorStream(), Display.getCurrent().getSystemColor(3))).start();
                            }
                            return Status.OK_STATUS;
                        }
                    };
                    uiJob.schedule();
                    int status = process.waitFor();
                    if (status != 0) {
                        activator.getLog().log((IStatus)new Status(4, activator.getBundle().getSymbolicName(), 0, "Process '" + Arrays.asList(commandArray).toString() + "' exited with status: " + status, null));
                    }
                }
                catch (InterruptedException ex) {
                    activator.getLog().log((IStatus)new Status(4, activator.getBundle().getSymbolicName(), 0, "Exception while executing '" + Arrays.asList(commandArray).toString() + "'", (Throwable)ex));
                }
                catch (IOException ioe) {
                    activator.getLog().log((IStatus)new Status(4, activator.getBundle().getSymbolicName(), 0, "Exception while executing '" + Arrays.asList(commandArray).toString() + "'", (Throwable)ioe));
                }
            }
        }, "Launching - " + command).start();
    }

    private static MessageConsole getMessageConsole() {
        if (messageConsole == null) {
            messageConsole = new MessageConsole("SSH Launcher Console", null);
            ConsolePlugin.getDefault().getConsoleManager().addConsoles(new IConsole[]{messageConsole});
        }
        return messageConsole;
    }

    private static class MessageConsoleWriter
    implements Runnable {
        private final MessageConsole messageConsole;
        private final InputStream from;
        private final Color color;

        private MessageConsoleWriter(MessageConsole messageConsole, InputStream from) {
            this(messageConsole, from, (Color)null);
        }

        private MessageConsoleWriter(MessageConsole messageConsole, InputStream from, Color color) {
            this.messageConsole = messageConsole;
            this.from = from;
            this.color = color;
        }

        public void run() {
            block20: {
                BufferedReader reader;
                MessageConsoleStream messageConsoleStream;
                block19: {
                    messageConsoleStream = this.messageConsole.newMessageStream();
                    if (this.color != null) {
                        Display.getDefault().asyncExec(new Runnable(){

                            public void run() {
                                messageConsoleStream.setColor(MessageConsoleWriter.this.color);
                            }
                        });
                    }
                    reader = new BufferedReader(new InputStreamReader(this.from));
                    String output = null;
                    try {
                        try {
                            while ((output = reader.readLine()) != null) {
                                messageConsoleStream.println(output);
                            }
                        }
                        catch (IOException iOException) {
                            break block19;
                        }
                    }
                    catch (Throwable throwable) {
                        try {
                            reader.close();
                        }
                        catch (IOException iOException) {}
                        try {
                            messageConsoleStream.close();
                        }
                        catch (IOException iOException) {}
                        throw throwable;
                    }
                    try {
                        reader.close();
                    }
                    catch (IOException iOException) {}
                    try {
                        messageConsoleStream.close();
                    }
                    catch (IOException iOException) {}
                    break block20;
                }
                try {
                    reader.close();
                }
                catch (IOException iOException) {}
                try {
                    messageConsoleStream.close();
                }
                catch (IOException iOException) {}
            }
        }
    }
}

