/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh.cloud;

import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.server.cloud.services.model.Site;
import com.aptana.ide.server.cloud.services.model.studio.CloudModel;
import com.aptana.ide.server.jetty.comet.CometClient;
import com.aptana.ide.ssh.Activator;
import java.util.HashMap;
import java.util.Map;

public class CloudSSHClient
extends CometClient {
    public static final String CLOUD_SSH_CHANNEL = "/portal/cloud/ssh";
    public static final String SSH = "ssh";

    protected Object getResponse(String toChannel, Object request) {
        if (CLOUD_SSH_CHANNEL.equals(toChannel)) {
            Map requestData;
            HashMap<String, String> responseData = new HashMap<String, String>();
            if (request instanceof Map && SSH.equals((requestData = (Map)request).get("request")) && requestData.containsKey("id")) {
                Site site;
                String siteId = requestData.get("id").toString();
                if (CloudModel.getModel().getUser().hasCredentials() && (site = (Site)CloudModel.getModel().getUser().getSites().getItem(siteId)) != null) {
                    User signedInUser = AptanaUser.getSignedInUser();
                    if (!signedInUser.hasCredentials()) {
                        return null;
                    }
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("user", signedInUser.getUsername());
                    parameters.put("host", site.getPrimaryDomainName());
                    parameters.put("user@host", String.valueOf(signedInUser.getUsername()) + "@" + site.getPrimaryDomainName());
                    Activator.getDefault().getSSHLauncher().launchSSH(parameters);
                    responseData.put("id", siteId);
                }
            }
            return responseData;
        }
        return null;
    }

    protected String getID(String msgId) {
        return Long.toString(System.currentTimeMillis());
    }

    protected String[] getSubscriptionIDs() {
        return new String[]{CLOUD_SSH_CHANNEL};
    }
}

