/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh.actions;

import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.server.cloud.services.model.studio.SiteUtils;
import com.aptana.ide.server.cloud.services.model.studio.StudioSite;
import com.aptana.ide.ssh.Activator;
import java.util.HashMap;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class SSHAction
implements IViewActionDelegate {
    private IProject project;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.project == null) {
            return;
        }
        StudioSite site = SiteUtils.getSite((IProject)this.project);
        if (site == null) {
            return;
        }
        User signedInUser = AptanaUser.getSignedInUser();
        if (!signedInUser.hasCredentials()) {
            return;
        }
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("user", signedInUser.getUsername());
        parameters.put("host", site.getPrimaryDomainName());
        parameters.put("user@host", String.valueOf(signedInUser.getUsername()) + "@" + site.getPrimaryDomainName());
        Activator.getDefault().getSSHLauncher().launchSSH(parameters);
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IProject project;
        this.project = null;
        action.setEnabled(false);
        Object obj = this.getValidSingleSelection(selection);
        if (obj != null && obj instanceof IResource && (project = ((IResource)obj).getProject()) != null) {
            if (SiteUtils.getSite((IProject)project) != null) {
                this.project = project;
                action.setEnabled(true);
            }
            return;
        }
    }

    protected Object getValidSingleSelection(ISelection selection) {
        if (!(selection instanceof IStructuredSelection)) {
            return null;
        }
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        if (structuredSelection.size() > 1) {
            return null;
        }
        return structuredSelection.getFirstElement();
    }
}

