/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh.actions;

import com.aptana.ide.core.io.IVirtualFileManager;
import com.aptana.ide.core.model.user.AptanaUser;
import com.aptana.ide.core.model.user.User;
import com.aptana.ide.server.cloud.syncing.CloudProtocolManager;
import com.aptana.ide.server.cloud.syncing.CloudVirtualFileManager;
import com.aptana.ide.ssh.Activator;
import java.util.HashMap;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

public class FileExplorerViewSSHAction
implements IViewActionDelegate {
    private CloudVirtualFileManager cloudVirtualFileManager;
    private CloudProtocolManager cloudProtocolManager;

    public void init(IViewPart view) {
    }

    public void run(IAction action) {
        if (this.cloudVirtualFileManager == null && this.cloudProtocolManager == null) {
            return;
        }
        User signedInUser = AptanaUser.getSignedInUser();
        if (!signedInUser.hasCredentials()) {
            return;
        }
        if (this.cloudVirtualFileManager != null) {
            HashMap<String, String> parameters = new HashMap<String, String>();
            parameters.put("user", signedInUser.getUsername());
            parameters.put("host", this.cloudVirtualFileManager.getServer());
            parameters.put("user@host", String.valueOf(signedInUser.getUsername()) + "@" + this.cloudVirtualFileManager.getServer());
            Activator.getDefault().getSSHLauncher().launchSSH(parameters);
            return;
        }
        if (this.cloudProtocolManager != null) {
            IVirtualFileManager[] fileManagers;
            IVirtualFileManager[] iVirtualFileManagerArray = fileManagers = this.cloudProtocolManager.getFileManagers();
            int n = 0;
            int n2 = iVirtualFileManagerArray.length;
            while (n < n2) {
                IVirtualFileManager virtualFileManager = iVirtualFileManagerArray[n];
                if (virtualFileManager instanceof CloudVirtualFileManager) {
                    CloudVirtualFileManager childCloudVirtualFileManager = (CloudVirtualFileManager)virtualFileManager;
                    HashMap<String, String> parameters = new HashMap<String, String>();
                    parameters.put("user", signedInUser.getUsername());
                    parameters.put("host", childCloudVirtualFileManager.getServer());
                    parameters.put("user@host", String.valueOf(signedInUser.getUsername()) + "@" + childCloudVirtualFileManager.getServer());
                    Activator.getDefault().getSSHLauncher().launchSSH(parameters);
                    break;
                }
                ++n;
            }
        }
    }

    public void selectionChanged(IAction action, ISelection selection) {
        IStructuredSelection structuredSelection;
        this.cloudVirtualFileManager = null;
        this.cloudProtocolManager = null;
        action.setEnabled(false);
        if (selection instanceof IStructuredSelection && (structuredSelection = (IStructuredSelection)selection).size() == 1) {
            Object firstElement = structuredSelection.getFirstElement();
            if (firstElement instanceof CloudVirtualFileManager) {
                this.cloudVirtualFileManager = (CloudVirtualFileManager)firstElement;
                action.setEnabled(true);
                return;
            }
            if (firstElement instanceof CloudProtocolManager) {
                this.cloudProtocolManager = (CloudProtocolManager)firstElement;
                action.setEnabled(true);
                return;
            }
        }
    }
}

