/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.ssh;

import com.aptana.ide.ssh.impl.SSHLauncher;
import com.aptana.ide.ssh.impl.preferences.SSHPreferences;
import com.aptana.ide.ssh.spi.ISSHLauncher;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.FileLocator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.Bundle;
import org.osgi.framework.BundleContext;

public class Activator
extends AbstractUIPlugin {
    public static final String PLUGIN_ID = "SSH";
    private static Activator plugin;
    private ISSHLauncher sshLauncher;
    private static String terminalDotScpt;
    private static String putty;

    static {
        putty = "putty.exe";
    }

    public void start(BundleContext context) throws Exception {
        Bundle[] bundles;
        super.start(context);
        plugin = this;
        try {
            URL entry = context.getBundle().getEntry("/scripts/terminal.scpt");
            if (entry != null) {
                terminalDotScpt = FileLocator.toFileURL((URL)entry).getFile();
            }
        }
        catch (IOException iOException) {}
        Bundle[] bundleArray = bundles = context.getBundles();
        int n = 0;
        int n2 = bundleArray.length;
        while (n < n2) {
            Bundle bundle = bundleArray[n];
            if (bundle.getSymbolicName().equals("com.aptana.ide.libraries")) {
                try {
                    URL entry = bundle.getEntry("/win32/putty.exe");
                    if (entry == null) break;
                    putty = FileLocator.toFileURL((URL)entry).getFile().substring(1);
                }
                catch (IOException iOException) {}
                break;
            }
            ++n;
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
    }

    public static Activator getDefault() {
        return plugin;
    }

    protected void initializeDefaultPreferences(IPreferenceStore store) {
        super.initializeDefaultPreferences(store);
        SSHPreferences.initializeDefaultPreferences(store);
    }

    public String getTerminalDotScpt() {
        return terminalDotScpt;
    }

    public String getPuttyDotExe() {
        return putty;
    }

    public ISSHLauncher getSSHLauncher() {
        if (this.sshLauncher == null) {
            this.sshLauncher = new SSHLauncher();
        }
        return this.sshLauncher;
    }
}

