/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.snippets;

import com.aptana.ide.core.ui.PreferenceUtils;
import com.aptana.ide.core.ui.WorkbenchHelper;
import com.aptana.ide.snippets.Messages;
import com.aptana.ide.snippets.Snippet;
import com.aptana.ide.snippets.SnippetListChangeListener;
import com.aptana.ide.snippets.SnippetsManager;
import com.aptana.ide.snippets.SnippetsPlugin;
import com.aptana.ide.snippets.SnippetsStartup;
import com.aptana.ide.snippets.SnippetsViewContentProvider;
import com.aptana.ide.snippets.SnippetsViewLabelProvider;
import java.io.File;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.Separator;
import org.eclipse.jface.viewers.DoubleClickEvent;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IDoubleClickListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.custom.StackLayout;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Text;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.IEditorPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.part.DrillDownAdapter;
import org.eclipse.ui.part.ViewPart;
import org.eclipse.ui.texteditor.ITextEditor;

public class SnippetsView
extends ViewPart
implements SnippetListChangeListener {
    private StackLayout _layout;
    private TreeViewer _viewer;
    private String _textPattern = "";
    private Action _applyAction;
    private Action _doubleClickAction;
    private Action _editAction;
    private Action _toggleAction;
    private Action collapseAllAction;
    private DrillDownAdapter drillDown;
    private SnippetsViewLabelProvider snippetsViewLabelProvider;
    private SnippetsViewContentProvider snippetsViewContentProvider;

    private void applySnippet(Snippet snippet) {
        IEditorPart activeEditor = this.getActiveEditor();
        if (activeEditor != null && activeEditor instanceof ITextEditor) {
            ITextEditor editor = (ITextEditor)activeEditor;
            snippet.apply(editor);
        }
    }

    private void createActions() {
        this.createApplyAction();
        this.createDoubleClickAction();
        this.createEditAction();
        this.createToggleAction();
        this.createCollapseAllAction();
        this.drillDown = new DrillDownAdapter(this._viewer);
        this._viewer.addDoubleClickListener(new IDoubleClickListener(){

            public void doubleClick(DoubleClickEvent event) {
                SnippetsView.this._doubleClickAction.run();
            }
        });
    }

    private void createCollapseAllAction() {
        this.collapseAllAction = new Action(Messages.SnippetsView_CollapseAll){

            public void run() {
                if (SnippetsView.this._viewer != null) {
                    SnippetsView.this._viewer.collapseAll();
                }
            }
        };
        this.collapseAllAction.setToolTipText(Messages.SnippetsView_CollapseAll);
        this.collapseAllAction.setImageDescriptor(SnippetsPlugin.getImageDescriptor("icons/collapseall.gif"));
    }

    private void createApplyAction() {
        this._applyAction = new Action(){

            public void run() {
                ISelection selection = SnippetsView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof Snippet) {
                    SnippetsView.this.applySnippet((Snippet)firstElement);
                }
            }
        };
        this._applyAction.setText(Messages.SnippetsView_Apply_Snippet);
    }

    private void createDoubleClickAction() {
        this._doubleClickAction = new Action(){

            public void run() {
                ISelection selection = SnippetsView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof String) {
                    SnippetsView.this.toggleElementState(firstElement);
                } else if (firstElement instanceof Snippet) {
                    SnippetsView.this.applySnippet((Snippet)firstElement);
                }
            }
        };
    }

    private void createEditAction() {
        this._editAction = new Action(){

            public void run() {
                ISelection selection = SnippetsView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof Snippet) {
                    SnippetsView.this.editSnippet((Snippet)firstElement);
                }
            }
        };
        this._editAction.setText(Messages.SnippetsView_Edit_Snippet);
    }

    public void createPartControl(Composite parent) {
        this._layout = new StackLayout();
        parent.setLayout((Layout)this._layout);
        Composite body = new Composite(parent, 0);
        GridLayout gridLayout = new GridLayout();
        gridLayout.verticalSpacing = 0;
        gridLayout.marginWidth = 0;
        gridLayout.marginHeight = 0;
        body.setLayout((Layout)gridLayout);
        Composite head = new Composite(body, 0);
        this._viewer = this.createTreeViewer(body);
        GridLayout gridLayout2 = new GridLayout(2, false);
        gridLayout2.marginHeight = 5;
        gridLayout2.verticalSpacing = 0;
        head.setLayout((Layout)gridLayout2);
        Label l = new Label(head, 0);
        l.setText(Messages.SnippetsView_Filter);
        final Text txt = new Text(head, 2048);
        txt.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                SnippetsView.this._textPattern = txt.getText();
                SnippetsView.this._viewer.getControl().setRedraw(false);
                SnippetsView.this._viewer.refresh();
                SnippetsView.this._viewer.getControl().setRedraw(true);
            }
        });
        this._viewer.addFilter(new ViewerFilter(){
            private int k = 0;

            public boolean select(Viewer viewer, Object parentElement, Object element) {
                if (SnippetsView.this.snippetsViewLabelProvider.getText(element).contains(SnippetsView.this._textPattern)) {
                    return true;
                }
                Object[] children = SnippetsView.this.snippetsViewContentProvider.getChildren(element);
                int a = 0;
                while (a < children.length) {
                    if (this.select(viewer, element, children[a])) {
                        if (this.k <= 4) {
                            ++this.k;
                            SnippetsView.this._viewer.expandToLevel(element, 2);
                            --this.k;
                        }
                        return true;
                    }
                    ++a;
                }
                return false;
            }
        });
        txt.setLayoutData((Object)new GridData(768));
        head.setLayoutData((Object)new GridData(768));
        this._layout.topControl = body;
        this._viewer.getControl().setLayoutData((Object)new GridData(1808));
        this.createActions();
        this.hookContextMenu();
        this.hookToolbarActions();
        SnippetsStartup.init();
        PreferenceUtils.registerBackgroundColorPreference((Control)this._viewer.getControl(), (String)"com.aptana.ide.core.ui.background.color.snippetsView");
        PreferenceUtils.registerForegroundColorPreference((Control)this._viewer.getControl(), (String)"com.aptana.ide.core.ui.foreground.color.snippetsView");
        SnippetsManager snippets = SnippetsManager.getInstance();
        this._viewer.setInput((Object)snippets);
        snippets.addChangeListener(this);
    }

    private void hookToolbarActions() {
        IActionBars bars = this.getViewSite().getActionBars();
        IToolBarManager manager = bars.getToolBarManager();
        this.drillDown.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator());
        manager.add((IAction)this.collapseAllAction);
    }

    public void dispose() {
        super.dispose();
        SnippetsManager snippets = SnippetsManager.getInstance();
        snippets.removeChangeListener(this);
    }

    private void createToggleAction() {
        this._toggleAction = new Action(){

            public void run() {
                ISelection selection = SnippetsView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                if (firstElement instanceof String) {
                    SnippetsView.this.toggleElementState(firstElement);
                }
            }
        };
        this._toggleAction.setText(Messages.SnippetsView_Expand_Collapse_Category);
    }

    private TreeViewer createTreeViewer(Composite parent) {
        Tree tree = new Tree(parent, 772);
        TreeViewer viewer = new TreeViewer(tree);
        this.snippetsViewContentProvider = new SnippetsViewContentProvider();
        viewer.setContentProvider((IContentProvider)this.snippetsViewContentProvider);
        this.snippetsViewLabelProvider = new SnippetsViewLabelProvider();
        viewer.setLabelProvider((IBaseLabelProvider)this.snippetsViewLabelProvider);
        return viewer;
    }

    private void editSnippet(Snippet snippet) {
        File file = snippet.getFile();
        if (file != null) {
            WorkbenchHelper.openFile((File)file, (IWorkbenchWindow)PlatformUI.getWorkbench().getActiveWorkbenchWindow());
        }
    }

    private void fillContextMenu(IMenuManager manager, Object element) {
        if (element instanceof SnippetsManager.SnippetNode) {
            manager.add((IAction)this._toggleAction);
        } else if (element instanceof Snippet) {
            manager.add((IAction)this._applyAction);
            manager.add((IAction)this._editAction);
        }
        this.drillDown.addNavigationActions(manager);
        manager.add((IContributionItem)new Separator("additions"));
    }

    private IEditorPart getActiveEditor() {
        final IWorkbench workbench = PlatformUI.getWorkbench();
        class ActiveEditorRef {
            public IEditorPart activeEditor;

            ActiveEditorRef() {
            }
        }
        final ActiveEditorRef activeEditor = new ActiveEditorRef();
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){
            {
            }

            public void run() {
                IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
                if (window != null && window.getActivePage() != null) {
                    activeEditor.activeEditor = window.getActivePage().getActiveEditor();
                }
            }
        });
        IEditorPart result = activeEditor.activeEditor;
        return result;
    }

    private void hookContextMenu() {
        MenuManager menuMgr = new MenuManager("#PopupMenu");
        menuMgr.setRemoveAllWhenShown(true);
        menuMgr.addMenuListener(new IMenuListener(){

            public void menuAboutToShow(IMenuManager manager) {
                ISelection selection = SnippetsView.this._viewer.getSelection();
                Object firstElement = ((IStructuredSelection)selection).getFirstElement();
                SnippetsView.this.fillContextMenu(manager, firstElement);
            }
        });
        Menu menu = menuMgr.createContextMenu(this._viewer.getControl());
        this._viewer.getControl().setMenu(menu);
        this.getSite().registerContextMenu(menuMgr, (ISelectionProvider)this._viewer);
    }

    public void listChanged(final SnippetsManager list) {
        IWorkbench workbench = PlatformUI.getWorkbench();
        Display display = workbench.getDisplay();
        display.syncExec(new Runnable(){

            public void run() {
                if (!SnippetsView.this._viewer.getTree().isDisposed() && SnippetsView.this._viewer.getContentProvider() != null) {
                    SnippetsView.this._viewer.setInput((Object)list);
                }
            }
        });
    }

    public void setFocus() {
    }

    private void toggleElementState(Object element) {
        boolean state = this._viewer.getExpandedState(element);
        if (state) {
            this._viewer.setExpandedState(element, false);
        } else {
            this._viewer.setExpandedState(element, true);
        }
    }
}

