/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.snippets;

import com.aptana.ide.core.ui.SWTUtils;
import com.aptana.ide.snippets.Messages;
import com.aptana.ide.snippets.Snippet;
import com.aptana.ide.snippets.SnippetVariable;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.util.Geometry;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Monitor;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class SnippetDialog
extends Dialog {
    public boolean OK;
    private Text[] textFields;
    private SnippetVariable[] _variables;
    private Snippet snippet;

    protected SnippetDialog(Shell parentShell, Snippet snippet) {
        super(parentShell);
        this.setShellStyle(this.getShellStyle() | 0x10);
        this.snippet = snippet;
    }

    private void createContents(Shell shell) {
        Group group = new Group((Composite)shell, 4);
        group.setText(Messages.SnippetDialog_Variable_Group_Header);
        GridLayout groupLayout = new GridLayout();
        groupLayout.numColumns = 2;
        group.setLayout((Layout)groupLayout);
        GridData groupLayoutData = new GridData(768);
        groupLayoutData.grabExcessHorizontalSpace = true;
        group.setLayoutData((Object)groupLayoutData);
        this.textFields = new Text[this._variables.length];
        int i = 0;
        while (i < this._variables.length) {
            SnippetVariable variable = this._variables[i];
            String name = variable.getName();
            String tooltip = variable.getDescription();
            Label description = new Label((Composite)group, 16384);
            description.setText(tooltip);
            description.setFont(new Font((Device)Display.getDefault(), SWTUtils.resizeFont((Font)description.getFont(), (int)-3)));
            GridData textLayoutData = new GridData(768);
            textLayoutData.minimumWidth = 120;
            textLayoutData.horizontalSpan = 2;
            description.setLayoutData((Object)textLayoutData);
            Label label = new Label((Composite)group, 131072);
            label.setText(name);
            Text text = new Text((Composite)group, 2052);
            text.setText("");
            text.setToolTipText(tooltip);
            textLayoutData = new GridData(768);
            textLayoutData.minimumWidth = 120;
            text.setLayoutData((Object)textLayoutData);
            this.textFields[i] = text;
            ++i;
        }
    }

    public void okPressed() {
        int i = 0;
        while (i < this._variables.length) {
            this._variables[i].setValue(this.textFields[i].getText());
            ++i;
        }
        this.OK = true;
        super.okPressed();
    }

    protected Control createContents(Composite parent) {
        this._variables = this.snippet.getVariables();
        Shell shell = this.getShell();
        int width = 230;
        int height = 240;
        shell.setText(this.snippet.getName());
        Point centerPoint = null;
        Rectangle bounds = parent.getBounds();
        Monitor monitor = parent.getMonitor();
        Rectangle monitorBounds = monitor.getClientArea();
        centerPoint = Geometry.centerPoint((Rectangle)bounds);
        centerPoint = new Point(centerPoint.x - width / 2, Math.max(monitorBounds.y, Math.min(centerPoint.y - height * 2 / 3, monitorBounds.y + monitorBounds.height - height)));
        shell.setBounds(centerPoint.x, centerPoint.y, width, height);
        shell.setMinimumSize(width, height);
        GridLayout windowLayout = new GridLayout();
        windowLayout.numColumns = 1;
        windowLayout.marginHeight = 5;
        windowLayout.marginWidth = 5;
        shell.setLayout((Layout)windowLayout);
        this.createContents(shell);
        shell.pack(true);
        return super.createContents(parent);
    }
}

