/*
 * Decompiled with CFR 0.152.
 */
package com.aptana.ide.snippets;

import com.aptana.ide.core.FileUtils;
import com.aptana.ide.editors.unified.IUnifiedEditor;
import com.aptana.ide.snippets.SnippetDialog;
import com.aptana.ide.snippets.SnippetVariable;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.ITextSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.texteditor.IDocumentProvider;
import org.eclipse.ui.texteditor.ITextEditor;

public class Snippet {
    private static final Pattern MULTILINE_COMMENT_PATTERN = Pattern.compile("^/\\*(.*?)\\*/\\s*", 32);
    private static final Pattern XML_COMMENT_PATTERN = Pattern.compile("^<!--(.*?)-->\\s*", 32);
    private static final Pattern KEY_VALUE_PATTERN = Pattern.compile("((?:\\w|[-()])+)\\s*:\\s*(.*)$", 8);
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{((?:\\w|-)+)\\}");
    private static final String CATEGORY_KEY = "category";
    private static final String ICON_KEY = "icon";
    private static final String TOOLBAR_KEY = "toolbar";
    private static final String TOOLTIP_KEY = "tooltip";
    private static final String LANGUAGE_KEY = "language";
    private static final String NAME_KEY = "name";
    private static final String PROMPT_START = "prompt(";
    private static final String PROMPT_END = ")";
    private Map<String, String> _metadata = new HashMap<String, String>();
    private List<SnippetVariable> _prompts;
    private File _file;
    private String _content;

    public String getIcon() {
        return this._metadata.get(ICON_KEY);
    }

    public String getLanguage() {
        return this._metadata.get(LANGUAGE_KEY);
    }

    public boolean isToolbar() {
        String string = this._metadata.get(TOOLBAR_KEY);
        if (string != null) {
            return Boolean.parseBoolean(string);
        }
        return false;
    }

    public Snippet(String category, String name, String content) {
        this();
        this.setValue(CATEGORY_KEY, category);
        this.setValue(NAME_KEY, name);
        this._content = content;
    }

    private void setValue(String key, String value) {
        if (key.startsWith(PROMPT_START) && key.endsWith(PROMPT_END)) {
            String name = key.substring(PROMPT_START.length(), key.length() - PROMPT_END.length());
            if (this._prompts == null) {
                this._prompts = new ArrayList<SnippetVariable>();
            }
            this._prompts.add(new SnippetVariable(name, "", value));
        } else {
            this._metadata.put(key, value);
        }
    }

    private Snippet() {
    }

    public static Snippet fromString(String text) {
        Snippet result = null;
        if (text != null) {
            Matcher m = MULTILINE_COMMENT_PATTERN.matcher(text);
            String metadata = null;
            String content = null;
            if (m.find()) {
                metadata = m.group(1);
                content = text.substring(m.end());
            } else {
                m = XML_COMMENT_PATTERN.matcher(text);
                if (m.find()) {
                    metadata = m.group(1);
                    content = text.substring(m.end());
                }
            }
            if (metadata != null) {
                Snippet candidate = new Snippet();
                m = KEY_VALUE_PATTERN.matcher(metadata);
                while (m.find()) {
                    candidate.setValue(m.group(1).toLowerCase(Locale.getDefault()), m.group(2));
                }
                candidate._content = content;
                if (candidate.isValid()) {
                    result = candidate;
                }
            }
        }
        return result;
    }

    public static Snippet fromFile(File file) {
        String text = null;
        try {
            text = FileUtils.readContent((File)file);
        }
        catch (IOException iOException) {}
        Snippet result = Snippet.fromString(text);
        if (result != null) {
            result._file = file;
        }
        return result;
    }

    public String getCategory() {
        return this._metadata.get(CATEGORY_KEY);
    }

    public String getRawContent() {
        return this._content;
    }

    public String getExpandedContent(String selectedText) {
        return this.getExpandedContent(selectedText, new IntegerHolder());
    }

    public String getExpandedContent(String selectedText, IntegerHolder cursorPosition) {
        boolean expand = true;
        String result = null;
        HashMap<String, String> valuesByName = new HashMap<String, String>();
        valuesByName.put("selection", selectedText);
        valuesByName.put("cursor", "\u0002");
        if (this._prompts != null && this._prompts.size() > 0) {
            SnippetDialog dialog = new SnippetDialog(Display.getCurrent().getActiveShell(), this);
            dialog.open();
            if (dialog.OK) {
                int i = 0;
                while (i < this._prompts.size()) {
                    SnippetVariable variable = this._prompts.get(i);
                    valuesByName.put(variable.getName(), variable.getValue());
                    ++i;
                }
            } else {
                expand = false;
            }
        }
        if (expand) {
            StringBuffer buffer = new StringBuffer();
            Matcher m = VARIABLE_PATTERN.matcher(this._content);
            while (m.find()) {
                String key = m.group(1);
                String replacement = "";
                if (valuesByName.containsKey(key)) {
                    replacement = (String)valuesByName.get(key);
                }
                String quotedReplacement = Matcher.quoteReplacement(replacement);
                m.appendReplacement(buffer, quotedReplacement);
            }
            m.appendTail(buffer);
            result = buffer.toString();
            int indexOf = result.indexOf(2);
            if (indexOf != -1) {
                cursorPosition.cursorPosition = indexOf;
                result = String.valueOf(result.substring(0, indexOf)) + result.substring(indexOf + 1);
            }
        }
        return result;
    }

    public File getFile() {
        return this._file;
    }

    public String getName() {
        return this._metadata.get(NAME_KEY);
    }

    public SnippetVariable[] getVariables() {
        SnippetVariable[] result = this._prompts != null ? this._prompts.toArray(new SnippetVariable[this._prompts.size()]) : new SnippetVariable[]{};
        return result;
    }

    private boolean isValid() {
        return this.hasKey(CATEGORY_KEY) && this.hasKey(NAME_KEY) && this._content != null;
    }

    private boolean hasKey(String key) {
        return this._metadata.containsKey(key);
    }

    void apply(final ITextEditor editor) {
        ITextSelection ts = (ITextSelection)editor.getSelectionProvider().getSelection();
        final int selectionOffset = ts.getOffset();
        int selectionLength = ts.getLength();
        IDocumentProvider dp = editor.getDocumentProvider();
        IDocument doc = dp.getDocument((Object)editor.getEditorInput());
        String selectedText = "";
        try {
            selectedText = doc.get(selectionOffset, selectionLength);
        }
        catch (BadLocationException badLocationException) {}
        final IntegerHolder cursorPosition = new IntegerHolder();
        String content = this.getExpandedContent(selectedText, cursorPosition);
        if (content != null) {
            final int contentLength = content.length();
            try {
                doc.replace(selectionOffset, selectionLength, content);
                IWorkbench workbench = PlatformUI.getWorkbench();
                Display display = workbench.getDisplay();
                display.asyncExec(new Runnable(){

                    public void run() {
                        if (cursorPosition.cursorPosition != -1) {
                            ((IUnifiedEditor)editor).getViewer().getTextWidget().setCaretOffset(selectionOffset + cursorPosition.cursorPosition);
                        } else {
                            editor.selectAndReveal(selectionOffset, contentLength);
                        }
                    }
                });
            }
            catch (BadLocationException badLocationException) {}
        }
    }

    public String getTooltip() {
        String string = this._metadata.get(TOOLTIP_KEY);
        return string != null ? string : this.getName();
    }

    static class IntegerHolder {
        int cursorPosition = -1;

        IntegerHolder() {
        }
    }
}

