/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialMapping;
import artofillusion.math.BoundingBox;
import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.object.ImplicitObject;
import artofillusion.raytracer.RTObject;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.SurfaceIntersection;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.texture.UniformMapping;

public class RTImplicitObject
extends RTObject {
    private ImplicitObject theObject;
    private double minx;
    private double miny;
    private double minz;
    private double maxx;
    private double maxy;
    private double maxz;
    private double[] param;
    private double tol;
    private boolean bumpMapped;
    private Mat4 toLocal;
    private Mat4 fromLocal;
    public static final double TOL = 1.0E-12;

    public RTImplicitObject(ImplicitObject implicit, Mat4 fromLocal, Mat4 toLocal, double[] param, double tol) {
        BoundingBox bounds = implicit.getBounds();
        this.minx = bounds.minx;
        this.miny = bounds.miny;
        this.minz = bounds.minz;
        this.maxx = bounds.maxx;
        this.maxy = bounds.maxy;
        this.maxz = bounds.maxz;
        this.theObject = implicit;
        this.param = param;
        this.tol = tol;
        this.bumpMapped = implicit.getTexture().hasComponent(5);
        this.toLocal = toLocal;
        this.fromLocal = fromLocal;
    }

    public final TextureMapping getTextureMapping() {
        return this.theObject.getTextureMapping();
    }

    public final MaterialMapping getMaterialMapping() {
        return this.theObject.getMaterialMapping();
    }

    protected SurfaceIntersection checkIntersection(Ray r) {
        double prevValue;
        double t2;
        double t1;
        Vec3 rorig = r.getOrigin();
        Vec3 rdir = r.getDirection();
        Vec3 origin = r.tempVec1;
        origin.set(rorig);
        this.toLocal.transform(origin);
        Vec3 direction = r.tempVec2;
        direction.set(rdir);
        this.toLocal.transformDirection(direction);
        double mint = -1.7976931348623157E308;
        double maxt = Double.MAX_VALUE;
        if (direction.x == 0.0) {
            if (origin.x < this.minx || origin.x > this.maxx) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        } else {
            t1 = (this.minx - origin.x) / direction.x;
            t2 = (this.maxx - origin.x) / direction.x;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 1.0E-12) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        }
        if (direction.y == 0.0) {
            if (origin.y < this.miny || origin.y > this.maxy) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        } else {
            t1 = (this.miny - origin.y) / direction.y;
            t2 = (this.maxy - origin.y) / direction.y;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 1.0E-12) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        }
        if (direction.z == 0.0) {
            if (origin.z < this.minz || origin.z > this.maxz) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        } else {
            t1 = (this.minz - origin.z) / direction.z;
            t2 = (this.maxz - origin.z) / direction.z;
            if (t1 < t2) {
                if (t1 > mint) {
                    mint = t1;
                }
                if (t2 < maxt) {
                    maxt = t2;
                }
            } else {
                if (t2 > mint) {
                    mint = t2;
                }
                if (t1 < maxt) {
                    maxt = t1;
                }
            }
            if (mint > maxt || maxt < 1.0E-12) {
                return SurfaceIntersection.NO_INTERSECTION;
            }
        }
        double time = r.rt.rt.time;
        boolean wasInside = false;
        double t = mint;
        double cutoff = this.theObject.getCutoff();
        if (mint < 0.0) {
            t = 0.0;
            prevValue = this.theObject.getFieldValue(origin.x, origin.y, origin.z, this.tol, time);
            wasInside = prevValue > cutoff;
        } else {
            double x = origin.x + t * direction.x;
            double y = origin.y + t * direction.y;
            double z = origin.z + t * direction.z;
            prevValue = this.theObject.getFieldValue(x, y, z, this.tol, time);
            if (prevValue > cutoff && mint > this.tol) {
                Vec3 pos = r.tempVec3;
                pos.set(x, y, z);
                Vec3 norm = r.tempVec4;
                this.projectPoint(pos, norm);
                ImplicitIntersection intersect = (ImplicitIntersection)r.rt.rtImplicitPool.getObject();
                intersect.init(this, pos, t, norm, origin, direction, r, maxt);
                return intersect;
            }
        }
        double prevT = t;
        double stepScale = 1.0 / this.theObject.getMaxGradient();
        while (t < maxt) {
            double z;
            double y;
            double x;
            double value;
            boolean inside;
            double nextStep = Math.abs(stepScale * (prevValue - cutoff));
            if (nextStep < this.tol) {
                nextStep = this.tol;
            }
            if ((t += nextStep) > maxt) {
                t = maxt;
            }
            boolean bl = inside = (value = this.theObject.getFieldValue(x = origin.x + t * direction.x, y = origin.y + t * direction.y, z = origin.z + t * direction.z, this.tol, time)) > cutoff;
            if (inside != wasInside) {
                double trueT = t;
                if (t != prevT && value != prevValue) {
                    trueT = prevT + (cutoff - prevValue) * (t - prevT) / (value - prevValue);
                    x = origin.x + trueT * direction.x;
                    y = origin.y + trueT * direction.y;
                    z = origin.z + trueT * direction.z;
                }
                if (trueT < this.tol) {
                    wasInside = inside;
                } else {
                    Vec3 pos = r.tempVec3;
                    pos.set(x, y, z);
                    Vec3 norm = r.tempVec4;
                    this.theObject.getFieldGradient(x, y, z, this.tol, time, norm);
                    norm.scale(-1.0 / norm.length());
                    if (Double.isNaN(norm.x)) {
                        norm.set(1.0, 0.0, 0.0);
                    }
                    this.fromLocal.transform(pos);
                    this.fromLocal.transformDirection(norm);
                    ImplicitIntersection intersect = (ImplicitIntersection)r.rt.rtImplicitPool.getObject();
                    intersect.init(this, pos, trueT, norm, origin, direction, r, maxt);
                    return intersect;
                }
            }
            prevT = t;
            prevValue = value;
        }
        if (wasInside) {
            double x = origin.x + t * direction.x;
            double y = origin.y + t * direction.y;
            double z = origin.z + t * direction.z;
            Vec3 pos = r.tempVec3;
            pos.set(x, y, z);
            Vec3 norm = r.tempVec4;
            this.projectPoint(pos, norm);
            ImplicitIntersection intersect = (ImplicitIntersection)r.rt.rtImplicitPool.getObject();
            intersect.init(this, pos, t, norm, origin, direction, r, maxt);
            return intersect;
        }
        return SurfaceIntersection.NO_INTERSECTION;
    }

    private void projectPoint(Vec3 pos, Vec3 normal) {
        int side = 0;
        double mindist = Math.abs(pos.x - this.minx);
        double dist = Math.abs(pos.x - this.maxx);
        if (dist < mindist) {
            mindist = dist;
            side = 1;
        }
        if ((dist = Math.abs(pos.y - this.miny)) < mindist) {
            mindist = dist;
            side = 2;
        }
        if ((dist = Math.abs(pos.y - this.maxy)) < mindist) {
            mindist = dist;
            side = 3;
        }
        if ((dist = Math.abs(pos.z - this.minz)) < mindist) {
            mindist = dist;
            side = 4;
        }
        if ((dist = Math.abs(pos.z - this.maxz)) < mindist) {
            mindist = dist;
            side = 5;
        }
        if (side == 0) {
            pos.x = this.minx;
        } else if (side == 1) {
            pos.x = this.maxx;
        } else if (side == 2) {
            pos.y = this.miny;
        } else if (side == 3) {
            pos.y = this.maxy;
        } else if (side == 4) {
            pos.z = this.minz;
        } else if (side == 5) {
            pos.z = this.maxz;
        }
        this.fromLocal.transform(pos);
        if (side == 0) {
            normal.set(-1.0, 0.0, 0.0);
        }
        if (side == 1) {
            normal.set(1.0, 0.0, 0.0);
        }
        if (side == 2) {
            normal.set(0.0, -1.0, 0.0);
        }
        if (side == 3) {
            normal.set(0.0, 1.0, 0.0);
        }
        if (side == 4) {
            normal.set(0.0, 0.0, -1.0);
        }
        if (side == 5) {
            normal.set(0.0, 0.0, 1.0);
        }
        this.fromLocal.transformDirection(normal);
    }

    public BoundingBox getBounds() {
        BoundingBox bounds = new BoundingBox(this.minx, this.maxx, this.miny, this.maxy, this.minz, this.maxz);
        bounds = bounds.transformAndOutset(this.fromLocal);
        return bounds;
    }

    public boolean intersectsBox(BoundingBox bb) {
        return bb.intersects(this.getBounds());
    }

    public Mat4 toLocal() {
        return this.toLocal;
    }

    public static class ImplicitIntersection
    implements SurfaceIntersection {
        private RTImplicitObject obj;
        private double[] tint = new double[1];
        private double maxt;
        private Vec3[] rint = new Vec3[]{new Vec3()};
        private Vec3 pos = new Vec3();
        private Vec3 orig = new Vec3();
        private Vec3 dir = new Vec3();
        private Vec3 norm = new Vec3();
        private int numIntersections;
        private Ray ray;

        public void init(RTImplicitObject obj, Vec3 point1, double dist1, Vec3 trueNorm, Vec3 origin, Vec3 direction, Ray ray, double maxDist) {
            this.obj = obj;
            this.ray = ray;
            this.numIntersections = -1;
            this.tint[0] = dist1;
            this.rint[0].set(point1);
            this.orig.set(origin);
            this.dir.set(direction);
            this.norm.set(trueNorm);
            this.maxt = maxDist;
        }

        public int numIntersections() {
            if (this.numIntersections == -1) {
                this.findAllIntersections();
            }
            return this.numIntersections;
        }

        public void intersectionPoint(int n, Vec3 p) {
            p.set(this.rint[n]);
        }

        public double intersectionDist(int n) {
            return this.tint[n];
        }

        public void intersectionProperties(TextureSpec spec, Vec3 n, Vec3 viewDir, double size, double time) {
            n.set(this.norm);
            TextureMapping map = this.obj.theObject.getTextureMapping();
            this.pos.set(this.rint[0]);
            if (map instanceof UniformMapping) {
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.obj.param);
            } else {
                this.obj.toLocal.transform(this.pos);
                map.getTextureSpec(this.pos, spec, -n.dot(viewDir), size, time, this.obj.param);
            }
            if (this.obj.bumpMapped) {
                this.obj.fromLocal.transformDirection(spec.bumpGrad);
                n.scale(spec.bumpGrad.dot(n) + 1.0);
                n.subtract(spec.bumpGrad);
                n.normalize();
            }
        }

        public void intersectionTransparency(int n, RGBColor trans, double angle, double size, double time) {
            TextureMapping map = this.obj.theObject.getTextureMapping();
            this.pos.set(this.rint[n]);
            if (map instanceof UniformMapping) {
                map.getTransparency(this.pos, trans, angle, size, time, this.obj.param);
            } else {
                this.obj.toLocal.transform(this.pos);
                map.getTransparency(this.pos, trans, angle, size, time, this.obj.param);
            }
        }

        public void trueNormal(Vec3 n) {
            n.set(this.norm);
        }

        private void findAllIntersections() {
            double t;
            double cutoff = this.obj.theObject.getCutoff();
            double time = this.ray.rt.rt.time;
            double prevT = t = this.tint[0];
            double x = this.orig.x + t * this.dir.x;
            double y = this.orig.y + t * this.dir.y;
            double z = this.orig.z + t * this.dir.z;
            double prevValue = this.obj.theObject.getFieldValue(x, y, z, this.obj.tol, time);
            boolean wasInside = this.norm.dot(this.ray.getDirection()) < 0.0;
            this.numIntersections = 1;
            while (t < this.maxt) {
                boolean inside;
                if ((t += this.obj.tol) > this.maxt) {
                    t = this.maxt;
                }
                x = this.orig.x + t * this.dir.x;
                y = this.orig.y + t * this.dir.y;
                z = this.orig.z + t * this.dir.z;
                double value = this.obj.theObject.getFieldValue(x, y, z, this.obj.tol, time);
                boolean bl = inside = value > cutoff;
                if (inside != wasInside || t == this.maxt && wasInside) {
                    if (this.numIntersections == this.tint.length) {
                        int j;
                        double[] newt = new double[this.numIntersections * 2];
                        Vec3[] newr = new Vec3[this.numIntersections * 2];
                        for (j = 0; j < this.tint.length; ++j) {
                            newt[j] = this.tint[j];
                            newr[j] = this.rint[j];
                        }
                        for (j = this.tint.length; j < newt.length; ++j) {
                            newr[j] = new Vec3();
                        }
                        this.tint = newt;
                        this.rint = newr;
                    }
                    double trueT = t;
                    if (t != prevT && value != prevValue && inside != wasInside) {
                        trueT = prevT + (cutoff - prevValue) * (t - prevT) / (value - prevValue);
                        x = this.orig.x + trueT * this.dir.x;
                        y = this.orig.y + trueT * this.dir.y;
                        z = this.orig.z + trueT * this.dir.z;
                    }
                    this.tint[this.numIntersections] = trueT;
                    this.rint[this.numIntersections].set(this.ray.origin.x + trueT * this.ray.direction.x, this.ray.origin.y + trueT * this.ray.direction.y, this.ray.origin.z + trueT * this.ray.direction.z);
                    ++this.numIntersections;
                }
                wasInside = value > cutoff;
                prevT = t;
                prevValue = value;
            }
        }
    }
}

