/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.material.MaterialSpec;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonList;
import artofillusion.raytracer.PhotonMap;
import artofillusion.texture.TextureSpec;

public class PhotonMapContext {
    private PhotonMap map;
    public PhotonList nearbyPhotons;
    public RGBColor tempColor;
    public RGBColor tempColor2;
    public Vec3 tempVec;
    public Vec3 lastPos;
    public float lastCutoff2;

    public PhotonMapContext(PhotonMap map) {
        this.map = map;
        this.tempColor = new RGBColor();
        this.tempColor2 = new RGBColor();
        this.tempVec = new Vec3();
        this.lastPos = new Vec3();
        this.nearbyPhotons = new PhotonList(map.getNumToEstimate());
        this.lastCutoff2 = 99999.0f;
    }

    public void getLight(Vec3 pos, TextureSpec spec, Vec3 normal, Vec3 viewDir, boolean front, RGBColor light) {
        this.map.getLight(pos, spec, normal, viewDir, front, light, this);
    }

    public void getVolumeLight(Vec3 pos, MaterialSpec spec, Vec3 viewDir, RGBColor light) {
        this.map.getVolumeLight(pos, spec, viewDir, light, this);
    }
}

