/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.raytracer;

import artofillusion.math.Mat4;
import artofillusion.math.RGBColor;
import artofillusion.math.Vec3;
import artofillusion.raytracer.PhotonMap;
import artofillusion.raytracer.PhotonSource;
import artofillusion.raytracer.RTCube;
import artofillusion.raytracer.Ray;
import artofillusion.raytracer.Raytracer;
import artofillusion.texture.TextureMapping;
import artofillusion.texture.TextureSpec;
import artofillusion.util.ThreadManager;

public class CubePhotonSource
implements PhotonSource {
    private RTCube cube;
    private double bottomP;
    private double topP;
    private double leftP;
    private double rightP;
    private double backP;
    private double[] param;
    private Mat4 fromLocal;
    private TextureMapping texMap;
    private RGBColor color;
    private float lightIntensity;

    public CubePhotonSource(RTCube obj, PhotonMap map) {
        this.cube = obj;
        double xsize = this.cube.maxx - this.cube.minx;
        double ysize = this.cube.maxy - this.cube.miny;
        double zsize = this.cube.maxz - this.cube.minz;
        double xyarea = xsize * ysize;
        double xzarea = xsize * zsize;
        double yzarea = ysize * zsize;
        double totalArea = 2.0 * (xyarea + xzarea + yzarea);
        double invArea = 1.0 / totalArea;
        this.bottomP = xzarea * invArea;
        this.topP = this.bottomP + xzarea * invArea;
        this.leftP = this.topP + yzarea * invArea;
        this.rightP = this.leftP + yzarea * invArea;
        this.backP = this.rightP + xyarea * invArea;
        this.fromLocal = obj.fromLocal;
        this.param = obj.param;
        this.texMap = obj.getTextureMapping();
        this.color = new RGBColor();
        TextureSpec spec = map.getContext().surfSpec[0];
        this.texMap.getTexture().getAverageSpec(spec, map.getRaytracer().time, obj.param);
        this.color.copy(spec.emissive);
        this.lightIntensity = 0.5f * (this.color.getRed() + this.color.getGreen() + this.color.getBlue()) * (float)totalArea;
        if (this.texMap.appliesTo() == 0) {
            this.lightIntensity *= 2.0f;
        }
    }

    public double getTotalIntensity() {
        return this.lightIntensity;
    }

    public void generatePhotons(PhotonMap map, double intensity, ThreadManager threads) {
        Ray r = new Ray(map.getContext());
        Vec3 orig = r.getOrigin();
        Vec3 norm = new Vec3();
        double xsize = this.cube.maxx - this.cube.minx;
        double ysize = this.cube.maxy - this.cube.miny;
        double zsize = this.cube.maxz - this.cube.minz;
        for (double emittedIntensity = 0.0; emittedIntensity < intensity; emittedIntensity += (double)this.generateOnePhoton(map, r, norm)) {
            double p = map.random.nextDouble();
            double u = map.random.nextDouble() - 0.5;
            double v = map.random.nextDouble() - 0.5;
            if (p < this.bottomP) {
                orig.set(xsize * u + this.cube.minx, this.cube.miny, zsize * v + this.cube.minz);
                norm.set(0.0, -1.0, 0.0);
                continue;
            }
            if (p < this.topP) {
                orig.set(xsize * u + this.cube.minx, this.cube.maxy, zsize * v + this.cube.minz);
                norm.set(0.0, 1.0, 0.0);
                continue;
            }
            if (p < this.leftP) {
                orig.set(this.cube.minx, ysize * u + this.cube.miny, zsize * v + this.cube.minz);
                norm.set(-1.0, 0.0, 0.0);
                continue;
            }
            if (p < this.rightP) {
                orig.set(this.cube.maxx, ysize * u + this.cube.miny, zsize * v + this.cube.minz);
                norm.set(1.0, 0.0, 0.0);
                continue;
            }
            if (p < this.backP) {
                orig.set(xsize * u + this.cube.minx, ysize * v + this.cube.miny, this.cube.minz);
                norm.set(0.0, 0.0, -1.0);
                continue;
            }
            orig.set(xsize * u + this.cube.minx, ysize * v + this.cube.miny, this.cube.maxz);
            norm.set(0.0, 0.0, 1.0);
        }
    }

    private float generateOnePhoton(PhotonMap map, Ray r, Vec3 norm) {
        double dot;
        double absdot;
        Raytracer rt = map.getRaytracer();
        TextureSpec spec = r.rt.surfSpec[0];
        Vec3 dir = r.getDirection();
        float intensity = 1.0f;
        do {
            dir.set(0.0, 0.0, 0.0);
            map.randomizePoint(dir, 1.0);
            dir.normalize();
        } while ((absdot = (dot = norm.dot(dir)) > 0.0 ? dot : -dot) < map.random.nextDouble());
        if (!this.texMap.appliesToFace(dot > 0.0)) {
            dot = -dot;
            dir.scale(-1.0);
        }
        this.texMap.getTextureSpec(dir, spec, dot, rt.smoothScale, rt.time, this.param);
        this.color.copy(spec.emissive);
        intensity = this.color.getRed() + this.color.getGreen() + this.color.getBlue();
        if ((double)intensity < 1.0) {
            if (intensity < map.random.nextFloat()) {
                return intensity;
            }
            this.color.scale(1.0f / intensity);
        }
        if (this.fromLocal != null) {
            this.fromLocal.transform(r.getOrigin());
            this.fromLocal.transformDirection(dir);
        } else {
            Vec3 orig = r.getOrigin();
            orig.x += 0.5 * (this.cube.minx + this.cube.maxx);
            orig.y += 0.5 * (this.cube.miny + this.cube.maxy);
            orig.z += 0.5 * (this.cube.minz + this.cube.maxz);
        }
        r.newID();
        map.spawnPhoton(r, this.color, true);
        return intensity;
    }
}

