/*
 * Decompiled with CFR 0.152.
 */
package artofillusion.tools;

import artofillusion.LayoutWindow;
import artofillusion.Scene;
import artofillusion.UndoRecord;
import artofillusion.math.BoundingBox;
import artofillusion.math.CoordinateSystem;
import artofillusion.math.Mat4;
import artofillusion.math.Vec3;
import artofillusion.object.Curve;
import artofillusion.object.MeshVertex;
import artofillusion.object.NullObject;
import artofillusion.object.Object3D;
import artofillusion.object.ObjectInfo;
import artofillusion.ui.EditingWindow;
import java.util.Vector;

public class ArraySpec {
    public static final int METHOD_LINEAR = 0;
    public static final int METHOD_CURVE = 1;
    public static final int MODE_STEP = 0;
    public static final int MODE_COPIES = 1;
    private static final int SD_LEVEL = 5;
    private LayoutWindow window;
    private UndoRecord undo;
    private ObjectInfo arrayRoot;
    public int method;
    public Vector objectList;
    public int linearCopies;
    public double stepX;
    public double stepY;
    public double stepZ;
    public boolean intervalX;
    public boolean intervalY;
    public boolean intervalZ;
    public ObjectInfo curve;
    public int curveMode;
    public int curveCopies;
    public double curveStep;
    public boolean curveInterval;
    public boolean orientation;
    public boolean ignoreOrigin;
    public boolean ignoreOrientation;
    public boolean dupFirst;
    public boolean group;
    public boolean live;
    public boolean deep;

    public ArraySpec(LayoutWindow win) {
        this.window = win;
        Scene scene = this.window.getScene();
        int[] selection = scene.getSelection();
        this.objectList = new Vector();
        for (int sel = 0; sel < selection.length; ++sel) {
            ObjectInfo info = scene.getObject(selection[sel]);
            this.objectList.addElement(info);
        }
        this.method = 0;
        this.linearCopies = 10;
        this.stepX = 1.0;
        this.stepY = 0.0;
        this.stepZ = 0.0;
        this.intervalX = true;
        this.intervalY = false;
        this.intervalZ = false;
        this.curve = null;
        this.curveMode = 1;
        this.curveCopies = 10;
        this.curveStep = 0.1;
        this.orientation = true;
        this.ignoreOrigin = true;
        this.ignoreOrientation = true;
        this.dupFirst = true;
        this.group = true;
        this.deep = true;
        this.live = false;
    }

    public void createArray() {
        this.undo = new UndoRecord((EditingWindow)this.window, false);
        ObjectInfo info = (ObjectInfo)this.objectList.elementAt(0);
        String name = "Array of " + info.name;
        CoordinateSystem coords = new CoordinateSystem(new Vec3(0.0, 0.0, 0.0), Vec3.vz(), Vec3.vy());
        if (this.method == 1 && this.curve != null) {
            coords = this.curve.coords.duplicate();
        } else if (this.method == 0) {
            Vec3 displacement = new Vec3(this.stepX, this.stepY, this.stepZ);
            BoundingBox bounds = info.object.getBounds();
            if (this.intervalX) {
                displacement.x *= bounds.getSize().x;
            }
            if (this.intervalY) {
                displacement.y *= bounds.getSize().y;
            }
            if (this.intervalZ) {
                displacement.z *= bounds.getSize().z;
            }
            displacement = displacement.times(((double)this.linearCopies - 1.0) / 2.0);
            coords = info.coords.duplicate();
            Mat4 dis = Mat4.translation((double)displacement.x, (double)displacement.y, (double)displacement.z);
            coords.transformOrigin(dis);
        }
        this.arrayRoot = new ObjectInfo((Object3D)new NullObject(), coords, name);
        if (this.group) {
            this.window.addObject(this.arrayRoot, this.undo);
        }
        if (this.method == 0) {
            this.createLinearArray();
        } else if (this.method == 1) {
            this.createCurveArray();
        }
        this.window.setUndoRecord(this.undo);
        this.window.rebuildItemList();
        this.window.updateImage();
    }

    private void createLinearArray() {
        if (this.method != 0) {
            return;
        }
        for (int i = 0; i < this.objectList.size(); ++i) {
            int start;
            ObjectInfo info = (ObjectInfo)this.objectList.elementAt(i);
            Vec3 displacement = new Vec3(this.stepX, this.stepY, this.stepZ);
            BoundingBox bounds = info.object.getBounds();
            if (this.intervalX) {
                displacement.x *= bounds.getSize().x;
            }
            if (this.intervalY) {
                displacement.y *= bounds.getSize().y;
            }
            if (this.intervalZ) {
                displacement.z *= bounds.getSize().z;
            }
            for (int n = start = this.dupFirst ? 0 : 1; n < this.linearCopies; ++n) {
                this.createCopy(info, displacement.times((double)n));
            }
        }
        this.window.updateImage();
    }

    private void createCurveArray() {
        if (this.method != 1) {
            return;
        }
        if (this.curve == null) {
            return;
        }
        Curve cv = (Curve)this.curve.object;
        MeshVertex[] vert = cv.getVertices();
        Vec3[] v = new Vec3[vert.length];
        Mat4 trans = this.curve.coords.fromLocal();
        for (int i = 0; i < v.length; ++i) {
            v[i] = trans.times(vert[i].r);
        }
        Vec3[] subdiv = new Curve(v, cv.getSmoothness(), cv.getSmoothingMethod(), cv.isClosed()).subdivideCurve(5).getVertexPositions();
        int startCount = this.dupFirst ? 0 : 1;
        double curveLength = this.calcCurveLength(cv);
        if (this.curveMode == 1) {
            if (this.curveCopies < 1) {
                this.curveCopies = 1;
            }
            this.curveStep = curveLength / (double)(this.curveCopies + (cv.isClosed() ? 1 : 0));
        } else {
            if (this.curveStep / curveLength < 0.001) {
                this.curveStep = 0.001 * curveLength;
            }
            this.curveCopies = (int)(curveLength / this.curveStep);
        }
        Vec3[] zdir = new Vec3[subdiv.length];
        Vec3[] updir = new Vec3[subdiv.length];
        this.constructMinRotFrame(subdiv, cv.isClosed(), zdir, updir);
        CoordinateSystem startCS = new CoordinateSystem(subdiv[0], zdir[0], updir[0]);
        for (int i = 0; i < this.objectList.size(); ++i) {
            ObjectInfo info = (ObjectInfo)this.objectList.elementAt(i);
            for (int n = startCount; n < this.curveCopies; ++n) {
                Vec3 updir_return = new Vec3(0.0, 0.0, 0.0);
                Vec3 zdir_return = new Vec3(0.0, 0.0, 0.0);
                double relativePos = (double)n * curveLength / (double)(this.curveCopies - 1 + (cv.isClosed() ? 1 : 0));
                CoordinateSystem curveCS = this.findCoordinateSystem(subdiv, cv.isClosed(), relativePos, zdir, updir);
                CoordinateSystem newCS = info.coords.duplicate();
                if (this.ignoreOrigin) {
                    newCS.setOrigin(startCS.getOrigin());
                }
                if (this.ignoreOrientation) {
                    newCS.setOrientation(startCS.getZDirection(), startCS.getUpDirection());
                }
                newCS.transformOrigin(startCS.toLocal());
                newCS.transformAxes(startCS.toLocal());
                newCS.transformOrigin(curveCS.fromLocal());
                if (this.orientation) {
                    newCS.transformAxes(curveCS.fromLocal());
                }
                this.createCopy(info, newCS);
            }
        }
        this.window.updateImage();
    }

    private ObjectInfo createCopy(ObjectInfo info, Vec3 displacement) {
        Mat4 trans = Mat4.translation((double)displacement.x, (double)displacement.y, (double)displacement.z);
        return this.createCopy(info, trans);
    }

    private ObjectInfo createCopy(ObjectInfo info, CoordinateSystem cs) {
        Mat4 trans = cs.fromLocal().times(info.coords.toLocal());
        return this.createCopy(info, trans);
    }

    private ObjectInfo createCopy(ObjectInfo info, Mat4 trans) {
        ObjectInfo newinfo = info.duplicate();
        if (!this.live) {
            newinfo.object = info.object.duplicate();
        }
        newinfo.coords.transformCoordinates(trans);
        this.window.addObject(newinfo, this.undo);
        if (this.group) {
            this.arrayRoot.addChild(newinfo, 0);
        }
        if (this.deep) {
            for (int i = 0; i < info.children.length; ++i) {
                newinfo.addChild(this.createChildCopy(info.children[i], trans), i);
            }
        }
        return newinfo;
    }

    private ObjectInfo createChildCopy(ObjectInfo info, Mat4 trans) {
        ObjectInfo newinfo = info.duplicate();
        if (!this.live) {
            newinfo.object = info.object.duplicate();
        }
        newinfo.coords.transformCoordinates(trans);
        this.window.addObject(newinfo, this.undo);
        for (int i = 0; i < info.children.length; ++i) {
            newinfo.addChild(this.createChildCopy(info.children[i], trans), i);
        }
        return newinfo;
    }

    private double calcCurveLength(Curve c) {
        Vec3[] subdiv = c.subdivideCurve(5).getVertexPositions();
        double sum = 0.0;
        for (int i = 1; i < subdiv.length; ++i) {
            sum += subdiv[i].distance(subdiv[i - 1]);
        }
        if (c.isClosed()) {
            sum += subdiv[subdiv.length - 1].distance(subdiv[0]);
        }
        return sum;
    }

    private Vec3 findPointOnCurve(Vec3[] subdiv, boolean isClosed, double relativePosition) {
        int i;
        double sum = 0.0;
        double prevsum = 0.0;
        for (i = 1; i < subdiv.length; ++i) {
            prevsum = sum;
            if ((sum += subdiv[i].distance(subdiv[i - 1])) >= relativePosition) break;
        }
        int prev_i = i - 1;
        if (sum < relativePosition) {
            if (isClosed) {
                prevsum = sum;
                sum += subdiv[subdiv.length - 1].distance(subdiv[0]);
                prev_i = subdiv.length - 1;
                i = 0;
            } else {
                prev_i = --i - 2;
            }
        }
        double interval = sum - prevsum;
        return subdiv[i].times((relativePosition - prevsum) / interval).plus(subdiv[prev_i].times((sum - relativePosition) / interval));
    }

    private void constructMinRotFrame(Vec3[] subdiv, boolean isClosed, Vec3[] zdir, Vec3[] updir) {
        Vec3[] t = new Vec3[subdiv.length];
        t[0] = subdiv[1].minus(subdiv[0]);
        t[0].normalize();
        zdir[0] = Vec3.vz();
        updir[0] = Vec3.vy();
        double zfrac1 = t[0].dot(zdir[0]);
        double zfrac2 = Math.sqrt(1.0 - zfrac1 * zfrac1);
        Vec3 dir1 = zdir[0].minus(t[0].times(zfrac1));
        dir1.normalize();
        double upfrac1 = t[0].dot(updir[0]);
        double upfrac2 = Math.sqrt(1.0 - upfrac1 * upfrac1);
        Vec3 dir2 = updir[0].minus(t[0].times(upfrac1));
        dir2.normalize();
        for (int i = 1; i < subdiv.length; ++i) {
            t[i] = i == subdiv.length - 1 ? (isClosed ? subdiv[0].minus(subdiv[subdiv.length - 2]) : subdiv[subdiv.length - 1].minus(subdiv[subdiv.length - 2])) : subdiv[i + 1].minus(subdiv[i - 1]);
            t[i].normalize();
            dir1 = dir1.minus(t[i].times(t[i].dot(dir1)));
            dir1.normalize();
            dir2 = dir2.minus(t[i].times(t[i].dot(dir2)));
            dir2.normalize();
            zdir[i] = t[i].times(zfrac1).plus(dir1.times(zfrac2));
            updir[i] = t[i].times(upfrac1).plus(dir2.times(upfrac2));
        }
    }

    private CoordinateSystem findCoordinateSystem(Vec3[] subdiv, boolean isClosed, double relativePosition, Vec3[] zdirs, Vec3[] updirs) {
        int i;
        double sum = 0.0;
        double prevsum = 0.0;
        for (i = 1; i < subdiv.length; ++i) {
            prevsum = sum;
            if ((sum += subdiv[i].distance(subdiv[i - 1])) >= relativePosition) break;
        }
        int prev_i = i - 1;
        if (sum < relativePosition) {
            if (isClosed) {
                prevsum = sum;
                sum += subdiv[subdiv.length - 1].distance(subdiv[0]);
                prev_i = subdiv.length - 1;
                i = 0;
            } else {
                prev_i = --i - 2;
            }
        }
        double interval = sum - prevsum;
        Vec3 pos = subdiv[i].times((relativePosition - prevsum) / interval).plus(subdiv[prev_i].times((sum - relativePosition) / interval));
        Vec3 zdir = zdirs[i].times((relativePosition - prevsum) / interval).plus(zdirs[prev_i].times((sum - relativePosition) / interval));
        Vec3 updir = updirs[i].times((relativePosition - prevsum) / interval).plus(updirs[prev_i].times((sum - relativePosition) / interval));
        return new CoordinateSystem(pos, zdir, updir);
    }
}

